/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Hint;
import org.neo4j.cypherdsl.core.Pattern;
import org.neo4j.cypherdsl.core.ReadingClause;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class Match
implements ReadingClause {
    private final boolean optional;
    private final Pattern pattern;
    private final List<Hint> hints;
    private final Where optionalWhere;

    Match(boolean optional, Pattern pattern, Where optionalWhere, List<Hint> optionalHints) {
        this.optional = optional;
        this.pattern = pattern;
        this.optionalWhere = optionalWhere;
        this.hints = optionalHints == null ? Collections.emptyList() : new ArrayList<Hint>(optionalHints);
    }

    @API(status=API.Status.INTERNAL)
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.pattern.accept(visitor);
        this.hints.forEach(value -> value.accept(visitor));
        Visitable.visitIfNotNull(this.optionalWhere, visitor);
        visitor.leave(this);
    }
}

