/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.client.shape.view.impl;

import com.ait.lienzo.client.core.shape.IContainer;
import com.ait.lienzo.client.core.shape.IPrimitive;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.wires.WiresShapeView;
import org.kie.workbench.common.stunner.client.lienzo.shape.view.wires.ext.DecoratedShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGBasicShapeView;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGContainer;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGPrimitive;

public class SVGChildViewHandler {
    private final WiresShapeView<?> view;
    private final List<SVGPrimitive<?>> primChildren = new LinkedList();
    private final List<SVGBasicShapeView> svgChildren = new LinkedList<SVGBasicShapeView>();

    public SVGChildViewHandler(WiresShapeView<?> view) {
        this.view = view;
    }

    public void addChild(SVGPrimitive<?> child) {
        Object primitive = child.get();
        this.primChildren.add(child);
        if (child.isScalable() && this.view instanceof DecoratedShapeView) {
            ((DecoratedShapeView)this.view).addScalableChild(primitive);
        } else if (null != child.getLayout()) {
            this.view.addChild(primitive, child.getLayout());
        } else {
            this.view.addChild(primitive);
        }
    }

    public void addSVGChild(SVGContainer parent, SVGBasicShapeView child) {
        if (!this.hasSvgChild(child)) {
            this.svgChildren.add(child);
            parent.addPrimitive((IPrimitive)child.getContainer());
        }
    }

    public void clear() {
        this.primChildren.forEach(SVGPrimitive::destroy);
        this.primChildren.clear();
        this.svgChildren.forEach(ShapeView::destroy);
        this.svgChildren.clear();
    }

    public Collection<SVGPrimitive<?>> getChildren() {
        return this.primChildren;
    }

    public Collection<SVGBasicShapeView> getSVGChildren() {
        return this.svgChildren;
    }

    private IContainer<?, IPrimitive<?>> getContainer() {
        return this.view.getGroup();
    }

    private boolean hasSvgChild(SVGBasicShapeView child) {
        String name = child.getName();
        return this.svgChildren.stream().anyMatch(c -> name.equals(c.getName()));
    }
}

