/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.client.shape.view;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGContainer;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGPrimitive;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGShapeView;

public class SVGViewUtils {
    public static void switchVisibility(SVGShapeView<?> view, String visibleId, String nonVisibleId) {
        SVGViewUtils.getPrimitive(view, visibleId).ifPresent(prim -> prim.get().setAlpha(1.0));
        SVGViewUtils.getPrimitive(view, nonVisibleId).ifPresent(prim -> prim.get().setAlpha(0.0));
    }

    public static <V extends ShapeView<?>> V getVisibleShape(ShapeView<?> ... views) {
        for (ShapeView<?> view : views) {
            if (!(view.getAlpha() > 0.0)) continue;
            return (V)view;
        }
        return null;
    }

    public static Optional<SVGPrimitive> getPrimitive(SVGShapeView<?> view, String id) {
        return Optional.ofNullable(SVGViewUtils.getPrimitive(view.getChildren(), id));
    }

    public static SVGPrimitive getPrimitive(SVGContainer container, String id) {
        return SVGViewUtils.getPrimitive(container.getChildren(), id);
    }

    public static SVGPrimitive getPrimitive(Collection<SVGPrimitive<?>> primitives, String id) {
        return primitives.stream().map(p -> SVGViewUtils.getPrimitive(p, id)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static SVGPrimitive getPrimitive(SVGPrimitive<?> primitive, String id) {
        if (primitive instanceof SVGContainer) {
            return SVGViewUtils.getPrimitive((SVGContainer)primitive, id);
        }
        return id.equals(primitive.getPrimitiveId()) ? primitive : null;
    }

    public static void setFillAndStroke(SVGShapeView<?> view, String id, double fill, double stroke) {
        SVGViewUtils.getPrimitive(view, id).ifPresent(p -> p.get().setFillAlpha(fill).setStrokeAlpha(stroke));
    }
}

