/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.client.shape.view;

import com.ait.lienzo.client.core.shape.ContainerNode;
import com.ait.lienzo.client.core.shape.Group;
import com.ait.lienzo.client.core.shape.IContainer;
import com.ait.lienzo.client.core.shape.IPrimitive;
import com.ait.lienzo.client.core.shape.wires.LayoutContainer;
import com.ait.tooling.nativetools.client.collection.NFastArrayList;
import java.util.LinkedList;
import java.util.List;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGPrimitive;
import org.kie.workbench.common.stunner.svg.client.shape.view.SVGPrimitiveShape;

public final class SVGContainer
extends SVGPrimitive<Group> {
    private final String id;
    private final List<SVGPrimitive<?>> children;

    public SVGContainer(String id, Group primitive, boolean scalable, LayoutContainer.Layout layout) {
        super(primitive, scalable, layout);
        this.id = id;
        this.children = new LinkedList();
    }

    public SVGContainer addPrimitive(IPrimitive<?> primitive) {
        ContainerNode container = (ContainerNode)this.getPrimitive(this.id);
        if (null != container) {
            container.add(primitive);
        }
        return this;
    }

    public SVGContainer add(SVGPrimitiveShape primitive) {
        this.children.add(primitive);
        this.addPrimitive((IPrimitive<?>)primitive.get());
        return this;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.children.forEach(SVGPrimitive::destroy);
        this.children.clear();
    }

    @Override
    public String getId() {
        return this.id;
    }

    public List<SVGPrimitive<?>> getChildren() {
        return this.children;
    }

    public IPrimitive getPrimitive(String uuid) {
        return SVGContainer.getPrimitive((IContainer)this.get(), uuid);
    }

    private static IPrimitive getPrimitive(IContainer<?, IPrimitive<?>> container, String uuid) {
        if (null != container.getID() && container.getID().equals(uuid)) {
            return (IPrimitive)container;
        }
        NFastArrayList childNodes = container.getChildNodes();
        if (null != childNodes) {
            for (IPrimitive node : childNodes) {
                IPrimitive p;
                if (null != node.getID() && node.getID().equals(uuid)) {
                    return node;
                }
                if (!(node instanceof IContainer) || null == (p = SVGContainer.getPrimitive((IContainer)node, uuid))) continue;
                return p;
            }
        }
        return null;
    }
}

