/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.svg.client.shape.factory;

import java.lang.annotation.Annotation;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeDefFactory;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeDefFunctionalFactory;
import org.kie.workbench.common.stunner.core.definition.shape.ShapeDef;
import org.kie.workbench.common.stunner.svg.client.shape.SVGShape;
import org.kie.workbench.common.stunner.svg.client.shape.def.SVGShapeDef;
import org.kie.workbench.common.stunner.svg.client.shape.def.SVGShapeViewDef;
import org.kie.workbench.common.stunner.svg.client.shape.impl.SVGMutableShapeImpl;
import org.kie.workbench.common.stunner.svg.client.shape.impl.SVGShapeImpl;
import org.kie.workbench.common.stunner.svg.client.shape.view.impl.SVGShapeViewImpl;

@Dependent
public class SVGShapeFactory
implements ShapeDefFactory<Object, SVGShapeDef, SVGShape<?>> {
    private final SyncBeanManager beanManager;
    private final ShapeDefFunctionalFactory<Object, SVGShapeDef, Shape> functionalFactory;

    protected SVGShapeFactory() {
        this(null, null);
    }

    @Inject
    public SVGShapeFactory(SyncBeanManager beanManager, ShapeDefFunctionalFactory<Object, SVGShapeDef, Shape> functionalFactory) {
        this.beanManager = beanManager;
        this.functionalFactory = functionalFactory;
    }

    @PostConstruct
    public void init() {
        this.functionalFactory.set(SVGShapeDef.class, this::newSVGShape).set(SVGShapeViewDef.class, this::newSVGMutableShape);
    }

    public SVGShape<?> newShape(Object instance, SVGShapeDef shapeDef) {
        return (SVGShape)this.functionalFactory.newShape(instance, (ShapeDef)shapeDef);
    }

    private SVGShape<?> newSVGShape(Object instance, SVGShapeDef shapeDef) {
        return new SVGShapeImpl(this.newSVGShapeView(instance, shapeDef));
    }

    private SVGShape<?> newSVGMutableShape(Object instance, SVGShapeDef shapeDef) {
        SVGShapeViewDef mutableShapeDef = (SVGShapeViewDef)shapeDef;
        SVGShapeViewImpl view = this.newSVGShapeView(instance, mutableShapeDef);
        return new SVGMutableShapeImpl(mutableShapeDef, view);
    }

    private SVGShapeViewImpl newSVGShapeView(Object instance, SVGShapeDef shapeDef) {
        Object factory = this.getViewFactory(shapeDef);
        return (SVGShapeViewImpl)shapeDef.newViewInstance(factory, instance);
    }

    Object getViewFactory(SVGShapeDef def) {
        Class viewFactoryType = def.getViewFactoryType();
        Object factory = this.beanManager.lookupBean(viewFactoryType, new Annotation[0]).getInstance();
        if (null == factory) {
            throw new RuntimeException("No SVG view factory present of type [" + viewFactoryType.getName() + "]");
        }
        return factory;
    }
}

