/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.screens;

import java.util.ArrayList;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.guvnor.common.services.project.client.context.WorkspaceProjectContext;
import org.guvnor.common.services.project.model.Module;
import org.guvnor.common.services.shared.message.Level;
import org.guvnor.messageconsole.events.PublishMessagesEvent;
import org.guvnor.messageconsole.events.SystemMessage;
import org.guvnor.messageconsole.events.UnpublishMessagesEvent;
import org.kie.workbench.common.stunner.client.widgets.notification.AbstractNotification;
import org.kie.workbench.common.stunner.client.widgets.notification.NotificationsObserver;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.uberfire.backend.vfs.Path;

@Dependent
public class ProjectMessagesListener {
    public static final String MESSAGE_TYPE = "Stunner.";
    private final Event<PublishMessagesEvent> publishMessagesEvent;
    private final Event<UnpublishMessagesEvent> unpublishMessagesEvent;
    private final NotificationsObserver notificationsObserver;
    private final SessionManager clientSessionManager;
    private WorkspaceProjectContext workspaceProjectContext;

    protected ProjectMessagesListener() {
        this(null, null, null, null, null);
    }

    @Inject
    public ProjectMessagesListener(NotificationsObserver notificationsObserver, Event<PublishMessagesEvent> publishMessagesEvent, Event<UnpublishMessagesEvent> unpublishMessagesEvent, WorkspaceProjectContext workspaceProjectContext, SessionManager clientSessionManager) {
        this.notificationsObserver = notificationsObserver;
        this.publishMessagesEvent = publishMessagesEvent;
        this.unpublishMessagesEvent = unpublishMessagesEvent;
        this.workspaceProjectContext = workspaceProjectContext;
        this.clientSessionManager = clientSessionManager;
    }

    public void enable() {
        this.notificationsObserver.onCommandExecutionFailed(parameter -> this.fireNotification((AbstractNotification)parameter));
        this.notificationsObserver.onValidationFailed(parameter -> this.fireNotification((AbstractNotification)parameter));
        this.notificationsObserver.onValidationExecuted(parameter -> this.clearMessages((AbstractNotification)parameter));
    }

    private Path getDiagramPath() {
        ClientSession session = this.clientSessionManager.getCurrentSession();
        return session.getCanvasHandler().getDiagram().getMetadata().getPath();
    }

    void fireNotification(AbstractNotification notification) {
        SystemMessage systemMessage = new SystemMessage();
        ArrayList<SystemMessage> messagesList = new ArrayList<SystemMessage>();
        switch (notification.getType()) {
            case ERROR: {
                systemMessage.setLevel(Level.ERROR);
                break;
            }
            case WARNING: {
                systemMessage.setLevel(Level.WARNING);
                break;
            }
            case INFO: {
                systemMessage.setLevel(Level.INFO);
            }
        }
        Path path = this.getDiagramPath();
        systemMessage.setText(notification.getMessage());
        systemMessage.setPath(path);
        systemMessage.setMessageType(this.getMessageType(path));
        messagesList.add(systemMessage);
        PublishMessagesEvent messages = new PublishMessagesEvent();
        messages.setShowSystemConsole(false);
        messages.setMessagesToPublish(messagesList);
        messages.setRootPath(((Module)this.workspaceProjectContext.getActiveModule().get()).getRootPath().toURI());
        this.publishMessagesEvent.fire((Object)messages);
    }

    private String getMessageType(Path path) {
        return MESSAGE_TYPE + path.toURI();
    }

    protected void clearMessages(AbstractNotification notification) {
        UnpublishMessagesEvent unpublishMessagesEvent = new UnpublishMessagesEvent();
        unpublishMessagesEvent.setMessageType(this.getMessageType(this.getDiagramPath()));
        unpublishMessagesEvent.setShowSystemConsole(false);
        unpublishMessagesEvent.setRootPath(((Module)this.workspaceProjectContext.getActiveModule().get()).getRootPath().toURI());
        this.unpublishMessagesEvent.fire((Object)unpublishMessagesEvent);
    }
}

