/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.project.client.preferences;

import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.profile.api.preferences.ProfilePreferences;
import org.kie.workbench.common.stunner.core.api.ProfileManager;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.profile.FullProfile;
import org.kie.workbench.common.stunner.core.profile.Profile;
import org.kie.workbench.common.stunner.project.profile.ProjectProfile;
import org.uberfire.mvp.ParameterizedCommand;

@ApplicationScoped
public class StunnerProfilePreferencesLoader {
    private final ProfileManager profileManager;
    private final ProfilePreferences profilePreferences;
    private final FullProfile defaultProfile;

    @Inject
    public StunnerProfilePreferencesLoader(ProfileManager profileManager, ProfilePreferences profilePreferences, FullProfile defaultProfile) {
        this.profileManager = profileManager;
        this.profilePreferences = profilePreferences;
        this.defaultProfile = defaultProfile;
    }

    public void load(Metadata metadata, ParameterizedCommand<Profile> loadCompleteCallback, ParameterizedCommand<Throwable> errorCallback) {
        this.profilePreferences.load(profilePreferences -> {
            String profileName = profilePreferences.getProfile().getName();
            loadCompleteCallback.execute((Object)this.getProfileByPreference(metadata, profileName).orElse((Profile)this.defaultProfile));
        }, errorCallback);
    }

    private Optional<Profile> getProfileByPreference(Metadata metadata, String profileName) {
        return this.profileManager.getProfiles(metadata.getDefinitionSetId()).stream().filter(profile -> profile instanceof ProjectProfile).filter(profile -> ((ProjectProfile)profile).getProjectProfileName().equals(profileName)).findFirst();
    }
}

