/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.config.init;

import jakarta.servlet.Filter;
import org.jeecg.modules.jmreport.common.a.a;
import org.jeecg.modules.jmreport.common.interceptor.JimuReportSignatureInterceptor;
import org.jeecg.modules.jmreport.config.firewall.interceptor.JimuReportTokenInterceptor;
import org.jeecg.modules.jmreport.config.oss.JmReportUploadConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration(value="jimuReportConfiguration")
@PropertySource(value={"classpath:config/default-config.properties"})
@ComponentScan(value={"org.jeecg.modules.jmreport"})
public class JimuReportConfiguration
implements InitializingBean,
WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(JimuReportConfiguration.class);
    @Autowired
    private JmReportUploadConfig jmReportUploadConfig;

    @Bean
    public JimuReportTokenInterceptor jimuReportInterceptor() {
        return new JimuReportTokenInterceptor();
    }

    @Bean
    public JimuReportSignatureInterceptor jmSignatureInterceptor() {
        return new JimuReportSignatureInterceptor();
    }

    @Bean
    public Filter jmFilter() {
        return new a();
    }

    public void addInterceptors(InterceptorRegistry registry) {
        String[] stringArray = new String[]{"/*.js", "/*.css", "/*.svg", "/*.pdf", "/*.jpg", "/*.png", "/*.ico", "/*.html", "/html/**", "/js/**", "/css/**", "/images/**"};
        registry.addInterceptor((HandlerInterceptor)this.jimuReportInterceptor()).excludePathPatterns(stringArray).addPathPatterns(new String[]{"/jmreport/**"});
        registry.addInterceptor((HandlerInterceptor)this.jmSignatureInterceptor()).addPathPatterns(new String[]{"/jmreport/queryFieldBySql", "/jmreport/loadTableData", "/jmreport/dictCodeSearch"});
    }

    @Bean
    public FilterRegistrationBean jmFilterRegistration() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter(this.jmFilter());
        filterRegistrationBean.setName("jmFilter");
        filterRegistrationBean.addUrlPatterns(new String[]{"/jmreport/queryFieldBySql", "/jmreport/loadTableData", "/jmreport/show", "/jmreport/exportPdfStream", "/jmreport/exportAllExcelStream", "/jmreport/qurestSql", "/jmreport/map/queryMapByCode", "/jmreport/qurestApi", "/jmreport/getCharData"});
        return filterRegistrationBean;
    }

    public void afterPropertiesSet() throws Exception {
        log.info(" Init JimuReport Config [ Token Interceptor & Resource Locations ] ");
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        registry.addResourceHandler(new String[]{"/jmreport/desreport_/**"}).addResourceLocations(new String[]{"classpath:/static/jmreport/desreport_/"});
        registry.addResourceHandler(new String[]{"/jmreport/img/**"}).addResourceLocations(new String[]{"file:" + this.jmReportUploadConfig.getPath().getUpload() + "//"});
    }
}

