/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.jmreport.config.firewall.interceptor;

import com.alibaba.fastjson.JSON;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.jeecg.modules.jmreport.common.annotation.JimuNoLoginRequired;
import org.jeecg.modules.jmreport.common.b.b;
import org.jeecg.modules.jmreport.common.b.h;
import org.jeecg.modules.jmreport.common.b.l;
import org.jeecg.modules.jmreport.common.vo.Result;
import org.jeecg.modules.jmreport.config.JmReportBaseConfig;
import org.jeecg.modules.jmreport.config.client.JmReportTokenClient;
import org.jeecg.modules.jmreport.desreport.service.IJimuReportShareService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class JimuReportTokenInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(JimuReportTokenInterceptor.class);
    @Autowired
    private JmReportTokenClient jimuTokenClient;
    @Autowired
    private JmReportBaseConfig jmBaseConfig;
    @Autowired
    private IJimuReportShareService jimuReportShareService;
    private static String NO_PERMISSION_PROMPT_MSG = "\u6743\u9650\u4e0d\u8db3\uff0c\u6b64\u529f\u80fd\u9700\u8981\u5206\u914d\u89d2\u8272\uff01";
    private static final Integer GEN_TEST_DATA_CODE = 402;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!(handler instanceof HandlerMethod)) {
            return true;
        }
        String string = b.i(request.getRequestURI().substring(request.getContextPath().length()));
        log.debug("JimuReportInterceptor check requestPath = " + string);
        int n2 = 500;
        if (l.a(string)) {
            log.error("\u8bf7\u6ce8\u610f\uff0c\u8bf7\u6c42\u5730\u5740\u6709xss\u653b\u51fb\u98ce\u9669\uff01" + string);
            this.backError(response, "\u8bf7\u6c42\u5730\u5740\u6709xss\u653b\u51fb\u98ce\u9669!", n2);
            return false;
        }
        Object object = this.jmBaseConfig.getCustomPrePath();
        log.debug("customPrePath: {}", object);
        if (h.d(object) && !((String)object).startsWith("/")) {
            object = "/" + (String)object;
        }
        request.setAttribute("customPrePath", object);
        HandlerMethod handlerMethod = (HandlerMethod)handler;
        Method method = handlerMethod.getMethod();
        if (string.contains("/jmreport/shareView/")) {
            return true;
        }
        JimuNoLoginRequired jimuNoLoginRequired = method.getAnnotation(JimuNoLoginRequired.class);
        if (h.d(jimuNoLoginRequired)) {
            return true;
        }
        boolean bl = false;
        try {
            bl = this.verifyToken(request);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!bl) {
            if (this.jimuReportShareService.isSharingEffective(string, request)) {
                return true;
            }
            String string2 = request.getParameter("previousPage");
            if (h.d((Object)string2)) {
                log.error("\u5206\u4eab\u62a5\u8868\u70b9\u51fb\u94fe\u63a5\u8df3\u8f6c\u62a5\u8868\uff0cToken\u6821\u9a8c\u5931\u8d25\uff01\u8bf7\u6c42\u65e0\u6743\u9650(" + request.getMethod() + ")\uff1a" + string);
                this.backError(response, "\u5206\u4eab\u94fe\u63a5\u4e0d\u80fd\u94bb\u53d6\u8df3\u8f6c\u5176\u4ed6\u62a5\u8868\uff01\u53ef\u4ee5\u91c7\u7528\u62a5\u8868\u9884\u89c8\u5730\u5740\u5e26token\u8bbf\u95ee\u62a5\u8868!", n2);
                return false;
            }
            log.error("Token\u6821\u9a8c\u5931\u8d25\uff01\u8bf7\u6c42\u65e0\u6743\u9650(" + request.getMethod() + ")\uff1a" + string);
            this.backError(response, "Token\u6821\u9a8c\u5931\u8d25\uff0c\u65e0\u6743\u9650\u8bbf\u95ee\uff01", n2);
            return false;
        }
        org.jeecg.modules.jmreport.common.annotation.b b2 = method.getAnnotation(org.jeecg.modules.jmreport.common.annotation.b.class);
        if (b2 != null) {
            String[] stringArray = b2.a();
            String[] stringArray2 = this.jimuTokenClient.getRoles(request);
            if (stringArray2 == null || stringArray2.length == 0) {
                log.error("\u6b64\u63a5\u53e3\u9700\u8981\u89d2\u8272\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01\u8bf7\u6c42\u65e0\u6743\u9650(" + request.getMethod() + ")\uff1a" + string);
                if ("/jmreport/loadTableData".equals(string)) {
                    n2 = GEN_TEST_DATA_CODE;
                }
                this.backError(response, NO_PERMISSION_PROMPT_MSG, n2);
                return false;
            }
            boolean bl2 = Arrays.stream(stringArray2).anyMatch(code -> h.a(code, stringArray));
            if (!bl2) {
                log.error("\u6b64\u63a5\u53e3\u9700\u8981\u89d2\u8272\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01\u8bf7\u6c42\u65e0\u6743\u9650(" + request.getMethod() + ")\uff1a" + string);
                if ("/jmreport/loadTableData".equals(string)) {
                    n2 = GEN_TEST_DATA_CODE;
                }
                this.backError(response, NO_PERMISSION_PROMPT_MSG, n2);
                return false;
            }
        }
        return true;
    }

    private boolean verifyToken(HttpServletRequest request) {
        return this.jimuTokenClient.verifyToken(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backError(HttpServletResponse response, String msg, Integer msgCode) {
        PrintWriter printWriter = null;
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        response.setHeader("auth", "fail");
        try {
            printWriter = response.getWriter();
            Result<Object> result = Result.error(msgCode, msg);
            printWriter.print(JSON.toJSON(result));
        }
        catch (IOException iOException) {
            log.error(iOException.getMessage());
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }
}

