/*
 * Decompiled with CFR 0.152.
 */
package org.flywaydb.core.internal.resource;

import java.util.ArrayList;
import java.util.Collection;
import org.flywaydb.core.api.FlywayException;
import org.flywaydb.core.api.ResourceProvider;
import org.flywaydb.core.api.configuration.Configuration;
import org.flywaydb.core.api.logging.Log;
import org.flywaydb.core.api.logging.LogFactory;
import org.flywaydb.core.api.resource.LoadableResource;
import org.flywaydb.core.api.resource.Resource;
import org.flywaydb.core.internal.resource.ResourceName;
import org.flywaydb.core.internal.resource.ResourceNameParser;
import org.flywaydb.core.internal.util.StringUtils;

public class ResourceNameValidator {
    private static final Log LOG = LogFactory.getLog(ResourceNameValidator.class);

    public void validateSQLMigrationNaming(ResourceProvider provider, Configuration configuration) {
        ArrayList<String> errorsFound = new ArrayList<String>();
        ResourceNameParser resourceNameParser = new ResourceNameParser(configuration);
        for (Resource resource : this.getAllSqlResources(provider, configuration)) {
            LOG.debug("Validating " + resource.getFilename());
            ResourceName result = resourceNameParser.parse(resource.getFilename());
            if (result.isValid()) continue;
            errorsFound.add(result.getValidityMessage());
        }
        if (!errorsFound.isEmpty()) {
            throw new FlywayException("Invalid SQL filenames found:\r\n" + StringUtils.collectionToDelimitedString(errorsFound, "\r\n"));
        }
    }

    private Collection<LoadableResource> getAllSqlResources(ResourceProvider provider, Configuration configuration) {
        return provider.getResources("", configuration.getSqlMigrationSuffixes());
    }
}

