/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.introspection;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Locale;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.introspection.IntrospectionError;

public final class Introspection {
    private static boolean bareNamePropertyMethods = true;

    public static Method getPropertyGetter(String propertyName, Object target) {
        Method getter;
        Preconditions.checkNotNullOrEmpty(propertyName);
        Preconditions.checkNotNull(target);
        try {
            getter = Introspection.findGetter(propertyName, target);
            if (Modifier.isPublic(getter.getModifiers())) {
                getter.setAccessible(true);
            }
            getter.invoke(target, new Object[0]);
        }
        catch (Exception t) {
            throw new IntrospectionError(Introspection.propertyNotFoundErrorMessage(propertyName, target), t);
        }
        return getter;
    }

    public static void setExtractBareNamePropertyMethods(boolean barenamePropertyMethods) {
        bareNamePropertyMethods = barenamePropertyMethods;
    }

    private static String propertyNotFoundErrorMessage(String propertyName, Object target) {
        String targetTypeName = target.getClass().getName();
        String property = Strings.quote(propertyName);
        Method getter = Introspection.findGetter(propertyName, target);
        if (getter == null) {
            return String.format("No getter for property %s in %s", property, targetTypeName);
        }
        if (!Modifier.isPublic(getter.getModifiers())) {
            return String.format("No public getter for property %s in %s", property, targetTypeName);
        }
        return String.format("Unable to find property %s in %s", property, targetTypeName);
    }

    private static Method findGetter(String propertyName, Object target) {
        String capitalized = propertyName.substring(0, 1).toUpperCase(Locale.ENGLISH) + propertyName.substring(1);
        Method getter = Introspection.findMethod("get" + capitalized, target);
        if (getter != null) {
            return getter;
        }
        if (bareNamePropertyMethods && (getter = Introspection.findMethod(propertyName, target)) != null) {
            return getter;
        }
        return Introspection.findMethod("is" + capitalized, target);
    }

    private static Method findMethod(String name, Object target) {
        Class<?> clazz = target.getClass();
        try {
            return clazz.getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            while (clazz != null) {
                try {
                    return clazz.getDeclaredMethod(name, new Class[0]);
                }
                catch (NoSuchMethodException | SecurityException exception2) {
                    clazz = clazz.getSuperclass();
                }
            }
            return null;
        }
    }

    private Introspection() {
    }
}

