/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.pack.omega.transport.resttemplate;

import java.lang.invoke.MethodHandles;
import org.apache.servicecomb.pack.omega.context.OmegaContext;
import org.apache.servicecomb.pack.omega.transport.resttemplate.TransactionHandlerInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@EnableWebMvc
public class WebConfig
extends WebMvcConfigurerAdapter {
    private final OmegaContext omegaContext;
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Autowired
    public WebConfig(@Autowired(required=false) OmegaContext omegaContext) {
        this.omegaContext = omegaContext;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        if (this.omegaContext == null) {
            LOG.info("The OmegaContext is not injected, The transaction handler is disabled");
        }
        registry.addInterceptor((HandlerInterceptor)new TransactionHandlerInterceptor(this.omegaContext));
    }
}

