/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Evolving
public class KerberosName {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosName.class);
    private final String serviceName;
    private final String hostName;
    private final String realm;
    private static final Pattern nameParser = Pattern.compile("([^/@]*)(/([^/@]*))?@([^/@]*)");
    private static Pattern parameterPattern = Pattern.compile("([^$]*)(\\$(\\d*))?");
    private static final Pattern ruleParser = Pattern.compile("\\s*((DEFAULT)|(RULE:\\[(\\d*):([^\\]]*)](\\(([^)]*)\\))?(s/([^/]*)/([^/]*)/(g)?)?))/?(L)?");
    private static final Pattern nonSimplePattern = Pattern.compile("[/@]");
    private static List<Rule> rules;
    private static String defaultRealm;

    public KerberosName(String name) {
        Matcher match = nameParser.matcher(name);
        if (!match.matches()) {
            if (name.contains("@")) {
                throw new IllegalArgumentException("Malformed Kerberos name: " + name);
            }
            this.serviceName = name;
            this.hostName = null;
            this.realm = null;
        } else {
            this.serviceName = match.group(1);
            this.hostName = match.group(3);
            this.realm = match.group(4);
        }
    }

    public String getDefaultRealm() {
        return defaultRealm;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.serviceName);
        if (this.hostName != null) {
            result.append('/');
            result.append(this.hostName);
        }
        if (this.realm != null) {
            result.append('@');
            result.append(this.realm);
        }
        return result.toString();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getRealm() {
        return this.realm;
    }

    static List<Rule> parseRules(String rules) {
        ArrayList<Rule> result = new ArrayList<Rule>();
        String remaining = rules.trim();
        while (remaining.length() > 0) {
            Matcher matcher = ruleParser.matcher(remaining);
            if (!matcher.lookingAt()) {
                throw new IllegalArgumentException("Invalid rule: " + remaining);
            }
            if (matcher.group(2) != null) {
                result.add(new Rule());
            } else {
                result.add(new Rule(Integer.parseInt(matcher.group(4)), matcher.group(5), matcher.group(7), matcher.group(9), matcher.group(10), "g".equals(matcher.group(11)), "L".equals(matcher.group(12))));
            }
            remaining = remaining.substring(matcher.end());
        }
        return result;
    }

    public String getShortName() throws IOException {
        String[] params;
        if (this.hostName == null) {
            if (this.realm == null) {
                return this.serviceName;
            }
            params = new String[]{this.realm, this.serviceName};
        } else {
            params = new String[]{this.realm, this.serviceName, this.hostName};
        }
        for (Rule r : rules) {
            String result = r.apply(params);
            if (result == null) continue;
            return result;
        }
        throw new NoMatchingRule("No rules applied to " + this.toString());
    }

    public static void setRules(String ruleString) {
        rules = ruleString != null ? KerberosName.parseRules((String)ruleString) : null;
    }

    public static String getRules() {
        String ruleString = null;
        if (rules != null) {
            StringBuilder sb = new StringBuilder();
            for (Rule rule : rules) {
                sb.append(rule.toString()).append("\n");
            }
            ruleString = sb.toString().trim();
        }
        return ruleString;
    }

    public static boolean hasRulesBeenSet() {
        return rules != null;
    }

    static void printRules() throws IOException {
        int i = 0;
        for (Rule r : rules) {
            System.out.println(++i + " " + r);
        }
    }

    static /* synthetic */ Pattern access$000() {
        return parameterPattern;
    }

    static /* synthetic */ String access$100() {
        return defaultRealm;
    }

    static /* synthetic */ Pattern access$200() {
        return nonSimplePattern;
    }

    static {
        try {
            defaultRealm = KerberosUtil.getDefaultRealm();
        }
        catch (Exception ke) {
            LOG.debug("Kerberos krb5 configuration not found, setting default realm to empty");
            defaultRealm = "";
        }
    }
}

