/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authentication.server;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.HttpCookie;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationFilter;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.KerberosAuthenticationHandler;
import org.apache.hadoop.security.authentication.server.PseudoAuthenticationHandler;
import org.apache.hadoop.security.authentication.server.TestAuthenticationFilter;
import org.apache.hadoop.security.authentication.util.Signer;
import org.apache.hadoop.security.authentication.util.SignerSecretProvider;
import org.apache.hadoop.security.authentication.util.StringSignerSecretProvider;
import org.apache.hadoop.security.authentication.util.StringSignerSecretProviderCreator;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

/*
 * Exception performing whole class analysis ignored.
 */
public class TestAuthenticationFilter {
    private static final long TOKEN_VALIDITY_SEC = 1000L;

    @Test
    public void testGetConfiguration() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)config.getInitParameter("config.prefix")).thenReturn((Object)"");
        Mockito.when((Object)config.getInitParameter("a")).thenReturn((Object)"A");
        Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("a")).elements());
        Properties props = filter.getConfiguration("", config);
        Assert.assertEquals((Object)"A", (Object)props.getProperty("a"));
        config = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)config.getInitParameter("config.prefix")).thenReturn((Object)"foo");
        Mockito.when((Object)config.getInitParameter("foo.a")).thenReturn((Object)"A");
        Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("foo.a")).elements());
        props = filter.getConfiguration("foo.", config);
        Assert.assertEquals((Object)"A", (Object)props.getProperty("a"));
    }

    @Test
    public void testInitEmpty() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector().elements());
            filter.init(config);
            Assert.fail();
        }
        catch (ServletException ex) {
            Assert.assertEquals((Object)"Authentication type must be specified: simple|kerberos|<class>", (Object)ex.getMessage());
        }
        catch (Exception ex) {
            Assert.fail();
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFallbackToRandomSecretProvider() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)"simple");
            Mockito.when((Object)config.getInitParameter("token.validity")).thenReturn((Object)new Long(1000L).toString());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "token.validity")).elements());
            ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
            Mockito.when((Object)context.getAttribute("signer.secret.provider.object")).thenReturn(null);
            Mockito.when((Object)config.getServletContext()).thenReturn((Object)context);
            filter.init(config);
            Assert.assertEquals(PseudoAuthenticationHandler.class, filter.getAuthenticationHandler().getClass());
            Assert.assertTrue((boolean)filter.isRandomSecret());
            Assert.assertFalse((boolean)filter.isCustomSignerSecretProvider());
            Assert.assertNull((Object)filter.getCookieDomain());
            Assert.assertNull((Object)filter.getCookiePath());
            Assert.assertEquals((long)1000L, (long)filter.getValidity());
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInit() throws Exception {
        FilterConfig config;
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config2 = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config2.getInitParameter("type")).thenReturn((Object)"simple");
            Mockito.when((Object)config2.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type")).elements());
            ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
            Mockito.when((Object)context.getAttribute("signer.secret.provider.object")).thenReturn((Object)new /* Unavailable Anonymous Inner Class!! */);
            Mockito.when((Object)config2.getServletContext()).thenReturn((Object)context);
            filter.init(config2);
            Assert.assertFalse((boolean)filter.isRandomSecret());
            Assert.assertTrue((boolean)filter.isCustomSignerSecretProvider());
        }
        finally {
            filter.destroy();
        }
        File testDir = new File(System.getProperty("test.build.data", "target/test-dir"));
        testDir.mkdirs();
        String secretValue = "hadoop";
        File secretFile = new File(testDir, "http-secret.txt");
        FileWriter writer = new FileWriter(secretFile);
        writer.write(secretValue);
        ((Writer)writer).close();
        filter = new AuthenticationFilter();
        try {
            config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)"simple");
            Mockito.when((Object)config.getInitParameter("signature.secret.file")).thenReturn((Object)secretFile.getAbsolutePath());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "signature.secret.file")).elements());
            ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
            Mockito.when((Object)context.getAttribute("signer.secret.provider.object")).thenReturn(null);
            Mockito.when((Object)config.getServletContext()).thenReturn((Object)context);
            filter.init(config);
            Assert.assertFalse((boolean)filter.isRandomSecret());
            Assert.assertFalse((boolean)filter.isCustomSignerSecretProvider());
        }
        finally {
            filter.destroy();
        }
        filter = new AuthenticationFilter();
        try {
            config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)"simple");
            Mockito.when((Object)config.getInitParameter("cookie.domain")).thenReturn((Object)".foo.com");
            Mockito.when((Object)config.getInitParameter("cookie.path")).thenReturn((Object)"/bar");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "cookie.domain", "cookie.path")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner((FilterConfig)config);
            filter.init(config);
            Assert.assertEquals((Object)".foo.com", (Object)filter.getCookieDomain());
            Assert.assertEquals((Object)"/bar", (Object)filter.getCookiePath());
        }
        finally {
            filter.destroy();
        }
        DummyAuthenticationHandler.reset();
        filter = new AuthenticationFilter();
        try {
            config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner((FilterConfig)config);
            filter.init(config);
            Assert.assertTrue((boolean)DummyAuthenticationHandler.init);
        }
        finally {
            filter.destroy();
            Assert.assertTrue((boolean)DummyAuthenticationHandler.destroy);
        }
        filter = new AuthenticationFilter();
        try {
            config = (FilterConfig)Mockito.mock(FilterConfig.class);
            ServletContext sc = (ServletContext)Mockito.mock(ServletContext.class);
            Mockito.when((Object)config.getServletContext()).thenReturn((Object)sc);
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)"kerberos");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type")).elements());
            filter.init(config);
        }
        catch (ServletException servletException) {
        }
        finally {
            Assert.assertEquals(KerberosAuthenticationHandler.class, filter.getAuthenticationHandler().getClass());
            filter.destroy();
        }
    }

    @Test
    public void testInitCaseSensitivity() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)"SimPle");
            Mockito.when((Object)config.getInitParameter("token.validity")).thenReturn((Object)new Long(1000L).toString());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "token.validity")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner((FilterConfig)config);
            filter.init(config);
            Assert.assertEquals(PseudoAuthenticationHandler.class, filter.getAuthenticationHandler().getClass());
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetRequestURL() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner((FilterConfig)config);
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            Mockito.when((Object)request.getQueryString()).thenReturn((Object)"a=A&b=B");
            Assert.assertEquals((Object)"http://foo:8080/bar?a=A&b=B", (Object)filter.getRequestURL(request));
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetToken() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)"secret");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "signature.secret", "management.operation.return")).elements());
            SignerSecretProvider secretProvider = TestAuthenticationFilter.getMockedServletContextWithStringSigner((FilterConfig)config);
            filter.init(config);
            AuthenticationToken token = new AuthenticationToken("u", "p", "dummy");
            token.setExpires(System.currentTimeMillis() + 1000L);
            Signer signer = new Signer(secretProvider);
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            AuthenticationToken newToken = filter.getToken(request);
            Assert.assertEquals((Object)token.toString(), (Object)newToken.toString());
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTokenExpired() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)"secret");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "signature.secret", "management.operation.return")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner((FilterConfig)config);
            filter.init(config);
            AuthenticationToken token = new AuthenticationToken("u", "p", "dummy");
            token.setExpires(System.currentTimeMillis() - 1000L);
            StringSignerSecretProvider secretProvider = StringSignerSecretProviderCreator.newStringSignerSecretProvider();
            Properties secretProviderProps = new Properties();
            secretProviderProps.setProperty("signature.secret", "secret");
            secretProvider.init(secretProviderProps, null, 1000L);
            Signer signer = new Signer((SignerSecretProvider)secretProvider);
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            boolean failed = false;
            try {
                filter.getToken(request);
            }
            catch (AuthenticationException ex) {
                Assert.assertEquals((Object)"AuthenticationToken expired", (Object)ex.getMessage());
                failed = true;
            }
            finally {
                Assert.assertTrue((String)"token not expired", (boolean)failed);
            }
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGetTokenInvalidType() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)"secret");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "signature.secret", "management.operation.return")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner((FilterConfig)config);
            filter.init(config);
            AuthenticationToken token = new AuthenticationToken("u", "p", "invalidtype");
            token.setExpires(System.currentTimeMillis() + 1000L);
            StringSignerSecretProvider secretProvider = StringSignerSecretProviderCreator.newStringSignerSecretProvider();
            Properties secretProviderProps = new Properties();
            secretProviderProps.setProperty("signature.secret", "secret");
            secretProvider.init(secretProviderProps, null, 1000L);
            Signer signer = new Signer((SignerSecretProvider)secretProvider);
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            boolean failed = false;
            try {
                filter.getToken(request);
            }
            catch (AuthenticationException ex) {
                Assert.assertEquals((Object)"Invalid AuthenticationToken type", (Object)ex.getMessage());
                failed = true;
            }
            finally {
                Assert.assertTrue((String)"token not invalid type", (boolean)failed);
            }
        }
        finally {
            filter.destroy();
        }
    }

    private static SignerSecretProvider getMockedServletContextWithStringSigner(FilterConfig config) throws Exception {
        Properties secretProviderProps = new Properties();
        secretProviderProps.setProperty("signature.secret", "secret");
        StringSignerSecretProvider secretProvider = StringSignerSecretProviderCreator.newStringSignerSecretProvider();
        secretProvider.init(secretProviderProps, null, 1000L);
        ServletContext context = (ServletContext)Mockito.mock(ServletContext.class);
        Mockito.when((Object)context.getAttribute("signer.secret.provider.object")).thenReturn((Object)secretProvider);
        Mockito.when((Object)config.getServletContext()).thenReturn((Object)context);
        return secretProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoFilterNotAuthenticated() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner((FilterConfig)config);
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            ((FilterChain)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)chain)).doFilter((ServletRequest)Mockito.anyObject(), (ServletResponse)Mockito.anyObject());
            Mockito.when((Object)response.containsHeader("WWW-Authenticate")).thenReturn((Object)true);
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            ((HttpServletResponse)Mockito.verify((Object)response)).sendError(401, "Authentication required");
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _testDoFilterAuthentication(boolean withDomainPath, boolean invalidToken, boolean expired) throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
        Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
        Mockito.when((Object)config.getInitParameter("expired.token")).thenReturn((Object)Boolean.toString(expired));
        Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
        Mockito.when((Object)config.getInitParameter("token.validity")).thenReturn((Object)new Long(1000L).toString());
        Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)"secret");
        Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "token.validity", "signature.secret", "management.operation.return", "expired.token")).elements());
        TestAuthenticationFilter.getMockedServletContextWithStringSigner((FilterConfig)config);
        if (withDomainPath) {
            Mockito.when((Object)config.getInitParameter("cookie.domain")).thenReturn((Object)".foo.com");
            Mockito.when((Object)config.getInitParameter("cookie.path")).thenReturn((Object)"/bar");
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "token.validity", "signature.secret", "cookie.domain", "cookie.path", "management.operation.return")).elements());
        }
        HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        Mockito.when((Object)request.getParameter("authenticated")).thenReturn((Object)"true");
        Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
        Mockito.when((Object)request.getQueryString()).thenReturn((Object)"authenticated=true");
        if (invalidToken) {
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{new Cookie("hadoop.auth", "foo")});
        }
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
        HashMap cookieMap = new HashMap();
        ((HttpServletResponse)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)response)).addHeader((String)Mockito.eq((Object)"Set-Cookie"), Mockito.anyString());
        try {
            filter.init(config);
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            if (expired) {
                ((HttpServletResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.never())).addHeader((String)Mockito.eq((Object)"Set-Cookie"), Mockito.anyString());
            } else {
                String v = (String)cookieMap.get("hadoop.auth");
                Assert.assertNotNull((String)"cookie missing", (Object)v);
                Assert.assertTrue((v.contains("u=") && v.contains("p=") && v.contains("t=") && v.contains("e=") && v.contains("s=") ? 1 : 0) != 0);
                ((FilterChain)Mockito.verify((Object)chain)).doFilter((ServletRequest)Mockito.any(ServletRequest.class), (ServletResponse)Mockito.any(ServletResponse.class));
                StringSignerSecretProvider secretProvider = StringSignerSecretProviderCreator.newStringSignerSecretProvider();
                Properties secretProviderProps = new Properties();
                secretProviderProps.setProperty("signature.secret", "secret");
                secretProvider.init(secretProviderProps, null, 1000L);
                Signer signer = new Signer((SignerSecretProvider)secretProvider);
                String value = signer.verifyAndExtract(v);
                AuthenticationToken token = AuthenticationToken.parse((String)value);
                Assert.assertThat((Object)token.getExpires(), (Matcher)CoreMatchers.not((Object)0L));
                if (withDomainPath) {
                    Assert.assertEquals((Object)".foo.com", cookieMap.get("Domain"));
                    Assert.assertEquals((Object)"/bar", cookieMap.get("Path"));
                } else {
                    Assert.assertFalse((boolean)cookieMap.containsKey("Domain"));
                    Assert.assertFalse((boolean)cookieMap.containsKey("Path"));
                }
            }
        }
        finally {
            filter.destroy();
        }
    }

    private static void parseCookieMap(String cookieHeader, HashMap<String, String> cookieMap) {
        List<HttpCookie> cookies = HttpCookie.parse(cookieHeader);
        for (HttpCookie cookie : cookies) {
            if (!"hadoop.auth".equals(cookie.getName())) continue;
            cookieMap.put(cookie.getName(), cookie.getValue());
            if (cookie.getPath() != null) {
                cookieMap.put("Path", cookie.getPath());
            }
            if (cookie.getDomain() == null) continue;
            cookieMap.put("Domain", cookie.getDomain());
        }
    }

    @Test
    public void testDoFilterAuthentication() throws Exception {
        this._testDoFilterAuthentication(false, false, false);
    }

    @Test
    public void testDoFilterAuthenticationImmediateExpiration() throws Exception {
        this._testDoFilterAuthentication(false, false, true);
    }

    @Test
    public void testDoFilterAuthenticationWithInvalidToken() throws Exception {
        this._testDoFilterAuthentication(false, true, false);
    }

    @Test
    public void testDoFilterAuthenticationWithDomainPath() throws Exception {
        this._testDoFilterAuthentication(true, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoFilterAuthenticated() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner((FilterConfig)config);
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            AuthenticationToken token = new AuthenticationToken("u", "p", "t");
            token.setExpires(System.currentTimeMillis() + 1000L);
            StringSignerSecretProvider secretProvider = StringSignerSecretProviderCreator.newStringSignerSecretProvider();
            Properties secretProviderProps = new Properties();
            secretProviderProps.setProperty("signature.secret", "secret");
            secretProvider.init(secretProviderProps, null, 1000L);
            Signer signer = new Signer((SignerSecretProvider)secretProvider);
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            ((FilterChain)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)chain)).doFilter((ServletRequest)Mockito.anyObject(), (ServletResponse)Mockito.anyObject());
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoFilterAuthenticationFailure() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner((FilterConfig)config);
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[0]);
            Mockito.when((Object)request.getHeader("WWW-Authenticate")).thenReturn((Object)"dummyauth");
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            HashMap cookieMap = new HashMap();
            ((HttpServletResponse)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)response)).addHeader((String)Mockito.eq((Object)"Set-Cookie"), Mockito.anyString());
            ((FilterChain)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)chain)).doFilter((ServletRequest)Mockito.anyObject(), (ServletResponse)Mockito.anyObject());
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            ((HttpServletResponse)Mockito.verify((Object)response)).sendError(403, "AUTH FAILED");
            ((HttpServletResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.never())).setHeader((String)Mockito.eq((Object)"WWW-Authenticate"), Mockito.anyString());
            String value = (String)cookieMap.get("hadoop.auth");
            Assert.assertNotNull((String)"cookie missing", (Object)value);
            Assert.assertEquals((Object)"", (Object)value);
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoFilterAuthenticatedExpired() throws Exception {
        String secret = "secret";
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)secret);
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "signature.secret", "management.operation.return")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner((FilterConfig)config);
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            AuthenticationToken token = new AuthenticationToken("u", "p", "dummy");
            token.setExpires(System.currentTimeMillis() - 1000L);
            StringSignerSecretProvider secretProvider = StringSignerSecretProviderCreator.newStringSignerSecretProvider();
            Properties secretProviderProps = new Properties();
            secretProviderProps.setProperty("signature.secret", secret);
            secretProvider.init(secretProviderProps, null, 1000L);
            Signer signer = new Signer((SignerSecretProvider)secretProvider);
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            Mockito.when((Object)response.containsHeader("WWW-Authenticate")).thenReturn((Object)true);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            TestAuthenticationFilter.verifyUnauthorized((AuthenticationFilter)filter, (HttpServletRequest)request, (HttpServletResponse)response, (FilterChain)chain);
        }
        finally {
            filter.destroy();
        }
    }

    private static void verifyUnauthorized(AuthenticationFilter filter, HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        HashMap cookieMap = new HashMap();
        ((HttpServletResponse)Mockito.doAnswer((Answer)new /* Unavailable Anonymous Inner Class!! */).when((Object)response)).addHeader((String)Mockito.eq((Object)"Set-Cookie"), Mockito.anyString());
        filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
        ((HttpServletResponse)Mockito.verify((Object)response)).sendError(Mockito.eq((int)401), Mockito.anyString());
        ((FilterChain)Mockito.verify((Object)chain, (VerificationMode)Mockito.never())).doFilter((ServletRequest)Mockito.any(ServletRequest.class), (ServletResponse)Mockito.any(ServletResponse.class));
        Assert.assertTrue((String)"cookie is missing", (boolean)cookieMap.containsKey("hadoop.auth"));
        Assert.assertEquals((Object)"", cookieMap.get("hadoop.auth"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDoFilterAuthenticatedInvalidType() throws Exception {
        String secret = "secret";
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"true");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameter("signature.secret")).thenReturn((Object)secret);
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "signature.secret", "management.operation.return")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner((FilterConfig)config);
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            AuthenticationToken token = new AuthenticationToken("u", "p", "invalidtype");
            token.setExpires(System.currentTimeMillis() + 1000L);
            StringSignerSecretProvider secretProvider = StringSignerSecretProviderCreator.newStringSignerSecretProvider();
            Properties secretProviderProps = new Properties();
            secretProviderProps.setProperty("signature.secret", secret);
            secretProvider.init(secretProviderProps, null, 1000L);
            Signer signer = new Signer((SignerSecretProvider)secretProvider);
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            Mockito.when((Object)response.containsHeader("WWW-Authenticate")).thenReturn((Object)true);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            TestAuthenticationFilter.verifyUnauthorized((AuthenticationFilter)filter, (HttpServletRequest)request, (HttpServletResponse)response, (FilterChain)chain);
        }
        finally {
            filter.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testManagementOperation() throws Exception {
        AuthenticationFilter filter = new AuthenticationFilter();
        try {
            FilterConfig config = (FilterConfig)Mockito.mock(FilterConfig.class);
            Mockito.when((Object)config.getInitParameter("management.operation.return")).thenReturn((Object)"false");
            Mockito.when((Object)config.getInitParameter("type")).thenReturn((Object)DummyAuthenticationHandler.class.getName());
            Mockito.when((Object)config.getInitParameterNames()).thenReturn(new Vector<String>(Arrays.asList("type", "management.operation.return")).elements());
            TestAuthenticationFilter.getMockedServletContextWithStringSigner((FilterConfig)config);
            filter.init(config);
            HttpServletRequest request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
            Mockito.when((Object)request.getRequestURL()).thenReturn((Object)new StringBuffer("http://foo:8080/bar"));
            HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
            FilterChain chain = (FilterChain)Mockito.mock(FilterChain.class);
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(202);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{response});
            Mockito.reset((Object[])new HttpServletRequest[]{request});
            Mockito.reset((Object[])new HttpServletResponse[]{response});
            AuthenticationToken token = new AuthenticationToken("u", "p", "t");
            token.setExpires(System.currentTimeMillis() + 1000L);
            StringSignerSecretProvider secretProvider = StringSignerSecretProviderCreator.newStringSignerSecretProvider();
            Properties secretProviderProps = new Properties();
            secretProviderProps.setProperty("signature.secret", "secret");
            secretProvider.init(secretProviderProps, null, 1000L);
            Signer signer = new Signer((SignerSecretProvider)secretProvider);
            String tokenSigned = signer.sign(token.toString());
            Cookie cookie = new Cookie("hadoop.auth", tokenSigned);
            Mockito.when((Object)request.getCookies()).thenReturn((Object)new Cookie[]{cookie});
            filter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(202);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{response});
        }
        finally {
            filter.destroy();
        }
    }

    static /* synthetic */ void access$000(String x0, HashMap x1) {
        TestAuthenticationFilter.parseCookieMap((String)x0, (HashMap)x1);
    }
}

