/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl;

import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.kaha.ContainerId;
import org.apache.activemq.kaha.Marshaller;
import org.apache.activemq.kaha.Store;
import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.kaha.StoreLocation;
import org.apache.activemq.kaha.impl.DataManager;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexRootContainer {
    protected static final Marshaller ROOT_MARSHALLER = Store.OBJECT_MARSHALLER;
    private static final Logger LOG = LoggerFactory.getLogger(IndexRootContainer.class);
    protected IndexItem root;
    protected IndexManager indexManager;
    protected DataManager dataManager;
    protected Map<Object, StoreEntry> map = new ConcurrentHashMap<Object, StoreEntry>();
    protected LinkedList<StoreEntry> list = new LinkedList();

    IndexRootContainer(IndexItem root, IndexManager im, DataManager dfm) throws IOException {
        this.root = root;
        this.indexManager = im;
        this.dataManager = dfm;
        long nextItem = root.getNextItem();
        while (nextItem != -1L) {
            IndexItem item = this.indexManager.getIndex(nextItem);
            StoreLocation data = item.getKeyDataItem();
            Object key = this.dataManager.readItem(ROOT_MARSHALLER, data);
            this.map.put(key, item);
            this.list.add(item);
            nextItem = item.getNextItem();
            this.dataManager.addInterestInFile(item.getKeyFile());
        }
    }

    Set<Object> getKeys() {
        return this.map.keySet();
    }

    IndexItem addRoot(IndexManager containerIndexManager, ContainerId key) throws IOException {
        if (this.map.containsKey(key)) {
            this.removeRoot(containerIndexManager, key);
        }
        StoreLocation data = this.dataManager.storeDataItem(ROOT_MARSHALLER, key);
        IndexItem newRoot = this.indexManager.createNewIndex();
        newRoot.setKeyData(data);
        IndexItem containerRoot = containerIndexManager.createNewIndex();
        containerIndexManager.storeIndex(containerRoot);
        newRoot.setValueOffset(containerRoot.getOffset());
        IndexItem last = this.list.isEmpty() ? null : (IndexItem)this.list.getLast();
        last = last == null ? this.root : last;
        long prev = last.getOffset();
        newRoot.setPreviousItem(prev);
        this.indexManager.storeIndex(newRoot);
        last.setNextItem(newRoot.getOffset());
        this.indexManager.storeIndex(last);
        this.map.put(key, newRoot);
        this.list.add(newRoot);
        return containerRoot;
    }

    void removeRoot(IndexManager containerIndexManager, ContainerId key) throws IOException {
        StoreEntry oldRoot = this.map.remove(key);
        if (oldRoot != null) {
            IndexItem next;
            int index;
            this.dataManager.removeInterestInFile(oldRoot.getKeyFile());
            IndexItem containerRoot = containerIndexManager.getIndex(oldRoot.getValueOffset());
            if (containerRoot != null) {
                containerIndexManager.freeIndex(containerRoot);
            }
            IndexItem prev = (index = this.list.indexOf(oldRoot)) > 0 ? (IndexItem)this.list.get(index - 1) : this.root;
            prev = prev == null ? this.root : prev;
            IndexItem indexItem = next = index < this.list.size() - 1 ? (IndexItem)this.list.get(index + 1) : null;
            if (next != null) {
                prev.setNextItem(next.getOffset());
                next.setPreviousItem(prev.getOffset());
                this.indexManager.updateIndexes(next);
            } else {
                prev.setNextItem(-1L);
            }
            this.indexManager.updateIndexes(prev);
            this.list.remove(oldRoot);
            this.indexManager.freeIndex((IndexItem)oldRoot);
        }
    }

    IndexItem getRoot(IndexManager containerIndexManager, ContainerId key) throws IOException {
        StoreEntry index = this.map.get(key);
        if (index != null) {
            return containerIndexManager.getIndex(index.getValueOffset());
        }
        return null;
    }

    boolean doesRootExist(Object key) {
        return this.map.containsKey(key);
    }
}

