/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.param.init;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.adapter.KeyAdapter;
import org.anyline.data.handler.StreamHandler;
import org.anyline.data.param.Config;
import org.anyline.data.param.ConfigChain;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfig;
import org.anyline.data.param.init.DefaultConfigChain;
import org.anyline.data.prepare.Group;
import org.anyline.data.prepare.GroupStore;
import org.anyline.data.prepare.init.DefaultGroup;
import org.anyline.data.prepare.init.DefaultGroupStore;
import org.anyline.data.run.Run;
import org.anyline.entity.Compare;
import org.anyline.entity.DefaultOrder;
import org.anyline.entity.DefaultOrderStore;
import org.anyline.entity.DefaultPageNavi;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.encrypt.DESUtil;

public class DefaultConfigStore
implements ConfigStore {
    private static final long serialVersionUID = -2098827041540802313L;
    protected StreamHandler handler;
    protected Class clazz;
    protected ConfigChain chain;
    protected PageNavi navi;
    protected OrderStore orders;
    protected GroupStore groups;
    protected List<String> queryColumns = new ArrayList<String>();
    protected List<String> excludeColumns = new ArrayList<String>();
    protected Object values;
    protected Boolean override = null;
    protected List<String> overrideByColumns = null;
    protected Constraint overrideByConstraint = null;
    protected List<String> primaryKeys = new ArrayList<String>();
    protected boolean integrality = true;
    protected List<Run> runs = new ArrayList<Run>();
    protected KeyAdapter.KEY_CASE kc = null;
    protected boolean execute = true;
    List<Object> statics = new ArrayList<Object>();
    protected Hashtable<String, Object> configs = new Hashtable();

    public DefaultConfigStore init() {
        return new DefaultConfigStore(new String[0]);
    }

    @Override
    public String toString() {
        Object str = "";
        if (null != this.chain) {
            str = (String)str + this.chain.toString();
        }
        if (null != this.navi) {
            str = (String)str + "." + this.navi.getFirstRow() + "." + this.navi.getLastRow() + "." + this.navi.getCurPage();
        }
        if (null != this.orders) {
            str = (String)str + "." + this.orders.getRunText("");
        }
        if (null != this.groups) {
            str = (String)str + "." + this.groups.getRunText("");
        }
        return str;
    }

    @Override
    public boolean execute() {
        return this.execute;
    }

    @Override
    public ConfigStore execute(boolean execute) {
        this.execute = execute;
        return this;
    }

    @Override
    public Config parseConfig(String config) {
        if (null == config) {
            return null;
        }
        DefaultConfig conf = null;
        conf = config.indexOf("|") != -1 ? new DefaultConfigChain(config) : new DefaultConfig(config);
        return conf;
    }

    @Override
    public ConfigStore setPageNavi(PageNavi navi) {
        this.navi = navi;
        return this;
    }

    @Override
    public ConfigStore copyPageNavi(PageNavi navi) {
        if (null == this.navi) {
            this.navi = navi;
        } else {
            this.navi.setBaseLink(navi.getBaseLink());
            this.navi.setCalType(navi.getCalType());
            this.navi.setCurPage(navi.getCurPage());
            this.navi.setDisplayPageFirst(navi.getDisplayPageFirst());
            this.navi.setDisplayPageLast(navi.getDisplayPageLast());
            this.navi.setFirstRow(navi.getFirstRow());
            this.navi.setLastRow(navi.getLastRow());
            this.navi.setPageRows(navi.getPageRows());
            this.navi.setTotalPage(navi.getTotalPage());
            this.navi.setTotalRow(navi.getTotalRow());
        }
        return this;
    }

    public DefaultConfigStore(String ... configs) {
        configs = BasicUtil.compress((String[])configs);
        this.chain = new DefaultConfigChain();
        for (String config : configs) {
            this.chain.addConfig(this.parseConfig(config));
        }
    }

    public DefaultConfigStore(long first, long last) {
        this.chain = new DefaultConfigChain();
        this.scope(first, last);
    }

    public DefaultConfigStore(List<String> configs) {
        configs = BasicUtil.compress(configs);
        this.chain = new DefaultConfigChain();
        for (String config : configs) {
            this.chain.addConfig(this.parseConfig(config));
        }
    }

    @Override
    public Boolean override() {
        return this.override;
    }

    @Override
    public List<String> overrideByColumns() {
        return this.overrideByColumns;
    }

    @Override
    public Constraint overrideByConstraint() {
        return this.overrideByConstraint;
    }

    @Override
    public ConfigStore override(Boolean override, String ... columns) {
        this.override = override;
        if (null != columns) {
            if (null == this.overrideByColumns) {
                this.overrideByColumns = new ArrayList<String>();
            }
            for (String column : columns) {
                this.overrideByColumns.add(column);
            }
        }
        return this;
    }

    @Override
    public ConfigStore override(Boolean override, Constraint constraint) {
        this.override = override;
        this.overrideByConstraint = constraint;
        return this;
    }

    @Override
    public StreamHandler stream() {
        return this.handler;
    }

    @Override
    public ConfigStore stream(StreamHandler handler) {
        this.handler = handler;
        return this;
    }

    @Override
    public ConfigStore entityClass(Class clazz) {
        this.clazz = clazz;
        return this;
    }

    @Override
    public Class entityClass() {
        return this.clazz;
    }

    @Override
    public ConfigStore scope(long first, long last) {
        if (null == this.navi) {
            this.navi = new DefaultPageNavi();
        }
        this.navi.scope(first, last);
        this.navi.setTotalRow(last - first + 1L);
        this.setPageNavi(this.navi);
        return this;
    }

    @Override
    public ConfigStore limit(long offset, int rows) {
        if (null == this.navi) {
            this.navi = new DefaultPageNavi();
        }
        this.navi.setFirstRow(offset);
        this.navi.setLastRow(offset + (long)rows);
        this.navi.setCalType(1);
        this.navi.setTotalRow((long)rows);
        this.setPageNavi(this.navi);
        return this;
    }

    @Override
    public boolean integrality() {
        return this.integrality;
    }

    @Override
    public ConfigStore integrality(boolean integrality) {
        this.integrality = integrality;
        if (null != this.chain) {
            this.chain.integrality(integrality);
        }
        return this;
    }

    @Override
    public List<Run> runs() {
        return this.runs;
    }

    @Override
    public ConfigStore runs(List<Run> runs) {
        this.runs = runs;
        return this;
    }

    @Override
    public ConfigStore add(Run run) {
        if (null == this.runs) {
            this.runs = new ArrayList<Run>();
        }
        this.runs.add(run);
        return this;
    }

    @Override
    public ConfigStore page(long page, int rows) {
        if (null == this.navi) {
            this.navi = new DefaultPageNavi();
        }
        this.navi.setCurPage(page);
        this.navi.setPageRows(rows);
        this.navi.setCalType(0);
        this.setPageNavi(this.navi);
        return this;
    }

    @Override
    public ConfigStore addPrimaryKey(Collection<String> pks) {
        if (BasicUtil.isEmpty(pks)) {
            return this;
        }
        if (null == this.primaryKeys) {
            this.primaryKeys = new ArrayList<String>();
        }
        for (String item : pks) {
            if (BasicUtil.isEmpty((Object)item) || this.primaryKeys.contains(item)) continue;
            this.primaryKeys.add(item);
        }
        return this;
    }

    @Override
    public ConfigStore setPrimaryKey(Collection<String> pks) {
        if (BasicUtil.isEmpty(pks)) {
            return this;
        }
        if (null == this.primaryKeys) {
            this.primaryKeys = new ArrayList<String>();
        } else {
            this.primaryKeys.clear();
        }
        return this.addPrimaryKey(pks);
    }

    @Override
    public LinkedHashMap<String, Column> getPrimaryColumns() {
        LinkedHashMap<String, Column> columns = new LinkedHashMap<String, Column>();
        List<String> pks = this.getPrimaryKeys();
        if (null != pks) {
            for (String pk : pks) {
                Column column = new Column(pk);
                columns.put(pk.toUpperCase(), column);
            }
        }
        return columns;
    }

    @Override
    public List<String> getPrimaryKeys() {
        if (this.hasSelfPrimaryKeys()) {
            return this.primaryKeys;
        }
        return null;
    }

    @Override
    public String getPrimaryKey() {
        List<String> keys = this.getPrimaryKeys();
        if (null != keys && keys.size() > 0) {
            return keys.get(0);
        }
        return null;
    }

    @Override
    public boolean hasSelfPrimaryKeys() {
        return null != this.primaryKeys && this.primaryKeys.size() > 0;
    }

    @Override
    public ConfigStore and(Compare.EMPTY_VALUE_SWITCH swt, String text) {
        DefaultConfig conf = new DefaultConfig();
        conf.setText(text);
        this.chain.addConfig(conf);
        return this;
    }

    @Override
    public ConfigStore and(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String prefix, String var, Object value, boolean overCondition, boolean overValue) {
        if (null == compare) {
            compare = Compare.AUTO;
        }
        int compareCode = compare.getCode();
        if (null == prefix && var.contains(".")) {
            prefix = var.substring(0, var.indexOf("."));
            var = var.substring(var.indexOf(".") + 1);
        }
        if ((null == swt || Compare.EMPTY_VALUE_SWITCH.NONE == swt) && null != var) {
            if (var.startsWith("++")) {
                swt = Compare.EMPTY_VALUE_SWITCH.BREAK;
                var = var.substring(2);
            } else if (var.startsWith("+")) {
                swt = Compare.EMPTY_VALUE_SWITCH.NULL;
                var = var.substring(1);
            }
        }
        if (compare == Compare.NULL || compare == Compare.NOT_NULL) {
            Object column = var;
            if (BasicUtil.isNotEmpty((Object)prefix)) {
                column = prefix + "." + var;
            }
            String txt = (String)column + compare.getSQL();
            return this.and(swt, txt);
        }
        if (null == swt || Compare.EMPTY_VALUE_SWITCH.NONE == swt) {
            swt = Compare.EMPTY_VALUE_SWITCH.IGNORE;
        }
        value = this.value(value);
        List<Object> olds = new ArrayList();
        Config conf = null;
        if (overCondition && (olds = this.chain.getConfigs(prefix, var, compare)).size() > 0) {
            conf = (Config)olds.get(0);
            olds.remove(conf);
            this.chain.removeConfig(olds);
        }
        if (value instanceof List && ((List)value).size() > 1 && compareCode >= 60 && compareCode <= 62) {
            List list = (List)value;
            if (overValue) {
                this.chain.removeConfig(olds);
            }
            if (compareCode == 60 || compareCode == 61) {
                boolean first = true;
                for (Object item : list) {
                    if (first) {
                        this.and(swt, compare, prefix, var, item, false, false);
                        first = false;
                        continue;
                    }
                    this.or(compare, var, item);
                }
            } else if (compareCode == 62) {
                for (Object item : list) {
                    this.and(swt, compare, prefix, var, item, false, false);
                }
            }
        } else if (null == conf) {
            conf = new DefaultConfig();
            conf.setJoin(" AND ");
            conf.setCompare(compare);
            conf.setPrefix(prefix);
            conf.setVariable(var);
            conf.setSwitch(swt);
            conf.setValue(value);
            this.chain.addConfig(conf);
        } else {
            conf.setOverCondition(overCondition);
            conf.setOverValue(overValue);
            if (overValue) {
                conf.setValue(value);
            } else {
                conf.addValue(value);
            }
        }
        return this;
    }

    @Override
    public ConfigStore and(Config conf) {
        this.chain.addConfig(conf);
        return this;
    }

    @Override
    public ConfigStore and(ConfigStore configs, boolean apart) {
        ConfigChain list = null;
        ConfigChain chains = configs.getConfigChain();
        if (apart) {
            list = new DefaultConfigChain();
            list.addConfig(this.chain);
        } else {
            list = this.chain;
        }
        if (chains.integrality()) {
            list.addConfig(chains);
        } else {
            List<Config> items = chains.getConfigs();
            for (Config item : items) {
                list.addConfig(item);
            }
        }
        this.chain = list;
        return this;
    }

    @Override
    public ConfigStore ands(Config config) {
        DefaultConfigChain list = new DefaultConfigChain();
        list.addConfig(this.chain);
        list.addConfig(config);
        this.chain = list;
        return this;
    }

    @Override
    public ConfigStore ands(Compare.EMPTY_VALUE_SWITCH swt, String text) {
        DefaultConfig conf = new DefaultConfig();
        conf.setText(text);
        DefaultConfigChain list = new DefaultConfigChain();
        list.addConfig(this.chain);
        list.addConfig(conf);
        this.chain = list;
        return this;
    }

    @Override
    public ConfigStore ands(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String prefix, String var, Object value, boolean overCondition, boolean overValue) {
        if (null == compare) {
            compare = Compare.AUTO;
        }
        int compareCode = compare.getCode();
        if (null == prefix && var.contains(".")) {
            prefix = var.substring(0, var.indexOf("."));
            var = var.substring(var.indexOf(".") + 1);
        }
        if ((null == swt || Compare.EMPTY_VALUE_SWITCH.NONE == swt) && null != var) {
            if (var.startsWith("++")) {
                swt = Compare.EMPTY_VALUE_SWITCH.BREAK;
                var = var.substring(2);
            } else if (var.startsWith("+")) {
                swt = Compare.EMPTY_VALUE_SWITCH.NULL;
                var = var.substring(1);
            }
        }
        if (compare == Compare.NULL || compare == Compare.NOT_NULL) {
            Object column = var;
            if (BasicUtil.isNotEmpty((Object)prefix)) {
                column = prefix + "." + var;
            }
            String txt = (String)column + compare.getSQL();
            return this.ands(swt, txt);
        }
        if (null == swt || Compare.EMPTY_VALUE_SWITCH.NONE == swt) {
            swt = Compare.EMPTY_VALUE_SWITCH.IGNORE;
        }
        value = this.value(value);
        List<Object> olds = new ArrayList();
        Config conf = null;
        if (overCondition && (olds = this.chain.getConfigs(prefix, var, compare)).size() > 0) {
            conf = (Config)olds.get(0);
            olds.remove(conf);
            this.chain.removeConfig(olds);
        }
        DefaultConfigStore newStore = new DefaultConfigStore(new String[0]);
        if (value instanceof List && ((List)value).size() > 1 && compareCode >= 60 && compareCode <= 62) {
            List list = (List)value;
            if (overValue) {
                this.chain.removeConfig(olds);
            }
            if (compareCode == 60 || compareCode == 61) {
                boolean first = true;
                for (Object item : list) {
                    if (first) {
                        newStore.and(swt, compare, prefix, var, item, false, false);
                        first = false;
                        continue;
                    }
                    newStore.or(compare, var, item);
                }
            } else if (compareCode == 62) {
                for (Object item : list) {
                    newStore.and(swt, compare, prefix, var, item, false, false);
                }
            }
        } else if (null == conf) {
            conf = new DefaultConfig();
            conf.setJoin(" AND ");
            conf.setCompare(compare);
            conf.setPrefix(prefix);
            conf.setVariable(var);
            conf.setSwitch(swt);
            conf.setValue(value);
            newStore.and(conf);
        } else {
            conf.setOverCondition(overCondition);
            conf.setOverValue(overValue);
            if (overValue) {
                conf.setValue(value);
            } else {
                conf.addValue(value);
            }
        }
        this.ands(newStore);
        return this;
    }

    @Override
    public ConfigStore or(ConfigStore configs, boolean apart) {
        ConfigChain list = null;
        if (apart) {
            list = new DefaultConfigChain();
            list.addConfig(this.chain);
        } else {
            list = this.chain;
        }
        ConfigChain orChain = configs.getConfigChain();
        orChain.setJoin(" OR ");
        list.addConfig(orChain);
        this.chain = list;
        return this;
    }

    @Override
    public ConfigStore or(Config config) {
        config.setJoin(" OR ");
        this.chain.addConfig(config);
        return this;
    }

    @Override
    public ConfigStore or(Compare.EMPTY_VALUE_SWITCH swt, String text) {
        DefaultConfig config = new DefaultConfig();
        config.setText(text);
        config.setJoin(" OR ");
        this.chain.addConfig(config);
        return this;
    }

    @Override
    public ConfigStore ors(Compare.EMPTY_VALUE_SWITCH swt, String text) {
        DefaultConfigChain list = new DefaultConfigChain();
        list.addConfig(this.chain);
        DefaultConfig config = new DefaultConfig();
        config.setText(text);
        config.setJoin(" OR ");
        list.addConfig(config);
        this.chain = list;
        return this;
    }

    @Override
    public ConfigStore ors(Compare.EMPTY_VALUE_SWITCH swt, Config config) {
        DefaultConfigChain list = new DefaultConfigChain();
        list.addConfig(this.chain);
        config.setJoin(" OR ");
        list.addConfig(config);
        this.chain = list;
        return this;
    }

    @Override
    public ConfigStore or(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String prefix, String var, Object value, boolean overCondition, boolean overValue) {
        List<Config> configs = this.chain.getConfigs();
        if (null == prefix && var.contains(".")) {
            prefix = var.substring(0, var.indexOf("."));
            var = var.substring(var.indexOf(".") + 1);
        }
        List<Object> olds = new ArrayList();
        Config conf = null;
        if (overCondition && (olds = this.chain.getConfigs(prefix, var, compare)).size() > 0) {
            conf = (Config)olds.get(0);
            olds.remove(conf);
            this.chain.removeConfig(olds);
        }
        if (configs.size() == 0) {
            this.and(swt, compare, prefix, var, value, overCondition, overValue);
        } else {
            int compareCode = compare.getCode();
            if ((value = this.value(value)) instanceof List && ((List)value).size() > 1 && compareCode >= 60 && compareCode <= 62) {
                List list = (List)value;
                if (overValue) {
                    this.chain.removeConfig(olds);
                }
                if (compareCode == 60 || compareCode == 61) {
                    for (Object item : list) {
                        this.or(swt, compare, prefix, var, item);
                    }
                } else if (compareCode == 62) {
                    DefaultConfigChain findChain = new DefaultConfigChain();
                    findChain.setJoin(" OR ");
                    for (Object item : list) {
                        conf = new DefaultConfig();
                        conf.setJoin(" AND ");
                        conf.setCompare(compare);
                        conf.setPrefix(prefix);
                        conf.setVariable(var);
                        conf.setValue(item);
                        findChain.addConfig(conf);
                    }
                    this.chain.addConfig(findChain);
                }
            } else if (null != conf) {
                if (overValue) {
                    conf.setValue(value);
                } else {
                    conf.addValue(value);
                }
            } else {
                DefaultConfigChain orChain = new DefaultConfigChain();
                Config last = configs.get(configs.size() - 1);
                configs.remove(last);
                if (last instanceof ConfigChain) {
                    ConfigChain lastChain = (ConfigChain)last;
                    List<Config> lastItems = lastChain.getConfigs();
                    for (Config lastItem : lastItems) {
                        orChain.addConfig(lastItem);
                    }
                } else {
                    orChain.addConfig(last);
                }
                conf = new DefaultConfig();
                conf.setJoin(" OR ");
                if (compare == Compare.NULL || compare == Compare.NOT_NULL) {
                    Object column = var;
                    if (BasicUtil.isNotEmpty((Object)prefix)) {
                        column = prefix + "." + var;
                    }
                    String txt = (String)column + compare.getSQL();
                    conf.setText(txt);
                } else {
                    conf.setCompare(compare);
                    conf.setVariable(var);
                    conf.setPrefix(prefix);
                    conf.setValue(value);
                }
                orChain.addConfig(conf);
                this.chain.addConfig(orChain);
            }
        }
        return this;
    }

    @Override
    public ConfigStore ors(Compare.EMPTY_VALUE_SWITCH swt, Compare compare, String prefix, String var, Object value, boolean overCondition, boolean overValue) {
        if (null == prefix && var.contains(".")) {
            prefix = var.substring(0, var.indexOf("."));
            var = var.substring(var.indexOf(".") + 1);
        }
        int compareCode = compare.getCode();
        List<Object> olds = new ArrayList();
        Config conf = null;
        if (overCondition && (olds = this.chain.getConfigs(prefix, var, compare)).size() > 0) {
            conf = (Config)olds.get(0);
            olds.remove(conf);
            this.chain.removeConfig(olds);
        }
        DefaultConfigChain newChain = new DefaultConfigChain();
        newChain.addConfig(this.chain);
        value = this.value(value);
        if (value instanceof List && ((List)value).size() > 1 && compareCode >= 60 && compareCode <= 62) {
            List list = (List)value;
            if (overValue) {
                this.chain.removeConfig(olds);
            }
            if (compareCode == 60 || compareCode == 61) {
                for (Object item : list) {
                    conf = new DefaultConfig();
                    conf.setJoin(" OR ");
                    conf.setPrefix(prefix);
                    conf.setCompare(compare);
                    conf.setVariable(var);
                    conf.setValue(item);
                    newChain.addConfig(conf);
                }
            } else if (compareCode == 62) {
                DefaultConfigChain findChain = new DefaultConfigChain();
                findChain.setJoin(" OR ");
                for (Object item : list) {
                    conf = new DefaultConfig();
                    conf.setJoin(" AND ");
                    conf.setCompare(compare);
                    conf.setPrefix(prefix);
                    conf.setVariable(var);
                    conf.setValue(item);
                    findChain.addConfig(conf);
                }
                newChain.addConfig(findChain);
            }
        } else if (null != conf) {
            if (overValue) {
                conf.setValue(value);
            } else {
                conf.addValue(value);
            }
        } else {
            conf = new DefaultConfig();
            conf.setJoin(" OR ");
            if (compare == Compare.NULL || compare == Compare.NOT_NULL) {
                Object column = var;
                if (BasicUtil.isNotEmpty((Object)prefix)) {
                    column = prefix + "." + var;
                }
                String txt = (String)column + compare.getSQL();
                conf.setText(txt);
            } else {
                conf.setCompare(compare);
                conf.setVariable(var);
                conf.setPrefix(prefix);
                conf.setValue(value);
            }
            newChain.addConfig(conf);
        }
        this.chain = newChain;
        return this;
    }

    private Object value(Object value) {
        if (value instanceof Object[]) {
            value = BeanUtil.array2list((Object[][])new Object[][]{(Object[])value});
        }
        if (value instanceof List) {
            List list = (List)value;
            if (list.size() == 0) {
                value = null;
            } else if (list.size() == 1) {
                value = list.get(0);
            }
        }
        return value;
    }

    protected void setNaviParam() {
        if (null == this.chain || null == this.navi) {
            return;
        }
        List<Config> configs = this.chain.getConfigs();
        for (Config config : configs) {
            if (null == config) continue;
            String key = config.getKey();
            List<Object> values = new ArrayList();
            List<Object> srcValues = config.getValues();
            if (config.isKeyEncrypt()) {
                key = DESUtil.encryptParamKey((String)key);
            }
            if (config.isValueEncrypt() && null != srcValues) {
                for (Object value : srcValues) {
                    if (null == value) continue;
                    value = DESUtil.encryptParamValue((String)value.toString());
                    values.add(value);
                }
            } else {
                values = srcValues;
            }
            this.navi.addParam(key, values);
        }
    }

    @Override
    public ConfigChain getConfigChain() {
        return this.chain;
    }

    @Override
    public ConfigStore order(Order order, boolean override) {
        if (null == this.orders) {
            this.orders = new DefaultOrderStore();
        }
        this.orders.order(order, override);
        if (null != this.navi) {
            this.navi.order(order.getColumn(), order.getType().getCode(), override);
        }
        return this;
    }

    @Override
    public ConfigStore order(Order order) {
        return this.order(order, true);
    }

    @Override
    public ConfigStore order(String column, Order.TYPE type, boolean override) {
        return this.order((Order)new DefaultOrder(column, type), override);
    }

    @Override
    public ConfigStore order(String column, Order.TYPE type) {
        return this.order(column, type, true);
    }

    @Override
    public ConfigStore order(String column, String type, boolean override) {
        return this.order((Order)new DefaultOrder(column, type), override);
    }

    @Override
    public ConfigStore order(String column, String type) {
        return this.order(column, type, true);
    }

    @Override
    public ConfigStore order(String order, boolean override) {
        return this.order((Order)new DefaultOrder(order), override);
    }

    @Override
    public ConfigStore order(String order) {
        return this.order(order, true);
    }

    @Override
    public OrderStore getOrders() {
        return this.orders;
    }

    @Override
    public ConfigStore setOrders(OrderStore orders) {
        this.orders = orders;
        return this;
    }

    @Override
    public ConfigStore group(Group group) {
        if (null == this.groups) {
            this.groups = new DefaultGroupStore();
        }
        this.groups.group(group);
        return this;
    }

    @Override
    public ConfigStore group(String column) {
        return this.group(new DefaultGroup(column));
    }

    @Override
    public GroupStore getGroups() {
        return this.groups;
    }

    @Override
    public ConfigStore setGroups(GroupStore groups) {
        this.groups = groups;
        return this;
    }

    @Override
    public PageNavi getPageNavi() {
        return this.navi;
    }

    @Override
    public Config getConfig(String var) {
        return this.chain.getConfig(null, var);
    }

    @Override
    public ConfigStore removeConfig(String var) {
        Config config = this.getConfig(var);
        return this.removeConfig(config);
    }

    @Override
    public ConfigStore removeConfig(Config config) {
        this.chain.removeConfig(config);
        return this;
    }

    @Override
    public List<Object> getConfigValues(String var) {
        Config config = this.chain.getConfig(null, var);
        if (null != config) {
            return config.getValues();
        }
        return null;
    }

    @Override
    public Object getConfigValue(String var) {
        List<Object> values;
        Config config = this.chain.getConfig(null, var);
        if (null != config && null != (values = config.getValues()) && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    @Override
    public Config getConfig(String var, Compare compare) {
        return this.chain.getConfig(null, var, compare);
    }

    @Override
    public ConfigStore removeConfig(String var, Compare compare) {
        Config config = this.getConfig(var, compare);
        return this.removeConfig(config);
    }

    @Override
    public List<Object> getConfigValues(String var, Compare compare) {
        Config config = this.chain.getConfig(null, var, compare);
        if (null != config) {
            return config.getValues();
        }
        return null;
    }

    @Override
    public Object getConfigValue(String var, Compare compare) {
        List<Object> values;
        Config config = this.chain.getConfig(null, var, compare);
        if (null != config && null != (values = config.getValues()) && values.size() > 0) {
            return values.get(0);
        }
        return null;
    }

    @Override
    public ConfigStore fetch(String ... keys) {
        DefaultConfigStore result = new DefaultConfigStore(new String[0]);
        result.setOrders(this.getOrders());
        result.setGroups(this.getGroups());
        result.setPageNavi(this.getPageNavi());
        DefaultConfigChain chain = new DefaultConfigChain();
        List<Config> configs = this.getConfigChain().getConfigs();
        for (Config config : configs) {
            if (null == config || !BasicUtil.contains((Object[])keys, (Object)config.getPrefix())) continue;
            chain.addConfig((Config)config.clone());
        }
        result.chain = chain;
        return result;
    }

    @Override
    public ConfigStore setTotalLazy(long ms) {
        if (null != this.navi) {
            this.navi.setLazy(ms);
        }
        return this;
    }

    @Override
    public ConfigStore setValue(Map<String, Object> values) {
        this.values = values;
        if (null == this.chain || null == values) {
            return this;
        }
        List<Config> configs = this.chain.getConfigs();
        for (Config config : configs) {
            if (null == config) continue;
            config.setValue(values);
        }
        this.setNaviParam();
        return this;
    }

    @Override
    public ConfigStore columns(String ... columns) {
        if (null != columns) {
            for (String column : columns) {
                this.queryColumns.add(column);
            }
        }
        return this;
    }

    @Override
    public ConfigStore columns(List<String> columns) {
        if (null != columns) {
            this.queryColumns.addAll(columns);
        }
        return this;
    }

    @Override
    public List<String> columns() {
        return this.queryColumns;
    }

    @Override
    public ConfigStore excludes(String ... columns) {
        if (null != columns) {
            for (String column : columns) {
                this.excludeColumns.add(column);
            }
        }
        return this;
    }

    @Override
    public ConfigStore excludes(List<String> columns) {
        if (null != columns) {
            this.excludeColumns.addAll(columns);
        }
        return this;
    }

    @Override
    public List<String> excludes() {
        return this.excludeColumns;
    }

    @Override
    public boolean isValid() {
        if (null != this.chain) {
            for (Config config : this.chain.getConfigs()) {
                if (config.getSwitch() != Compare.EMPTY_VALUE_SWITCH.BREAK || !config.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    public ConfigStore clone() {
        DefaultConfigStore store = new DefaultConfigStore(new String[0]);
        return store;
    }

    public ConfigStore condition(String join, Compare compare, String key, Object ... values) {
        if ("or".equalsIgnoreCase(join)) {
            this.or(compare, key, (Object)values);
        } else {
            this.and(compare, key, values);
        }
        return this;
    }

    public ConfigStore condition(String join, String compare, String key, String value) {
        return this.condition(join, this.compare(compare), key, (Object)value);
    }

    public static Compare compare(int code) {
        for (Compare compare : Compare.values()) {
            if (compare.getCode() != code) continue;
            return compare;
        }
        return Compare.EQUAL;
    }

    @Override
    public ConfigStore addStaticValue(Object value) {
        if (value instanceof Collection) {
            this.statics.addAll((Collection)value);
        } else {
            this.statics.add(value);
        }
        return this;
    }

    @Override
    public List<Object> getStaticValues() {
        return this.statics;
    }

    @Override
    public KeyAdapter.KEY_CASE keyCase() {
        return this.kc;
    }

    @Override
    public ConfigStore keyCase(KeyAdapter.KEY_CASE kc) {
        this.kc = kc;
        return this;
    }

    @Override
    public ConfigStore config(String key, Object value) {
        this.configs.put(key.toUpperCase(), value);
        return this;
    }

    @Override
    public Object config(String key) {
        Object value = null;
        value = this.configs.containsKey(key = key.toUpperCase()) ? this.configs.get(key) : ConfigTable.get((String)key);
        return value;
    }
}

