/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.listener.init;

import java.util.ArrayList;
import java.util.List;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.listener.DDListener;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.param.init.DefaultConfigStore;
import org.anyline.data.prepare.auto.init.DefaultTablePrepare;
import org.anyline.data.run.RunValue;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.DefaultPageNavi;
import org.anyline.entity.PageNavi;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Column;
import org.anyline.metadata.Table;
import org.anyline.util.ConfigTable;
import org.anyline.util.regular.RegularUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="anyline.jdbc.listener.dd.default")
public class DefaultDDListener
implements DDListener {
    protected Logger log = LoggerFactory.getLogger(DefaultDDListener.class);

    @Override
    public ACTION.SWITCH afterAlterColumnException(DataRuntime runtime, String random, Table table, Column column, Exception exception) {
        if (ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION == 0) {
            return ACTION.SWITCH.CONTINUE;
        }
        ACTION.SWITCH swt = ACTION.SWITCH.CONTINUE;
        if (ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION == 1) {
            this.exeAfterException(runtime, table, column, exception);
        } else {
            DefaultTablePrepare prepare = new DefaultTablePrepare();
            prepare.setDataSource(table.getName());
            long rows = runtime.getAdapter().count(runtime, random, prepare, null, new String[0]);
            swt = rows > (long)ConfigTable.AFTER_ALTER_COLUMN_EXCEPTION_ACTION ? this.afterAlterColumnException(runtime, random, table, column, rows, exception) : this.exeAfterException(runtime, table, column, exception);
        }
        return swt;
    }

    public ACTION.SWITCH exeAfterException(DataRuntime runtime, Table table, Column column, Exception exception) {
        DriverAdapter adapter = runtime.getAdapter();
        Column update = (Column)column.getUpdate();
        boolean isNum = adapter.isNumberColumn(runtime, update);
        if (adapter.isCharColumn(runtime, column) && !adapter.isCharColumn(runtime, update)) {
            int page = 1;
            int vol = 100;
            DefaultPageNavi navi = new DefaultPageNavi();
            navi.setPageRows(vol);
            List pks = table.primarys();
            if (pks.size() == 0 && null == table.getColumn(DataRow.DEFAULT_PRIMARY_KEY)) {
                return ACTION.SWITCH.SKIP;
            }
            ArrayList<String> keys = new ArrayList<String>();
            for (Column pk : pks) {
                keys.add(pk.getName());
            }
            while (true) {
                navi.setCurPage((long)page);
                DefaultTablePrepare prepare = new DefaultTablePrepare();
                prepare.setDataSource(table.getName());
                DefaultConfigStore configs = new DefaultConfigStore(new String[0]);
                configs.setPageNavi((PageNavi)navi);
                DataSet set = runtime.getAdapter().querys(runtime, null, prepare, configs, new String[0]);
                if (set.isEmpty()) break;
                set.setPrimaryKey(true, keys);
                for (DataRow row : set) {
                    String value = row.getString(column.getName() + "_TMP_UPDATE_TYPE");
                    if (null == value) {
                        value = row.getString(column.getName());
                    }
                    if (null == value) continue;
                    Object convert = null;
                    if (isNum) {
                        value = this.char2number(value);
                    }
                    RunValue run = new RunValue();
                    run.setValue(value);
                    adapter.convert(runtime, update, run);
                    convert = run.getValue();
                    row.put(column.getName(), convert);
                    this.log.warn("[after exception][\u6570\u636e\u4fee\u6b63][{}>{}]", (Object)value, convert);
                    runtime.getAdapter().update(runtime, null, table.getName(), (Object)row, (ConfigStore)new DefaultConfigStore(new String[0]), column.getName());
                }
                if (set.size() < vol) break;
                ++page;
            }
        }
        return ACTION.SWITCH.CONTINUE;
    }

    private String char2number(String value) {
        value = value.replaceAll("\\s", "");
        try {
            value = RegularUtil.fetchNumber((String)value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }
}

