/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.adapter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.util.BasicUtil;
import org.anyline.util.LogUtil;
import org.anyline.util.regular.RegularUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository(value="anyline.data.DriverAdapterHolder")
public class DriverAdapterHolder {
    private static final Logger log = LoggerFactory.getLogger(DriverAdapterHolder.class);
    private static ConcurrentHashMap<String, DriverAdapter> adapters = new ConcurrentHashMap();
    private static Map<String, Boolean> supports = new HashMap<String, Boolean>();
    private static List<DriverAdapterHolder> utils = new ArrayList<DriverAdapterHolder>();
    private static DriverAdapter defaultAdapter = null;

    public static void remove(String datasource) {
        adapters.remove("al-ds:" + datasource);
    }

    @Autowired(required=false)
    public void setAdapters(Map<String, DriverAdapter> map) {
        for (DriverAdapter adapter : map.values()) {
            String version = adapter.version();
            if (null == version) {
                adapters.put(adapter.type().name(), adapter);
            } else {
                adapters.put(adapter.type().name() + "_" + adapter.version(), adapter);
            }
            supports.put(adapter.type().name(), true);
        }
    }

    public static boolean support(DatabaseType type) {
        return supports.containsKey(type.name());
    }

    public static DriverAdapter getAdapter(String datasource, DataRuntime runtime) {
        if (null != defaultAdapter) {
            return defaultAdapter;
        }
        if (adapters.size() == 1) {
            defaultAdapter = adapters.values().iterator().next();
            return defaultAdapter;
        }
        DriverAdapter adapter = null;
        adapter = adapters.get("al-ds:" + datasource);
        if (null != adapter) {
            return adapter;
        }
        try {
            String feature = runtime.getFeature();
            if (null != feature && null == (adapter = DriverAdapterHolder.getAdapter(datasource, feature, runtime.getVersion()))) {
                feature = runtime.getFeature(true);
                adapter = DriverAdapterHolder.getAdapter(datasource, feature, runtime.getVersion());
            }
            if (null == adapter) {
                log.error("[\u68c0\u6d4b\u6570\u636e\u5e93\u9002\u914d\u5668][\u68c0\u6d4b\u5931\u8d25][\u53ef\u7528\u9002\u914d\u5668\u6570\u91cf:{}][\u68c0\u6d4b\u5176\u4ed6\u53ef\u7528\u7684\u9002\u914d\u5668]", (Object)adapters.size());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null == adapter) {
            log.error("[\u68c0\u6d4b\u6570\u636e\u5e93\u9002\u914d\u5668][\u68c0\u6d4b\u5176\u4ed6\u53ef\u7528\u7684\u9002\u914d\u5668\u5931\u8d25][\u53ef\u7528\u9002\u914d\u5668\u6570\u91cf:{}][{}]", (Object)adapters.size(), (Object)LogUtil.format((String)"\u53ef\u80fd\u6ca1\u6709\u4f9d\u8d56anyline-data-jdbc-*(\u5982mysql,neo4j)\u6216\u6ca1\u6709\u626b\u63cforg.anyline\u5305", (int)31));
        }
        return adapter;
    }

    private static DriverAdapter getAdapter() {
        return null;
    }

    private static int versions(DatabaseType type, String ... versions) {
        int qty = 0;
        for (String version : versions) {
            if (!adapters.containsKey(type.name() + "_" + version)) continue;
            ++qty;
        }
        return qty;
    }

    private static DriverAdapter adapter(DatabaseType type, String ... versions) {
        for (String version : versions) {
            DriverAdapter adapter = adapters.get(type.name() + "_" + version);
            if (null == adapter) continue;
            return adapter;
        }
        return null;
    }

    private static boolean check(DriverAdapter adapter, String datasource, String feature) {
        List keywords;
        DatabaseType type = adapter.type();
        if (null != type && null != (keywords = type.keywords())) {
            for (String k : keywords) {
                if (!feature.contains(k)) continue;
                return true;
            }
        }
        return false;
    }

    private static DriverAdapter getAdapter(String datasource, String feature, String version) {
        Object adapter = null;
        if (null != version) {
            version = version.toLowerCase();
        }
        if (null != feature) {
            feature = feature.toLowerCase();
        }
        for (DriverAdapter item : adapters.values()) {
            boolean chk = DriverAdapterHolder.check(item, datasource, feature);
            if (!chk) continue;
            String type = item.type().toString().toLowerCase();
            if (null != version) {
                if (type.contains("mssql")) {
                    item = DriverAdapterHolder.mssql(datasource, feature, version);
                } else if (type.contains("oracle")) {
                    item = DriverAdapterHolder.oracle(datasource, feature, version);
                }
            }
            if (null == item) continue;
            adapters.put("al-ds:" + datasource, item);
            log.info("[\u68c0\u6d4b\u6570\u636e\u5e93\u9002\u914d\u5668][datasource:{}][\u7279\u5f81:{}][\u9002\u914d\u5668:{}]", new Object[]{datasource, feature, item});
            return item;
        }
        return null;
    }

    private static DriverAdapter mssql(String datasource, String feature, String version) {
        DriverAdapter adapter = null;
        if (null != version) {
            version = version.split("\\.")[0];
            double v = BasicUtil.parseDouble((Object)version, (Double)0.0);
            String key = null;
            key = v >= 9.0 ? "2005" : "2000";
            adapter = adapters.get(DatabaseType.MSSQL.name() + "_" + key);
        } else if (DriverAdapterHolder.versions(DatabaseType.MSSQL, "2000", "2005") == 1) {
            adapter = DriverAdapterHolder.adapter(DatabaseType.MSSQL, "2005", "2000");
        }
        if (null == adapter) {
            adapter = adapters.get(DatabaseType.MSSQL.name() + "_2005");
        }
        return adapter;
    }

    private static DriverAdapter oracle(String datasource, String feature, String version) {
        DriverAdapter adapter = null;
        if (null != version) {
            if (null != (version = RegularUtil.cut((String)version, (String[])new String[]{"release", "-"}))) {
                version = version.split("\\.")[0];
            }
            double v = BasicUtil.parseDouble((Object)version, (Double)0.0);
            String key = null;
            key = v >= 12.0 ? "12" : "11";
            adapter = adapters.get(DatabaseType.ORACLE.name() + "_" + key);
        } else if (DriverAdapterHolder.versions(DatabaseType.ORACLE, "11", "12") == 1) {
            adapter = DriverAdapterHolder.adapter(DatabaseType.ORACLE, "11", "12");
        }
        if (null == adapter) {
            adapter = adapters.get(DatabaseType.ORACLE.name() + "_" + version);
        }
        return adapter;
    }
}

