/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.runtime;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.dao.init.springjdbc.DefaultDao;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.adapter.DriverAdapterHolder;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.runtime.JDBCRuntime;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.runtime.RuntimeHolder;
import org.anyline.proxy.RuntimeHolderProxy;
import org.anyline.service.init.DefaultService;
import org.anyline.util.ClassUtil;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component(value="anyline.data.runtime.holder.jdbc")
public class JDBCRuntimeHolder
extends RuntimeHolder {
    private static Map<String, DataSource> temporary = new HashMap<String, DataSource>();

    public JDBCRuntimeHolder() {
        RuntimeHolderProxy.reg(DataSource.class, (RuntimeHolder)this);
        RuntimeHolderProxy.reg(JdbcTemplate.class, (RuntimeHolder)this);
    }

    public static DataRuntime temporary(Object datasource, String database, DriverAdapter adapter) throws Exception {
        return JDBCRuntimeHolder.exeTemporary(datasource, database, adapter);
    }

    public DataRuntime callTemporary(Object datasource, String database, DriverAdapter adapter) throws Exception {
        return JDBCRuntimeHolder.exeTemporary(datasource, database, adapter);
    }

    private static DataRuntime exeTemporary(Object datasource, String database, DriverAdapter adapter) throws Exception {
        JDBCRuntime runtime = new JDBCRuntime();
        if (!(datasource instanceof DataSource)) {
            throw new Exception("\u8bf7\u63d0\u4f9bjavax.sql.DataSource\u517c\u5bb9\u7c7b\u578b");
        }
        String key = "temporary_jdbc";
        JDBCRuntimeHolder.close(key);
        temporary.remove(key);
        runtimes.remove(key);
        DriverAdapterHolder.remove((String)key);
        runtime.setKey(key);
        runtime.setAdapter(adapter);
        DataSource ds = (DataSource)datasource;
        JdbcTemplate template = new JdbcTemplate(ds);
        runtime.setProcessor(template);
        temporary.put(key, ds);
        log.warn("[\u521b\u5efa\u4e34\u65f6\u6570\u636e\u6e90][key:{}][type:{}]", (Object)key, (Object)datasource.getClass().getSimpleName());
        runtimes.put(key, runtime);
        return runtime;
    }

    public static DataRuntime reg(String key, String ds) {
        String template_key = "anyline.jdbc.template." + key;
        BeanDefinitionBuilder jdbc_builder = BeanDefinitionBuilder.genericBeanDefinition(JdbcTemplate.class);
        jdbc_builder.addPropertyReference("dataSource", ds);
        AbstractBeanDefinition definition = jdbc_builder.getBeanDefinition();
        factory.registerBeanDefinition(template_key, (BeanDefinition)definition);
        JdbcTemplate template = (JdbcTemplate)factory.getBean(template_key, JdbcTemplate.class);
        return JDBCRuntimeHolder.reg(key, template, null);
    }

    public static DataRuntime reg(String key, DataSource ds) {
        String datasource_key = "anyline.datasource." + key;
        factory.registerSingleton(datasource_key, (Object)ds);
        String template_key = "anyline.jdbc.template." + key;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(JdbcTemplate.class);
        builder.addPropertyValue("dataSource", (Object)ds);
        AbstractBeanDefinition definition = builder.getBeanDefinition();
        factory.registerBeanDefinition(template_key, (BeanDefinition)definition);
        JdbcTemplate template = (JdbcTemplate)factory.getBean(template_key, JdbcTemplate.class);
        return JDBCRuntimeHolder.reg(key, template, null);
    }

    public static JDBCRuntime reg(String datasource, JdbcTemplate template, JDBCAdapter adapter) {
        log.info("[create jdbc runtime][key:{}]", (Object)datasource);
        JDBCRuntime runtime = new JDBCRuntime(datasource, template, adapter);
        if (runtimes.containsKey(datasource)) {
            JDBCRuntimeHolder.destroy(datasource);
        }
        runtimes.put(datasource, runtime);
        String dao_key = "anyline.dao." + datasource;
        String service_key = "anyline.service." + datasource;
        log.info("[instance service][data source:{}][instance id:{}]", (Object)datasource, (Object)service_key);
        BeanDefinitionBuilder daoBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultDao.class);
        daoBuilder.addPropertyValue("runtime", (Object)runtime);
        daoBuilder.setLazyInit(true);
        AbstractBeanDefinition daoDefinition = daoBuilder.getBeanDefinition();
        factory.registerBeanDefinition(dao_key, (BeanDefinition)daoDefinition);
        BeanDefinitionBuilder serviceBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultService.class);
        serviceBuilder.addPropertyReference("dao", dao_key);
        serviceBuilder.setLazyInit(true);
        AbstractBeanDefinition serviceDefinition = serviceBuilder.getBeanDefinition();
        factory.registerBeanDefinition(service_key, (BeanDefinition)serviceDefinition);
        return runtime;
    }

    public static void destroy(String key) {
        JDBCRuntimeHolder.exeDestroy(key);
    }

    private static void exeDestroy(String key) {
        try {
            runtimes.remove(key);
            JDBCRuntimeHolder.destroyBean((String)("anyline.service." + key));
            JDBCRuntimeHolder.destroyBean((String)("anyline.dao." + key));
            JDBCRuntimeHolder.destroyBean((String)("anyline.transaction." + key));
            JDBCRuntimeHolder.destroyBean((String)("anyline.jdbc.template." + key));
            JDBCRuntimeHolder.close("anyline.datasource." + key);
            JDBCRuntimeHolder.destroyBean((String)("anyline.datasource." + key));
            log.warn("[\u6ce8\u9500\u6570\u636e\u6e90\u53ca\u76f8\u5173\u8d44\u6e90][key:{}]", (Object)key);
            Map runtimes = JDBCRuntimeHolder.runtimes((String)key);
            for (String item : runtimes.keySet()) {
                JDBCRuntimeHolder.destroy(item);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void callDestroy(String key) {
        JDBCRuntimeHolder.exeDestroy(key);
    }

    public static void close(String key) {
        Object datasource = null;
        if (factory.containsSingleton(key)) {
            datasource = factory.getSingleton(key);
            try {
                JDBCRuntimeHolder.closeConnection(datasource);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (temporary.containsKey(key)) {
            try {
                JDBCRuntimeHolder.closeConnection(temporary.get(key));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void closeConnection(Object ds) throws Exception {
        Method method = ClassUtil.getMethod(ds.getClass(), (String)"close", (Class[])new Class[0]);
        if (null != method) {
            method.invoke(ds, new Object[0]);
        }
    }

    public static JdbcTemplate getJdbcTemplate() {
        DataRuntime runtime = JDBCRuntimeHolder.runtime();
        if (null != runtime) {
            return (JdbcTemplate)runtime.getProcessor();
        }
        return null;
    }

    public static DataSource getDataSource() {
        DataRuntime runtime = JDBCRuntimeHolder.runtime();
        if (null != runtime) {
            JdbcTemplate jdbc = (JdbcTemplate)runtime.getProcessor();
            return jdbc.getDataSource();
        }
        return null;
    }

    public static JdbcTemplate getJdbcTemplate(String key) {
        DataRuntime runtime = JDBCRuntimeHolder.runtime((String)key);
        if (null != runtime) {
            return (JdbcTemplate)runtime.getProcessor();
        }
        return null;
    }

    public static DataSource getDataSource(String key) {
        DataRuntime runtime = JDBCRuntimeHolder.runtime((String)key);
        if (null != runtime) {
            JdbcTemplate jdbc = (JdbcTemplate)runtime.getProcessor();
            return jdbc.getDataSource();
        }
        return null;
    }
}

