/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.loader;

import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.anyline.data.jdbc.datasource.JDBCDatasourceHolder;
import org.anyline.data.jdbc.runtime.JDBCRuntimeHolder;
import org.anyline.data.listener.DatasourceLoader;
import org.anyline.util.SpringContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.env.Environment;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component(value="anyline.data.datasource.loader.jdbc")
public class JDBCDatasourceLoader
implements DatasourceLoader {
    public static Logger log = LoggerFactory.getLogger(JDBCDatasourceLoader.class);
    private static DefaultListableBeanFactory factory;

    public List<String> load(ApplicationContext context) {
        ArrayList<String> list = new ArrayList<String>();
        Environment env = context.getEnvironment();
        factory = (DefaultListableBeanFactory)context.getAutowireCapableBeanFactory();
        SpringContextUtil.init((ApplicationContext)context);
        JDBCRuntimeHolder.init((DefaultListableBeanFactory)factory);
        boolean loadDefault = true;
        JdbcTemplate jdbc = null;
        try {
            jdbc = (JdbcTemplate)SpringContextUtil.getBean(JdbcTemplate.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null != jdbc) {
            JDBCRuntimeHolder.reg("default", jdbc, null);
            loadDefault = false;
        } else {
            DataSource datasource = null;
            try {
                datasource = (DataSource)SpringContextUtil.getBean(DataSource.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (null != datasource) {
                try {
                    JDBCDatasourceHolder.reg("default", datasource, false);
                    loadDefault = false;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        list.addAll(this.load(env, "spring.datasource", loadDefault));
        list.addAll(this.load(env, "anyline.datasource", loadDefault));
        return list;
    }

    private List<String> load(Environment env, String head, boolean loadDefault) {
        String prefixs;
        String def;
        ArrayList<String> list = new ArrayList<String>();
        if (loadDefault && null != (def = JDBCDatasourceHolder.reg("default", head, env))) {
            list.add(def);
        }
        if (null == (prefixs = env.getProperty(head + ".list"))) {
            prefixs = env.getProperty(head + "-list");
        }
        if (null != prefixs) {
            for (String prefix : prefixs.split(",")) {
                try {
                    String ds = JDBCDatasourceHolder.reg(prefix, head + "." + prefix, env);
                    if (null == ds) continue;
                    list.add(ds);
                }
                catch (Exception e) {
                    log.error("[\u6ce8\u5165\u6570\u636e\u6e90\u5931\u8d25][type:JDBC][key:{}][msg:{}]", (Object)prefix, (Object)e.toString());
                }
            }
        }
        return list;
    }
}

