/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.postgresql;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Date;
import org.anyline.adapter.DataWriter;
import org.anyline.adapter.init.ConvertAdapter;
import org.anyline.data.jdbc.postgresql.PostgresqlGeometryAdapter;
import org.anyline.data.metadata.StandardColumnType;
import org.anyline.entity.geometry.Box;
import org.anyline.entity.geometry.Circle;
import org.anyline.entity.geometry.Line;
import org.anyline.entity.geometry.LineSegment;
import org.anyline.entity.geometry.LineString;
import org.anyline.entity.geometry.Point;
import org.anyline.util.DateUtil;
import org.postgresql.geometric.PGbox;
import org.postgresql.geometric.PGcircle;
import org.postgresql.geometric.PGline;
import org.postgresql.geometric.PGlseg;
import org.postgresql.geometric.PGpath;
import org.postgresql.geometric.PGpoint;

public enum PostgresqlWriter {
    DateWriter(new Object[]{java.sql.Date.class, LocalDate.class}, new DataWriter(){

        public Object write(Object value, boolean placeholder) {
            if (!placeholder && null != value) {
                Date date = (Date)ConvertAdapter.convert((Object)value, Date.class, (boolean)false);
                value = " to_date( '" + DateUtil.format((Date)date) + "' , 'YYYY-MM-DD')";
            }
            return value;
        }
    }),
    DateTimeWriter(new Object[]{Timestamp.class, Date.class, LocalDateTime.class}, new DataWriter(){

        public Object write(Object value, boolean placeholder) {
            if (!placeholder && null != value) {
                Date date = (Date)ConvertAdapter.convert((Object)value, Date.class, (boolean)false);
                value = " to_timestamp( '" + DateUtil.format((Date)date) + "' , 'YYYY-MM-DD HH24:MI:SS')";
            }
            return value;
        }
    }),
    PointWriter(new Object[]{Point.class, StandardColumnType.POINT}, new DataWriter(){

        public Object write(Object value, boolean placeholder) {
            if (value instanceof Point) {
                Point point = (Point)value;
                PGpoint pg = PostgresqlGeometryAdapter.convert(point);
                if (placeholder) {
                    return pg;
                }
                return point.toString(true);
            }
            return value;
        }
    }),
    LineSegmentWriter(new Object[]{LineSegment.class, StandardColumnType.LSEG}, new DataWriter(){

        public Object write(Object value, boolean placeholder) {
            if (value instanceof LineSegment) {
                LineSegment segment = (LineSegment)value;
                PGlseg pg = PostgresqlGeometryAdapter.convert(segment);
                if (placeholder) {
                    return pg;
                }
                return segment.toString(true);
            }
            return value;
        }
    }),
    PathWriter(new Object[]{LineString.class, StandardColumnType.PATH}, new DataWriter(){

        public Object write(Object value, boolean placeholder) {
            if (value instanceof LineString) {
                LineString string = (LineString)value;
                PGpath pg = PostgresqlGeometryAdapter.convert(string);
                if (placeholder) {
                    return pg;
                }
                return string.toString(true);
            }
            return value;
        }
    }),
    LineWriter(new Object[]{Line.class, StandardColumnType.LINE}, new DataWriter(){

        public Object write(Object value, boolean placeholder) {
            if (value instanceof Line) {
                Line line = (Line)value;
                PGline pg = PostgresqlGeometryAdapter.convert(line);
                if (placeholder) {
                    return pg;
                }
                return line.toString(true);
            }
            return value;
        }
    }),
    BoxWriter(new Object[]{Box.class, StandardColumnType.BOX}, new DataWriter(){

        public Object write(Object value, boolean placeholder) {
            if (value instanceof Box) {
                Box box = (Box)value;
                PGbox pg = PostgresqlGeometryAdapter.convert(box);
                if (placeholder) {
                    return pg;
                }
                return box.toString(true);
            }
            return value;
        }
    }),
    CircleWriter(new Object[]{Circle.class, StandardColumnType.CIRCLE}, new DataWriter(){

        public Object write(Object value, boolean placeholder) {
            if (value instanceof Circle) {
                Circle circle = (Circle)value;
                PGcircle pg = PostgresqlGeometryAdapter.convert(circle);
                if (placeholder) {
                    return pg;
                }
                return circle.toString(true);
            }
            return value;
        }
    });

    private final Object[] supports;
    private final DataWriter writer;

    public Object[] supports() {
        return this.supports;
    }

    public DataWriter writer() {
        return this.writer;
    }

    private PostgresqlWriter(Object[] supports, DataWriter writer) {
        this.supports = supports;
        this.writer = writer;
    }
}

