/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.postgresql;

import org.anyline.adapter.DataReader;
import org.anyline.data.jdbc.postgresql.PostgresqlGeometryAdapter;
import org.postgresql.geometric.PGbox;
import org.postgresql.geometric.PGcircle;
import org.postgresql.geometric.PGline;
import org.postgresql.geometric.PGlseg;
import org.postgresql.geometric.PGpath;
import org.postgresql.geometric.PGpoint;
import org.postgresql.geometric.PGpolygon;
import org.postgresql.jdbc.PgArray;

public enum PostgresqlReader {
    PointReader(new Object[]{PGpoint.class}, new DataReader(){

        public Object read(Object value) {
            if (value instanceof PGpoint) {
                value = PostgresqlGeometryAdapter.parsePoint((PGpoint)value);
            }
            return value;
        }
    }),
    LineSegmentReader(new Object[]{PGlseg.class}, new DataReader(){

        public Object read(Object value) {
            if (value instanceof PGlseg) {
                value = PostgresqlGeometryAdapter.parseLineSegment((PGlseg)value);
            }
            return value;
        }
    }),
    PathReader(new Object[]{PGpath.class}, new DataReader(){

        public Object read(Object value) {
            if (value instanceof PGpath) {
                value = PostgresqlGeometryAdapter.parsePath((PGpath)value);
            }
            return value;
        }
    }),
    PolygonReader(new Object[]{PGpolygon.class}, new DataReader(){

        public Object read(Object value) {
            if (value instanceof PGpolygon) {
                value = PostgresqlGeometryAdapter.parsePolygon((PGpolygon)value);
            }
            return value;
        }
    }),
    CircleReader(new Object[]{PGcircle.class}, new DataReader(){

        public Object read(Object value) {
            if (value instanceof PGcircle) {
                value = PostgresqlGeometryAdapter.parseCircle((PGcircle)value);
            }
            return value;
        }
    }),
    LineReader(new Object[]{PGline.class}, new DataReader(){

        public Object read(Object value) {
            if (value instanceof PGline) {
                value = PostgresqlGeometryAdapter.parseLine((PGline)value);
            }
            return value;
        }
    }),
    BoxReader(new Object[]{PGbox.class}, new DataReader(){

        public Object read(Object value) {
            if (value instanceof PGbox) {
                value = PostgresqlGeometryAdapter.parseBox((PGbox)value);
            }
            return value;
        }
    }),
    ArrayReader(new Object[]{PgArray.class}, new DataReader(){

        public Object read(Object value) {
            if (value instanceof PgArray) {
                PgArray array = (PgArray)value;
                try {
                    value = array.getArray();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return value;
        }
    });

    private final Object[] supports;
    private final DataReader reader;

    public Object[] supports() {
        return this.supports;
    }

    public DataReader reader() {
        return this.reader;
    }

    private PostgresqlReader(Object[] supports, DataReader reader) {
        this.supports = supports;
        this.reader = reader;
    }
}

