/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.anyline.util.BasicUtil;
import org.anyline.util.DateUtil;
import org.anyline.util.regular.RegularUtil;

public class SeoUtil {
    private static final int MIN_BODY_LEN = 20;
    private static final int KEYWORDS_DENSITY = 6;
    private static final int MIN_KEYWORDS_GAP = 50;
    private static final String SIGN_REPLACE_CHAR = "~";
    private static final int SEARCH_SING_SCOPE = 10;

    public static String insertKeyword(String src, List<String> keys) {
        ArrayList<Integer> idxList = new ArrayList<Integer>();
        HashMap<Integer, String> idxKeyMap = new HashMap<Integer, String>();
        int srcLen = src.length();
        if (srcLen < 20) {
            return src;
        }
        int week = DateUtil.getWeekOfYear() + DateUtil.month();
        int size = keys.size();
        block0: for (int i = 0; i < size; ++i) {
            int existKeyCount;
            int bodyWordSize;
            int insertKkeyCount;
            String key = keys.get(i);
            if (null == key || key.trim().isEmpty() || 0 == (insertKkeyCount = 6 * (bodyWordSize = srcLen / (key = key.trim()).length()) / 100 - (existKeyCount = BasicUtil.charCount(src, key)))) continue;
            int partLen = srcLen / insertKkeyCount;
            for (int j = 1; j <= insertKkeyCount; ++j) {
                int insertIdx = 0;
                insertIdx = j % 2 == 0 ? partLen * j + week * j : partLen * j - week * j;
                insertIdx -= i * 20;
                if (i > 0) {
                    insertIdx = insertIdx - (i + 1) * keys.get(i - 1).length() - j * key.length();
                }
                if ((insertIdx = Math.abs(insertIdx)) > srcLen) {
                    insertIdx %= srcLen;
                }
                idxList.add(insertIdx);
                idxKeyMap.put(insertIdx, key);
                if (insertKkeyCount <= 1) continue block0;
            }
        }
        src = SeoUtil.insert(src, idxList, idxKeyMap);
        return src;
    }

    private static int getNearSignIdx(List<Integer> idxs, int idx) {
        for (int item : idxs) {
            if (Math.abs(item - idx) > 10) continue;
            return item;
        }
        return idx;
    }

    private static List<Integer> getSingIdx(String src) {
        ArrayList<Integer> idxs = new ArrayList<Integer>();
        String signTmpSrc = src.replaceAll("[,.;?!:'\",\u3002\uff1b\uff1f\uff01\uff1a\u2019\u201d>]", SIGN_REPLACE_CHAR);
        int idx = -1;
        while ((idx = signTmpSrc.indexOf(SIGN_REPLACE_CHAR, idx + 1)) != -1) {
            idxs.add(0, idx);
        }
        return idxs;
    }

    private static String insert(String src, List<Integer> idxList, Map<Integer, String> idxKeyMap) {
        List<Integer> signIdxList = SeoUtil.getSingIdx((String)src);
        Collections.sort(idxList);
        int size = idxList.size();
        for (int i = size - 1; i >= 0; --i) {
            boolean isBreakTag;
            Integer idx = idxList.get(i);
            String key = idxKeyMap.get(idx);
            int insertIdx = SeoUtil.getNearSignIdx(signIdxList, idx);
            if (SeoUtil.isNearExistKey((String)src, key, ++insertIdx) || (isBreakTag = SeoUtil.isBreakTag((String)src, insertIdx, key))) continue;
            src = ((String)src).substring(0, insertIdx) + "<b>" + key + "</b>" + ((String)src).substring(insertIdx);
        }
        return src;
    }

    private static boolean isBreakTag(String src, int idx, String key) {
        boolean isBreak = false;
        src = ((String)src).substring(0, idx) + key + ((String)src).substring(idx);
        int fr = idx - 100;
        int to = idx + key.length() + 100;
        if (fr < 0) {
            fr = 0;
        }
        if (to > ((String)src).length()) {
            to = ((String)src).length();
        }
        src = ((String)src).substring(fr, to);
        String regx = "<[^>]*?" + key + "[^<]*?>";
        isBreak = RegularUtil.match((String)src, regx);
        return isBreak;
    }

    private static boolean isNearExistKey(String src, String key, int idx) {
        boolean keyExist = false;
        int nearKeyIdx = src.indexOf(key, idx - key.length() - 10);
        if (nearKeyIdx != -1 && Math.abs(nearKeyIdx - idx) <= 50) {
            keyExist = true;
        } else {
            String tmp;
            if ((idx = idx + key.length() + 10) >= src.length()) {
                idx = src.length();
            }
            if ((nearKeyIdx = (tmp = src.substring(0, idx)).lastIndexOf(key)) != -1 && Math.abs(nearKeyIdx - idx) <= 50) {
                keyExist = true;
            }
        }
        return keyExist;
    }
}

