/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.util;

import java.math.BigDecimal;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.anyline.util.BeanUtil;
import org.anyline.util.CodeUtil;
import org.anyline.util.DateUtil;
import org.anyline.util.NumberUtil;
import org.anyline.util.regular.RegularUtil;

public class BasicUtil {
    public static final String SINGLE_CHAR = "abcdefghijklmnopqrstuvwxyz0123456789,.?'_-=+!@#$%^&*() ";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isEmpty(boolean recursion, Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof Collection && recursion) {
            Collection collection = (Collection)obj;
            if (collection.isEmpty()) {
                return true;
            }
            for (Object item : collection) {
                if (BasicUtil.isEmpty(recursion, item)) continue;
                return false;
            }
            return true;
        } else if (obj.getClass().isArray()) {
            Object[] array;
            if (obj instanceof int[]) {
                if (((int[])obj).length <= 0) return true;
                return false;
            }
            if (obj instanceof double[]) {
                if (((double[])obj).length <= 0) return true;
                return false;
            }
            if (obj instanceof float[]) {
                if (((float[])obj).length <= 0) return true;
                return false;
            }
            if (obj instanceof short[]) {
                if (((short[])obj).length <= 0) return true;
                return false;
            }
            if (obj instanceof byte[]) {
                if (((byte[])obj).length <= 0) return true;
                return false;
            }
            if (obj instanceof boolean[]) {
                if (((boolean[])obj).length <= 0) return true;
                return false;
            }
            for (Object item : array = (Object[])obj) {
                if (BasicUtil.isEmpty(recursion, item)) continue;
                return false;
            }
            return true;
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            if (map.isEmpty()) {
                return true;
            }
            if (!recursion) return false;
            for (Object item : map.values()) {
                if (BasicUtil.isEmpty(recursion, item)) continue;
                return false;
            }
            return true;
        } else {
            String tmp = obj.toString();
            if (null == tmp) {
                return true;
            }
            if ((tmp = tmp.trim()).equals("") || tmp.equals("null")) return true;
            return false;
        }
    }

    public static boolean isEmpty(Object obj) {
        return BasicUtil.isEmpty(false, obj);
    }

    public static boolean isEmpty(Object ... objs) {
        if (null == objs) {
            return true;
        }
        for (Object obj : objs) {
            if (BasicUtil.isEmpty(false, obj)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotEmpty(Object obj) {
        return !BasicUtil.isEmpty(false, obj);
    }

    public static boolean isNotEmpty(boolean recursion, Object obj) {
        return !BasicUtil.isEmpty(recursion, obj);
    }

    public static boolean equals(byte[] bytes1, byte[] bytes2) {
        if (null == bytes1) {
            return null == bytes2;
        }
        if (null == bytes2) {
            return false;
        }
        int l1 = bytes1.length;
        int l2 = bytes2.length;
        if (l1 != l2) {
            return false;
        }
        for (int i = 0; i < l1; ++i) {
            if (bytes1[i] == bytes2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object obj1, Object obj2) {
        if (null == obj1) {
            return null == obj2;
        }
        if (null == obj2) {
            return false;
        }
        return obj1.toString().equals(obj2.toString());
    }

    public static boolean equalsIgnoreCase(Object obj1, Object obj2) {
        if (null == obj1) {
            return null == obj2;
        }
        if (null == obj2) {
            return false;
        }
        return obj1.toString().equalsIgnoreCase(obj2.toString());
    }

    public static <T> T nvl(T ... values) {
        if (null == values) {
            return null;
        }
        for (T item : values) {
            if (null == item) continue;
            return item;
        }
        return null;
    }

    public static <T> T evl(boolean recursion, T ... values) {
        if (null == values) {
            return null;
        }
        for (T item : values) {
            if (!BasicUtil.isNotEmpty(recursion, item)) continue;
            return item;
        }
        return null;
    }

    public static <T> T evl(T ... values) {
        return BasicUtil.evl(false, values);
    }

    public static int getRandomNumber(int fr, int to) {
        return NumberUtil.random(fr, to);
    }

    public static double getRandomNumber(double fr, double to) {
        return NumberUtil.random(fr, to);
    }

    public static String getRandomString(int length, StringBuffer buffer) {
        StringBuffer sb = new StringBuffer();
        Random r = new Random();
        int range = buffer.length();
        for (int i = 0; i < length; ++i) {
            sb.append(buffer.charAt(r.nextInt(range)));
        }
        return sb.toString();
    }

    public static String getRandomString(int length) {
        return BasicUtil.getRandomString(length, new StringBuffer("012356789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"));
    }

    public static String getRandomLowerString(int length) {
        return BasicUtil.getRandomString(length, new StringBuffer("abcdefghijklmnopqrstuvwxyz"));
    }

    public static String getRandomUpperString(int length) {
        return BasicUtil.getRandomString(length, new StringBuffer("ABCDEFGHIJKLMNOPQRSTUVWXYZ"));
    }

    public static String getRandomNumberString(int length) {
        return BasicUtil.getRandomString(length, new StringBuffer("123567890"));
    }

    public static String getRandomCnString(int length) {
        Object result = "";
        for (int i = 0; i < length; ++i) {
            String str = null;
            Random random = new Random();
            int hPos = 176 + Math.abs(random.nextInt(39));
            int lPos = 161 + Math.abs(random.nextInt(93));
            byte[] b = new byte[]{Integer.valueOf(hPos).byteValue(), Integer.valueOf(lPos).byteValue()};
            try {
                str = new String(b, "GBk");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            result = (String)result + str;
        }
        return result;
    }

    public static String insert(String src, int idx, String key) {
        if (null == src || null == key) {
            return src;
        }
        src = ((String)src).substring(0, idx) + key + ((String)src).substring(idx);
        return src;
    }

    public static boolean isNumber(Object obj) {
        boolean result = false;
        if (obj == null) {
            return result;
        }
        if (obj instanceof Number) {
            return true;
        }
        String str = obj.toString();
        try {
            Double.parseDouble(str);
            result = true;
        }
        catch (Exception e) {
            result = false;
        }
        return result;
    }

    public static boolean isBoolean(Object obj) {
        boolean result = false;
        if (null == obj) {
            return result;
        }
        if (obj instanceof Boolean) {
            return true;
        }
        if (obj.toString().equalsIgnoreCase("true") || obj.toString().equalsIgnoreCase("false")) {
            return true;
        }
        return result;
    }

    public static boolean isDate(Object obj) {
        if (null == obj) {
            return false;
        }
        if (obj instanceof java.util.Date) {
            return true;
        }
        return RegularUtil.isDate(obj.toString());
    }

    public static boolean isDateTime(Object obj) {
        if (null == obj) {
            return false;
        }
        if (obj instanceof java.util.Date) {
            return true;
        }
        return RegularUtil.isDateTime(obj.toString());
    }

    public static Byte parseByte(Object value, Byte def) {
        try {
            return Byte.parseByte(value.toString());
        }
        catch (Exception e) {
            return def;
        }
    }

    public static Byte parseByte(Object value) throws Exception {
        return Byte.parseByte(value.toString());
    }

    public static Short parseShort(Object value, Short def) {
        if (null == value) {
            return def;
        }
        if (value instanceof Short) {
            return (Short)value;
        }
        try {
            return (short)Double.parseDouble(value.toString());
        }
        catch (Exception e) {
            return def;
        }
    }

    public static Short parseShort(Object value) throws Exception {
        return (short)Double.parseDouble(value.toString());
    }

    public static Integer parseInt(Object value, Integer def) {
        if (null == value) {
            return def;
        }
        if (value instanceof Integer) {
            return (Integer)value;
        }
        try {
            return (int)Double.parseDouble(value.toString().trim());
        }
        catch (Exception e) {
            return def;
        }
    }

    public static Integer parseInt(Object value) throws Exception {
        return (int)Double.parseDouble(value.toString());
    }

    public static Float parseFloat(Object value, Float def) {
        if (null == value) {
            return def;
        }
        if (value instanceof Float) {
            return (Float)value;
        }
        try {
            return Float.valueOf(Float.parseFloat(value.toString()));
        }
        catch (Exception e) {
            return def;
        }
    }

    public static Double parseDouble(Object value, Double def) {
        if (null == value) {
            return def;
        }
        if (value instanceof Double) {
            return (Double)value;
        }
        try {
            return Double.parseDouble(value.toString());
        }
        catch (Exception e) {
            return def;
        }
    }

    public static BigDecimal parseDecimal(Object value, double def) {
        return BasicUtil.parseDecimal(value, new BigDecimal(def));
    }

    public static BigDecimal parseDecimal(Object value, BigDecimal def) {
        if (null == value) {
            return def;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        BigDecimal result = null;
        if (value instanceof Long) {
            result = new BigDecimal((Long)value);
        } else if (value instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)value;
            result = new BigDecimal(date.getTime());
        } else if (value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            result = new BigDecimal(timestamp.getTime());
        } else if (value instanceof Date) {
            Date date = (Date)value;
            result = new BigDecimal(date.getTime());
        } else if (value instanceof LocalDateTime) {
            result = new BigDecimal(DateUtil.parse((LocalDateTime)value).getTime());
        } else if (value instanceof LocalDate) {
            result = new BigDecimal(DateUtil.parse((LocalDate)value).getTime());
        } else {
            try {
                result = new BigDecimal(value.toString());
            }
            catch (Exception e) {
                return def;
            }
        }
        if (null == result) {
            result = def;
        }
        return result;
    }

    public static Long parseLong(Object value, Long def) {
        try {
            return BasicUtil.parseLong(value);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static Long parseLong(Object value) throws Exception {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof java.util.Date) {
            java.util.Date date = (java.util.Date)value;
            return date.getTime();
        }
        if (value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            return timestamp.getTime();
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return date.getTime();
        }
        if (value instanceof LocalDateTime || value instanceof LocalDate) {
            return DateUtil.parse(value).getTime();
        }
        return Long.parseLong(value.toString());
    }

    public static Boolean parseBoolean(Object obj, Boolean def) {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        try {
            return BasicUtil.parseBoolean(obj);
        }
        catch (Exception e) {
            return def;
        }
    }

    public static Boolean parseBoolean(Object obj) throws Exception {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if ("1".equals(obj.toString()) || "true".equalsIgnoreCase(obj.toString()) || "t".equalsIgnoreCase(obj.toString()) || "on".equalsIgnoreCase(obj.toString()) || "yes".equalsIgnoreCase(obj.toString()) || "y".equalsIgnoreCase(obj.toString())) {
            return true;
        }
        if ("0".equals(obj.toString()) || "false".equalsIgnoreCase(obj.toString()) || "off".equalsIgnoreCase(obj.toString()) || "f".equalsIgnoreCase(obj.toString()) || "no".equalsIgnoreCase(obj.toString()) || "n".equalsIgnoreCase(obj.toString())) {
            return false;
        }
        return Boolean.parseBoolean(obj.toString());
    }

    public static List<String> parseLimit(int num) {
        ArrayList<String> list = new ArrayList<String>();
        int count = 0;
        while (num >= 1) {
            int temp = num % 2;
            num = (num - temp) / 2;
            if (temp == 1) {
                if (count == 0) {
                    list.add("1");
                } else {
                    list.add("" + (2 << count - 1));
                }
            }
            ++count;
        }
        return list;
    }

    public static String replace(String src, String pattern, String replace) {
        if (src == null) {
            return null;
        }
        int s = 0;
        int e = 0;
        StringBuilder result = new StringBuilder();
        while ((e = src.indexOf(pattern, s)) >= 0) {
            result.append(src.substring(s, e));
            result.append(replace);
            s = e + pattern.length();
        }
        result.append(src.substring(s));
        return result.toString();
    }

    public static String trim(Object str) {
        Object result = "";
        result = str != null ? (!BasicUtil.isNumber(str) ? str.toString().trim() : "" + str) : "";
        if (((String)result).equals("-1")) {
            result = "";
        }
        return result;
    }

    public static String trim(String str) {
        Object result = "";
        result = str != null ? (!BasicUtil.isNumber(str) ? str.toString().trim() : str) : "";
        if (((String)result).equals("-1")) {
            result = "";
        }
        return result;
    }

    public static String compress(String str) {
        if (null != str) {
            str = str.replaceAll("\\s{2,}", " ").trim();
        }
        return str;
    }

    public static String[] compress(String[] strs) {
        if (null != strs) {
            int size = strs.length;
            for (int i = 0; i < size; ++i) {
                strs[i] = BasicUtil.compress(strs[i]);
            }
        }
        return strs;
    }

    public static List<String> compress(List<String> strs) {
        ArrayList<String> result = new ArrayList<String>();
        if (null != strs) {
            for (String str : strs) {
                result.add(BasicUtil.compress(str));
            }
        }
        return strs;
    }

    public static String compressXml(String xml) {
        xml = BasicUtil.compress(xml);
        xml = xml.replaceAll("<\\!--[\\s\\S]*-->", "");
        xml = xml.replaceAll("\\s{1,}<", "<");
        return xml;
    }

    public static String fillLChar(String src, String chr, int len) {
        if (null != src && null != chr && chr.length() > 0) {
            while (((String)src).length() < len) {
                src = chr + (String)src;
            }
        }
        return src;
    }

    public static String fillRChar(String src, String chr, int len) {
        if (null != src && null != chr && chr.length() > 0) {
            while (((String)src).length() < len) {
                src = (String)src + chr;
            }
        }
        return src;
    }

    public static String fillChar(String src, String chr, int len) {
        return BasicUtil.fillLChar(src, chr, len);
    }

    public static String fillChar(String src, int len) {
        return BasicUtil.fillChar(src, "0", len);
    }

    public static String fillLChar(int src, String chr, int len) {
        return BasicUtil.fillLChar("" + src, chr, len);
    }

    public static String fillRChar(int src, String chr, int len) {
        return BasicUtil.fillRChar("" + src, chr, len);
    }

    public static String fillChar(int src, String chr, int len) {
        return BasicUtil.fillChar("" + src, chr, len);
    }

    public static String fillChar(int src, int len) {
        return BasicUtil.fillChar("" + src, len);
    }

    public static List<String> getMapKeys(Map<?, ?> map) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Object value : map.keySet()) {
            if (null == value) continue;
            keys.add(value.toString());
        }
        return keys;
    }

    public static List<String> split(String str, String separator) {
        ArrayList<String> list = new ArrayList<String>();
        if (null != str && null != separator) {
            String[] tmps;
            for (String tmp : tmps = str.split(separator)) {
                if (!BasicUtil.isNotEmpty(tmp = tmp.trim())) continue;
                list.add(tmp);
            }
        }
        return list;
    }

    public static int charCount(String src, String chr) {
        int count = 0;
        int idx = -1;
        if (null == src || null == chr || chr.trim().isEmpty()) {
            return 0;
        }
        while ((idx = src.indexOf(chr, idx + chr.length())) != -1) {
            ++count;
        }
        return count;
    }

    public static Object fetch(Collection<?> items, String key, Object value) {
        if (null == items) {
            return null;
        }
        for (Object item : items) {
            Object tmpValue = BeanUtil.getFieldValue(item, key);
            if (null == tmpValue || !tmpValue.equals(value)) continue;
            return item;
        }
        return null;
    }

    public static String cut(String src, int fr, int to) {
        if (null == src) {
            return null;
        }
        int len = src.length();
        if (to > len) {
            to = len;
        }
        if (to < 0) {
            to = src.length() + to;
        }
        if (to < 0 || to < fr) {
            return null;
        }
        return src.substring(fr, to);
    }

    public static String left(String src, int len) {
        if (null == src) {
            return null;
        }
        int max = src.length();
        if (len > max) {
            len = max;
        }
        return src.substring(0, len);
    }

    public static String right(String src, int len) {
        if (null == src) {
            return null;
        }
        int max = src.length();
        if (len > max) {
            len = max;
        }
        return src.substring(max - len, max);
    }

    public static String ellipsis(int length, String src) {
        Object result = "";
        int size = length * 2;
        String[] chrs = src.split("");
        long cnt = 0L;
        boolean above = false;
        for (String chr : chrs) {
            if (cnt >= (long)size) {
                above = true;
                break;
            }
            cnt = SINGLE_CHAR.contains(chr.toLowerCase()) ? ++cnt : (cnt += 2L);
            result = (String)result + chr;
        }
        if (above) {
            result = (String)result + "...";
        }
        return result;
    }

    public static List<InetAddress> localInetAddress() {
        ArrayList<InetAddress> ips = new ArrayList<InetAddress>();
        try {
            Enumeration<NetworkInterface> allNetInterfaces = NetworkInterface.getNetworkInterfaces();
            InetAddress ip = null;
            while (allNetInterfaces.hasMoreElements()) {
                NetworkInterface netInterface = allNetInterfaces.nextElement();
                Enumeration<InetAddress> addresses = netInterface.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    ip = addresses.nextElement();
                    if (ip == null || !(ip instanceof Inet4Address)) continue;
                    ips.add(ip);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ips;
    }

    public static List<String> localIps() {
        ArrayList<String> ips = new ArrayList<String>();
        List<InetAddress> list = BasicUtil.localInetAddress();
        for (InetAddress ip : list) {
            ips.add(ip.getHostAddress());
        }
        return ips;
    }

    public static boolean containsString(boolean ignoreNull, boolean ignoreCase, Object[] objs, String obj) {
        if (null == objs) {
            return false;
        }
        return BasicUtil.containsString(ignoreNull, ignoreCase, BeanUtil.array2list(new Object[][]{objs}), obj);
    }

    public static int index(boolean ignoreNull, boolean ignoreCase, Object[] objs, String obj) {
        if (null == objs) {
            return -1;
        }
        return BasicUtil.index(ignoreNull, ignoreCase, BeanUtil.array2list(new Object[][]{objs}), obj);
    }

    public static boolean containsString(Object[] objs, String obj) {
        return BasicUtil.containsString(false, false, objs, obj);
    }

    public static int index(Object[] objs, String obj) {
        return BasicUtil.index(false, false, objs, obj);
    }

    public static boolean contains(Object[] objs, Object obj) {
        if (null == objs) {
            return false;
        }
        return BasicUtil.contains(false, BeanUtil.array2list(new Object[][]{objs}), obj);
    }

    public static int index(Object[] objs, Object obj) {
        if (null == objs) {
            return -1;
        }
        return BasicUtil.index(false, BeanUtil.array2list(new Object[][]{objs}), obj);
    }

    public static int index(boolean ignoreNull, Collection<Object> objs, Object obj) {
        return BasicUtil.index(ignoreNull, objs, obj);
    }

    public static boolean contains(boolean ignoreNull, Collection<Object> objs, Object obj) {
        if (null == objs) {
            return false;
        }
        for (Object o : objs) {
            if (ignoreNull) {
                if (null == obj || null == o) {
                    continue;
                }
            } else if (null == obj && null == o) {
                return true;
            }
            if (null == o || !obj.equals(o)) continue;
            return true;
        }
        return false;
    }

    public static <T> boolean containsString(boolean ignoreNull, boolean ignoreCase, Collection<T> objs, String obj) {
        if (null == objs) {
            return false;
        }
        boolean idx = false;
        for (T o : objs) {
            if (ignoreNull) {
                if (null == obj || null == o) {
                    continue;
                }
            } else if (null == obj && null == o) {
                return true;
            }
            if (null == obj || null == o) continue;
            String val = o.toString();
            if (ignoreCase) {
                obj = obj.toLowerCase();
                val = val.toLowerCase();
            }
            if (!obj.equals(val)) continue;
            return true;
        }
        return false;
    }

    public static <T> int index(boolean ignoreNull, boolean ignoreCase, Collection<T> objs, String obj) {
        int idx = -1;
        if (null == objs) {
            return -1;
        }
        for (T o : objs) {
            ++idx;
            if (ignoreNull) {
                if (null == obj || null == o) {
                    continue;
                }
            } else if (null == obj && null == o) {
                return idx;
            }
            if (null == obj || null == o) continue;
            String val = o.toString();
            if (ignoreCase) {
                obj = obj.toLowerCase();
                val = val.toLowerCase();
            }
            if (!obj.equals(val)) continue;
            return idx;
        }
        return -1;
    }

    public static boolean containsString(Collection<Object> objs, String obj) {
        return BasicUtil.containsString(false, false, objs, obj);
    }

    public static int index(Collection<Object> objs, String obj) {
        return BasicUtil.index(false, false, objs, obj);
    }

    public static String concat(List<String> list, String split) {
        if (null == list) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        for (String val : list) {
            if (BasicUtil.isEmpty((Object)val)) continue;
            if (result.length() > 0) {
                result.append(split);
            }
            result.append(val);
        }
        return result.toString();
    }

    public static String concat(String split, String ... values) {
        StringBuilder builder = new StringBuilder();
        if (null != values) {
            for (String value : values) {
                if (BasicUtil.isEmpty((Object)value)) continue;
                if (builder.length() > 0) {
                    builder.append(split);
                }
                builder.append(value);
            }
        }
        return builder.toString();
    }

    public static String omit(String src, int left, int right) {
        return BasicUtil.omit(src, left, right, "*");
    }

    public static String omit(String src, int left, int right, String ellipsis) {
        Object result = "";
        if (BasicUtil.isEmpty((Object)src)) {
            return result;
        }
        int length = src.length();
        if (left > length) {
            left = length;
        }
        if (right > length - left) {
            right = length - left;
        }
        String l = src.substring(0, left);
        String r = src.substring(length - right);
        result = l + BasicUtil.fillRChar("", ellipsis, length - left - right) + r;
        return result;
    }

    public static String escape(String src) {
        return CodeUtil.escape(src);
    }

    public static String unescape(String src) {
        return CodeUtil.unescape(src);
    }

    public static boolean equals(Object v1, Object v2, List<String> propertys1, List<String> propertys2) {
        boolean result = false;
        if (null == v1 && null == v2) {
            return true;
        }
        if (null == v1 || null == v2) {
            return false;
        }
        if (v1 instanceof String || v1 instanceof Number || v1 instanceof Boolean || v1 instanceof java.util.Date) {
            if (v2 instanceof String || v2 instanceof Number || v2 instanceof Boolean || v2 instanceof java.util.Date) {
                result = v2.toString().equals(v1.toString());
            } else {
                if (null != propertys2 && propertys2.size() > 0) {
                    v2 = "" + BeanUtil.getFieldValue(v2, propertys2.get(0));
                }
                result = v2.toString().equals(v1.toString());
            }
        } else if (v2 instanceof String || v2 instanceof Number || v2 instanceof Boolean || v2 instanceof java.util.Date) {
            if (null != propertys1 && propertys1.size() > 0) {
                v1 = "" + BeanUtil.getFieldValue(v1, propertys1.get(0));
            }
            result = v2.toString().equals(v1.toString());
        } else {
            boolean eq = true;
            int psize = 0;
            if (null == propertys1 || null == propertys2) {
                eq = false;
            } else {
                psize = NumberUtil.min(propertys1.size(), propertys2.size());
            }
            if (psize > 0) {
                for (int i = 0; i < psize; ++i) {
                    String vv2;
                    String p1 = propertys1.get(i);
                    String p2 = propertys2.get(i);
                    String vv1 = "" + BeanUtil.getFieldValue(v1, p1);
                    if (vv1.equals(vv2 = "" + BeanUtil.getFieldValue(v2, p2))) continue;
                    eq = false;
                    break;
                }
            } else {
                eq = v1.equals(v2);
            }
            if (eq) {
                result = true;
            }
        }
        return result;
    }

    public static boolean equals(Object v1, Object v2, String propertys) {
        boolean result = false;
        ArrayList<String> propertys1 = new ArrayList<String>();
        ArrayList<String> propertys2 = new ArrayList<String>();
        if (BasicUtil.isNotEmpty(propertys)) {
            String[] ps;
            for (String p : ps = propertys.split(",")) {
                if (!BasicUtil.isNotEmpty(p)) continue;
                String p1 = p;
                String p2 = p;
                if (p.contains(":")) {
                    String[] tmps = p.split(":");
                    p1 = tmps[0];
                    p2 = tmps[1];
                }
                propertys1.add(p1);
                propertys2.add(p2);
            }
        }
        return BasicUtil.equals(v1, v2, propertys1, propertys2);
    }

    public static int index(int index, int size) {
        if (size == 0) {
            return 0;
        }
        if (index >= size) {
            index = size - 1;
        } else if (index < 0 && (index = size + index) < 0) {
            index = 0;
        }
        return index;
    }

    public static int[] range(Integer begin, Integer end, Integer qty, Integer total) {
        int[] result = new int[2];
        if (null != begin && begin < 0) {
            begin = 0;
        }
        if (null != end && end < 0) {
            begin = total + end;
            end = total;
        }
        if (null != begin && null != qty) {
            end = begin + qty;
        }
        if (null != total && (null == end || end > total)) {
            end = total;
        }
        if (null == begin) {
            begin = 0;
        }
        if (null == end) {
            end = total;
        }
        if (end < begin) {
            end = begin;
        }
        if (begin < 0) {
            begin = 0;
        }
        if (end < 0) {
            end = 0;
        }
        result[0] = begin;
        result[1] = end;
        return result;
    }
}

