/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.type.init;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.LinkedHashMap;
import org.anyline.entity.DataRow;
import org.anyline.metadata.type.Convert;
import org.anyline.metadata.type.ConvertException;
import org.anyline.metadata.type.DataType;
import org.anyline.util.BasicUtil;
import org.anyline.util.DateUtil;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum DefaultJavaType implements DataType
{
    JAVA_STRING("VARCHAR", String.class, false, true){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            String str;
            if (null == value) {
                value = def;
            }
            if (value instanceof String) {
                str = (String)value;
                if (str.startsWith("${") && str.endsWith("}")) {
                    value = str.substring(2, str.length() - 1);
                }
            } else {
                value = value instanceof java.util.Date ? DateUtil.format((java.util.Date)value) : value.toString();
            }
            if (!(null == value || placeholder || (str = value.toString()).startsWith("'") && str.endsWith("'"))) {
                value = "'" + str + "'";
            }
            return value;
        }
    }
    ,
    JAVA_BOOLEAN("BOOLEAN", Boolean.class, true, true){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            if (null == value) {
                value = def;
            }
            Boolean result = BasicUtil.parseBoolean(value, null);
            if (null != def && null == result) {
                result = BasicUtil.parseBoolean(def, null);
            }
            return result;
        }
    }
    ,
    JAVA_INTEGER("INT", Integer.class, true, true){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            if (null == value) {
                value = def;
            }
            Integer result = BasicUtil.parseInt(value, null);
            if (null == value) {
                result = BasicUtil.parseInt(def, null);
            }
            return result;
        }
    }
    ,
    JAVA_LONG("LONG", Long.class, true, true){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            if (null == value) {
                value = def;
            }
            Long result = BasicUtil.parseLong(value, null);
            if (null != def && null == result) {
                result = BasicUtil.parseLong(def, null);
            }
            return result;
        }
    }
    ,
    JAVA_FLOAT("FLOAT", Float.class, false, false){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            if (null == value) {
                value = def;
            }
            Float result = BasicUtil.parseFloat(value, null);
            if (null != def && null == result) {
                result = BasicUtil.parseFloat(def, null);
            }
            return result;
        }
    }
    ,
    JAVA_DOUBLE("DOUBLE", Double.class, false, false){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            if (null == value) {
                value = def;
            }
            Double result = BasicUtil.parseDouble(value, null);
            if (null != def && null == result) {
                result = BasicUtil.parseDouble(def, null);
            }
            return result;
        }
    }
    ,
    JAVA_DECIMAL("DECIMAL", BigDecimal.class, false, false){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            if (null == value) {
                value = def;
            }
            BigDecimal result = BasicUtil.parseDecimal(value, null);
            if (null != def && null == result) {
                result = BasicUtil.parseDecimal(def, null);
            }
            return result;
        }
    }
    ,
    JAVA_DATE("DATETIME", java.util.Date.class, true, true){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            Convert convert = this.convert(clazz);
            if (null != convert) {
                try {
                    value = convert.exe(value, def);
                }
                catch (ConvertException e) {
                    e.printStackTrace();
                }
            }
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            java.util.Date date;
            if (!(value instanceof Time) && null != (date = DateUtil.parse(value))) {
                value = placeholder ? new Timestamp(date.getTime()) : "'" + DateUtil.format(date, "yyyy-MM-dd HH:mm:ss") + "'";
            }
            return value;
        }
    }
    ,
    JAVA_SQL_TIMESTAMP("TIMESTAMP", Timestamp.class, true, true){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            java.util.Date date = DateUtil.parse(value);
            if (null != date) {
                value = placeholder ? new Timestamp(date.getTime()) : "'" + DateUtil.format(date) + "'";
            }
            return value;
        }
    }
    ,
    JAVA_SQL_TIME("TIME", Time.class, true, true){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            java.util.Date date = DateUtil.parse(value);
            if (null != date) {
                value = placeholder ? new Timestamp(date.getTime()) : "'" + DateUtil.format(date, "HH:mm:ss") + "'";
            }
            return value;
        }
    }
    ,
    JAVA_SQL_DATE("DATE", Date.class, true, true){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            if (null != value && value.getClass() != clazz) {
                java.util.Date date = DateUtil.parse(value);
                return JAVA_DATE.read(date, def, clazz);
            }
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            java.util.Date date;
            if (!(value instanceof Time) && null != (date = DateUtil.parse(value))) {
                value = placeholder ? new Timestamp(date.getTime()) : "'" + DateUtil.format(date, "yyyy-MM-dd HH:mm:ss") + "'";
            }
            return value;
        }
    }
    ,
    JAVA_LOCAL_DATE("DATE", LocalDate.class, true, true){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            java.util.Date date;
            if (!(value instanceof Time) && null != (date = DateUtil.parse(value))) {
                value = placeholder ? new Date(date.getTime()) : "'" + DateUtil.format(date, "yyyy-MM-dd") + "'";
            }
            return value;
        }
    }
    ,
    JAVA_LOCAL_TIME("TIME", LocalTime.class, true, true){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            java.util.Date date;
            if (!(value instanceof Time) && null != (date = DateUtil.parse(value))) {
                value = placeholder ? new Time(date.getTime()) : "'" + DateUtil.format(date, "HH:mm:ss") + "'";
            }
            return value;
        }
    }
    ,
    JAVA_LOCAL_DATE_TIME("DATETIME", LocalDateTime.class, true, true){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            java.util.Date date;
            if (!(value instanceof Time) && null != (date = DateUtil.parse(value))) {
                value = placeholder ? new Timestamp(date.getTime()) : "'" + DateUtil.format(date, "yyyy-MM-dd HH:mm:ss") + "'";
            }
            return value;
        }
    }
    ,
    JAVA_BYTES("", Byte[].class, true, true){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            if (null == value) {
                return null;
            }
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return value;
        }
    }
    ,
    BYTES("", byte[].class, true, true){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            if (null == value) {
                return null;
            }
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return value;
        }
    }
    ,
    JAVA_BYTE("", Byte.class, true, true){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            if (null == value) {
                return null;
            }
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return value;
        }
    }
    ,
    BYTE("", Byte.TYPE, true, true){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            if (null == value) {
                return null;
            }
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return value;
        }
    }
    ,
    ANYLINE_DATAROW("", DataRow.class, true, true){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            if (null == value) {
                return null;
            }
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return value;
        }
    }
    ,
    ANYLINE_DATASET("", DataRow.class, true, true){

        @Override
        public Object read(Object value, Object def, Class clazz) {
            if (null == value) {
                return null;
            }
            return value;
        }

        @Override
        public Object write(Object value, Object def, boolean placeholder) {
            return value;
        }
    };

    private LinkedHashMap<Class, Convert> converts = new LinkedHashMap();
    private final String name;
    private final Class clazz;
    private final Boolean ignorePrecision;
    private final Boolean ignoreScale;

    private DefaultJavaType(String name, Class clazz, Boolean ignorePrecision, Boolean ignoreScale) {
        this.name = name;
        this.clazz = clazz;
        this.ignorePrecision = ignorePrecision;
        this.ignoreScale = ignoreScale;
    }

    @Override
    public Object read(Object value, Object def, Class clazz) {
        return value;
    }

    @Override
    public Object write(Object value, Object def, boolean placeholder) {
        return value;
    }

    @Override
    public DataType convert(Convert convert) {
        this.converts.put(convert.getTarget(), convert);
        return this;
    }

    @Override
    public Convert convert(Class clazz) {
        return null;
    }

    @Override
    public boolean ignorePrecision() {
        return this.ignorePrecision;
    }

    @Override
    public boolean ignoreScale() {
        return this.ignoreScale;
    }

    @Override
    public boolean support() {
        return true;
    }

    @Override
    public Class supportClass() {
        return this.clazz;
    }
}

