/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata.type.init;

import java.lang.reflect.Field;
import org.anyline.adapter.init.ConvertAdapter;
import org.anyline.metadata.type.ColumnType;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.util.BasicUtil;

public class AbstractColumnType
implements ColumnType {
    private boolean array;
    private DatabaseType[] dbs;
    private String name;
    private Class transfer;
    private Class compatible;
    private Boolean ignorePrecision;
    private Boolean ignoreScale;

    public AbstractColumnType(String name, DatabaseType db, Class transfer, Class compatible, Boolean ignorePrecision, Boolean ignoreScale) {
        this.name = name;
        this.dbs = new DatabaseType[]{db};
        this.transfer = transfer;
        this.compatible = compatible;
        this.ignorePrecision = ignorePrecision;
        this.ignoreScale = ignoreScale;
    }

    public AbstractColumnType(String name, DatabaseType db, Class compatible, Boolean ignorePrecision, Boolean ignoreScale) {
        this.name = name;
        this.dbs = new DatabaseType[]{db};
        this.compatible = compatible;
        this.ignorePrecision = ignorePrecision;
        this.ignoreScale = ignoreScale;
    }

    @Override
    public Object convert(Object value, Object def) {
        return this.convert(value, null, def);
    }

    @Override
    public Object convert(Object value, Class target) {
        Object def = null;
        return this.convert(value, target, def);
    }

    @Override
    public Object convert(Object value, Class target, boolean array) {
        Object def = null;
        return this.convert(value, target, array, def);
    }

    @Override
    public Object convert(Object value, Class target, boolean array, Object def) {
        if (null == target) {
            target = this.compatible;
        }
        if (null != value) {
            if (value.getClass() == target) {
                return value;
            }
            if (null != this.transfer) {
                value = ConvertAdapter.convert(value, this.transfer, array, def);
            }
            value = ConvertAdapter.convert(value, target, array, def);
        }
        return value;
    }

    @Override
    public Object convert(Object value, Object obj, Field field) {
        return this.convert(value, field.getType());
    }

    @Override
    public Object read(Object value, Object def, Class clazz) {
        return this.read(value, def, clazz, false);
    }

    @Override
    public Object read(Object value, Object def, Class clazz, boolean array) {
        if (null == clazz) {
            clazz = this.transfer;
        }
        if (null == clazz) {
            clazz = this.compatible;
        }
        value = ConvertAdapter.convert(value, clazz, array, def);
        return value;
    }

    @Override
    public Object write(Object value, Object def, boolean placeholder) {
        return this.write(value, def, false, placeholder);
    }

    @Override
    public Object write(Object value, Object def, boolean array, boolean placeholder) {
        if (null != value && value.getClass() != this.compatible) {
            if (null != this.transfer) {
                value = ConvertAdapter.convert(value, this.transfer, array, def);
            }
            value = ConvertAdapter.convert(value, this.compatible, array, def);
        }
        if (null != value && !BasicUtil.isNumber(value)) {
            value = "'" + value + "'";
        }
        return value;
    }

    @Override
    public boolean isArray() {
        return this.array;
    }

    @Override
    public void setArray(boolean array) {
        this.array = array;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean ignorePrecision() {
        return this.ignorePrecision;
    }

    @Override
    public boolean ignoreScale() {
        return this.ignoreScale;
    }

    @Override
    public boolean support() {
        return true;
    }

    @Override
    public Class compatible() {
        return this.compatible;
    }

    @Override
    public Class transfer() {
        return this.transfer;
    }

    @Override
    public DatabaseType[] dbs() {
        return this.dbs;
    }
}

