/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.exception.AnylineException;
import org.anyline.metadata.BaseMetadata;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Constraint;
import org.anyline.metadata.Index;
import org.anyline.metadata.Partition;
import org.anyline.metadata.PrimaryKey;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Tag;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;

public class Table<E extends Table>
extends BaseMetadata<E>
implements Serializable {
    protected String keyword = "TABLE";
    protected String masterName;
    protected Table master;
    protected Partition partitionBy;
    protected Partition partitionFor;
    protected String type;
    protected Table inherits;
    protected int srid;
    protected String typeCat;
    protected String typeSchema;
    protected String typeName;
    protected String selfReferencingColumn;
    protected String refGeneration;
    protected String engine;
    protected String charset;
    protected String collate;
    protected Long ttl;
    protected Date createTime;
    protected Date updateTime;
    protected Long dataRows;
    protected Long dataLength;
    protected Long indexLength;
    protected PrimaryKey primaryKey;
    protected LinkedHashMap<String, Column> columns = new LinkedHashMap();
    protected LinkedHashMap<String, Tag> tags = new LinkedHashMap();
    protected LinkedHashMap<String, Index> indexs = new LinkedHashMap();
    protected LinkedHashMap<String, Constraint> constraints = new LinkedHashMap();
    protected boolean autoDropColumn = ConfigTable.IS_DDL_AUTO_DROP_COLUMN;

    public Table() {
    }

    public Table(String name) {
        this.name = name;
    }

    public Table(String schema, String table) {
        this(null, schema, table);
    }

    public Table(Schema schema, String table) {
        this(null, schema, table);
    }

    public Table(String catalog, String schema, String name) {
        this.catalog = new Catalog(catalog);
        this.schema = new Schema(schema);
        this.name = name;
    }

    public Table(Catalog catalog, Schema schema, String name) {
        this.catalog = catalog;
        this.schema = schema;
        this.name = name;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public Partition getPartitionFor() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).partitionFor;
        }
        return this.partitionFor;
    }

    public Partition getPartitionBy() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).partitionBy;
        }
        return this.partitionBy;
    }

    public Table partitionOf(Table master) {
        this.master = master;
        return this;
    }

    public Table partitionFor(Partition partition) {
        return this.setPartitionFor(partition);
    }

    public Table partitionFor(Partition.TYPE type, Object ... values) {
        Partition partition = new Partition();
        partition.setType(type);
        partition.addList(values);
        return this.setPartitionFor(partition);
    }

    public Table setPartitionFor(Partition partition) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setPartitionFor(partition);
            return this;
        }
        this.partitionFor = partition;
        return this;
    }

    public Table partitionBy(Partition partition) {
        return this.setPartitionBy(partition);
    }

    public Table partitionBy(Partition.TYPE type, String ... columns) {
        Partition partition = new Partition();
        partition.setType(type);
        partition.setColumns(columns);
        return this.setPartitionBy(partition);
    }

    public Table setPartitionBy(Partition partition) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setPartitionBy(partition);
            return this;
        }
        this.partitionBy = partition;
        return this;
    }

    public String getMasterName() {
        if (null == this.masterName && null != this.master) {
            this.masterName = this.master.getName();
        }
        return this.masterName;
    }

    public void setMasterName(String masterName) {
        this.masterName = masterName;
    }

    public void setMaster(String masterName) {
        this.masterName = masterName;
    }

    public Table getMaster() {
        if (null == this.master && null != this.masterName) {
            this.master = new Table<E>(this.masterName);
        }
        return this.master;
    }

    public void setPartitionOf(Table master) {
        this.master = master;
    }

    public void setMaster(Table master) {
        this.master = master;
    }

    public List<Column> primarys() {
        ArrayList<Column> pks = new ArrayList<Column>();
        for (Column column : this.columns.values()) {
            if (column.isPrimaryKey() != 1) continue;
            pks.add(column);
        }
        return pks;
    }

    public Column primary() {
        List<Column> pks = this.primarys();
        if (pks.isEmpty()) {
            return null;
        }
        return pks.get(0);
    }

    @Override
    public E clone() {
        Table copy = (Table)super.clone();
        LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
        for (Column column : this.columns.values()) {
            Column col = (Column)column.clone();
            cols.put(col.getName().toUpperCase(), col);
        }
        copy.columns = cols;
        return (E)copy;
    }

    public Table addColumn(Column column) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).addColumn(column);
            return this;
        }
        column.setTable(this);
        if (null == this.columns) {
            this.columns = new LinkedHashMap();
        }
        this.columns.put(column.getName().toUpperCase(), column);
        return this;
    }

    public Long getTtl() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).ttl;
        }
        return this.ttl;
    }

    public Table setTtl(Long ttl) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setTtl(ttl);
            return this;
        }
        this.ttl = ttl;
        return this;
    }

    public Column addColumn(String name, String type, int precision, int scale) {
        Column column = new Column(name, type, precision, scale);
        this.addColumn(column);
        return column;
    }

    public Column addColumn(String name, String type, int precision) {
        Column column = new Column(name, type, precision);
        this.addColumn(column);
        return column;
    }

    public Column addColumn(String name, String type) {
        return this.addColumn(name, type, true, null);
    }

    public Column addColumn(String name, String type, boolean nullable, Object def) {
        Column column = new Column();
        column.setName(name);
        column.nullable(nullable);
        column.setDefaultValue(def);
        column.setTypeName(type);
        this.addColumn(column);
        return column;
    }

    public Table setPrimaryKey(String ... keys) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setPrimaryKey(keys);
            return this;
        }
        if (null != this.primaryKey) {
            for (Column column : this.primaryKey.getColumns().values()) {
                column.primary(false);
            }
        }
        this.primaryKey = new PrimaryKey();
        this.primaryKey.setTable(this);
        if (null != this.columns) {
            for (String key : keys) {
                Column column = this.columns.get(key.toUpperCase());
                if (null == column) {
                    throw new AnylineException("\u672a\u5339\u914d\u5230" + key + ",\u8bf7\u8bdc\u6dfb\u52a0\u5230columns");
                }
                column.primary(true);
                this.primaryKey.addColumn(column);
            }
        } else {
            throw new AnylineException("\u8bf7\u5148\u8bbe\u7f6ecolumns");
        }
        return this;
    }

    public Table setPrimaryKey(PrimaryKey primaryKey) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setPrimaryKey(primaryKey);
            return this;
        }
        if (null != this.primaryKey) {
            for (Column column : this.primaryKey.getColumns().values()) {
                column.primary(false);
            }
        }
        this.primaryKey = primaryKey;
        if (null != primaryKey) {
            primaryKey.setTable(this);
        }
        return this;
    }

    public Table addTag(Tag tag) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).addTag(tag);
            return this;
        }
        tag.setTable(this);
        if (null == this.tags) {
            this.tags = new LinkedHashMap();
        }
        this.tags.put(tag.getName(), tag);
        return this;
    }

    public Tag addTag(String name, String type) {
        return this.addTag(name, type, true, null);
    }

    public Tag addTag(String name, String type, Object value) {
        Tag tag = new Tag(name, type, value);
        this.addTag(tag);
        return tag;
    }

    public Tag addTag(String name, String type, boolean nullable, Object def) {
        Tag tag = new Tag();
        tag.setName(name);
        tag.nullable(nullable);
        tag.setDefaultValue(def);
        tag.setTypeName(type);
        this.addTag(tag);
        return tag;
    }

    public String getName(boolean greedy) {
        Object result = "";
        if (greedy) {
            if (BasicUtil.isNotEmpty(this.catalog)) {
                result = this.catalog + ".";
            }
            if (BasicUtil.isNotEmpty(this.schema)) {
                result = (String)result + this.schema + ".";
            }
            result = (String)result + this.name;
        } else {
            result = this.name;
        }
        return result;
    }

    public String getType() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).type;
        }
        return this.type;
    }

    public Table setType(String type) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setType(type);
            return this;
        }
        this.type = type;
        return this;
    }

    public String getTypeCat() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).typeCat;
        }
        return this.typeCat;
    }

    public Table setTypeCat(String typeCat) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setTypeCat(typeCat);
            return this;
        }
        this.typeCat = typeCat;
        return this;
    }

    public String getTypeSchema() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).typeSchema;
        }
        return this.typeSchema;
    }

    public Table setTypeSchema(String typeSchema) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setTypeSchema(typeSchema);
            return this;
        }
        this.typeSchema = typeSchema;
        return this;
    }

    public String getTypeName() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).typeName;
        }
        return this.typeName;
    }

    public Table setTypeName(String typeName) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setTypeName(typeName);
            return this;
        }
        this.typeName = typeName;
        return this;
    }

    public String getSelfReferencingColumn() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).selfReferencingColumn;
        }
        return this.selfReferencingColumn;
    }

    public Table setSelfReferencingColumn(String selfReferencingColumn) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setSelfReferencingColumn(selfReferencingColumn);
            return this;
        }
        this.selfReferencingColumn = selfReferencingColumn;
        return this;
    }

    public String getRefGeneration() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).refGeneration;
        }
        return this.refGeneration;
    }

    public Table setRefGeneration(String refGeneration) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setRefGeneration(refGeneration);
            return this;
        }
        this.refGeneration = refGeneration;
        return this;
    }

    public List<Column> columns() {
        ArrayList<Column> list = new ArrayList<Column>();
        LinkedHashMap<String, Column> columns = this.getColumns();
        for (Column column : columns.values()) {
            list.add(column);
        }
        return list;
    }

    public LinkedHashMap<String, Column> getColumns() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).getColumns();
        }
        if (null == this.columns) {
            this.columns = new LinkedHashMap();
        }
        return this.columns;
    }

    public List<String> getColumns(boolean name) {
        LinkedHashMap<String, Column> columns = this.getColumns();
        ArrayList<String> names = new ArrayList<String>();
        if (null != columns) {
            for (Column column : columns.values()) {
                names.add(column.getName());
            }
        }
        return names;
    }

    public <T extends Column> Table setColumns(LinkedHashMap<String, T> columns) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setColumns(columns);
            return this;
        }
        this.columns = columns;
        if (null != columns) {
            for (Column column : columns.values()) {
                column.setTable(this);
            }
        }
        return this;
    }

    public List<Tag> tags() {
        ArrayList<Tag> list = new ArrayList<Tag>();
        LinkedHashMap<String, Tag> tags = this.getTags();
        for (Tag tag : tags.values()) {
            list.add(tag);
        }
        return list;
    }

    public LinkedHashMap<String, Tag> getTags() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).getTags();
        }
        if (null == this.tags) {
            this.tags = new LinkedHashMap();
        }
        return this.tags;
    }

    public Table setTags(LinkedHashMap<String, Tag> tags) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setTags(tags);
            return this;
        }
        this.tags = tags;
        if (null != tags) {
            for (Column column : tags.values()) {
                column.setTable(this);
            }
        }
        return this;
    }

    public Index getIndex(String name) {
        if (null != this.indexs && null != name) {
            return this.indexs.get(name.toUpperCase());
        }
        return null;
    }

    public <T extends Index> LinkedHashMap<String, T> getIndexs() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).getIndexs();
        }
        if (null == this.indexs) {
            this.indexs = new LinkedHashMap();
        }
        return this.indexs;
    }

    public PrimaryKey getPrimaryKey() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).getPrimaryKey();
        }
        if (null == this.primaryKey) {
            for (Column column : this.columns.values()) {
                if (column.isPrimaryKey() != 1) continue;
                if (null == this.primaryKey) {
                    this.primaryKey = new PrimaryKey();
                    this.primaryKey.setName(this.getName() + "_PK");
                    this.primaryKey.setTable(this);
                }
                this.primaryKey.addColumn(column);
            }
        }
        if (null == this.primaryKey) {
            for (Index index : this.indexs.values()) {
                if (!index.isPrimary()) continue;
                this.primaryKey = new PrimaryKey();
                this.primaryKey.setName(index.getName());
                this.primaryKey.setTable(this);
                this.primaryKey.setColumns(index.getColumns());
            }
        }
        return this.primaryKey;
    }

    public <T extends Index> Table setIndexs(LinkedHashMap<String, T> indexs) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setIndexs(indexs);
            return this;
        }
        this.indexs = indexs;
        return this;
    }

    public Table add(Index index) {
        if (null == this.indexs) {
            this.indexs = new LinkedHashMap();
        }
        index.setTable(this);
        this.indexs.put(index.getName().toUpperCase(), index);
        return this;
    }

    public Table add(Constraint constraint) {
        if (null == this.constraints) {
            this.constraints = new LinkedHashMap();
        }
        constraint.setTable(this);
        this.constraints.put(constraint.getName().toUpperCase(), constraint);
        return this;
    }

    public <T extends Constraint> LinkedHashMap<String, T> getConstraints() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).getConstraints();
        }
        if (null == this.constraints) {
            this.constraints = new LinkedHashMap();
        }
        return this.constraints;
    }

    public Table setConstraints(LinkedHashMap<String, Constraint> constraints) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setConstraints(constraints);
            return this;
        }
        this.constraints = constraints;
        return this;
    }

    public Column getColumn(String name) {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).getColumn(name);
        }
        if (null == this.columns || null == name) {
            return null;
        }
        return this.columns.get(name.toUpperCase());
    }

    public Column getTag(String name) {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).getTag(name);
        }
        return this.tags.get(name.toUpperCase());
    }

    public String getEngine() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).engine;
        }
        return this.engine;
    }

    public Table setEngine(String engine) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setEngine(engine);
            return this;
        }
        this.engine = engine;
        return this;
    }

    public String getCharset() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).charset;
        }
        return this.charset;
    }

    public Table setCharset(String charset) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setCharset(charset);
            return this;
        }
        this.charset = charset;
        return this;
    }

    public String getCollate() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).collate;
        }
        return this.collate;
    }

    public Table setCollate(String collate) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setCollate(collate);
            return this;
        }
        this.collate = collate;
        return this;
    }

    public int getSrid() {
        if (this.getmap && null != this.update) {
            return ((Table)this.update).srid;
        }
        return this.srid;
    }

    public Table setSrid(int srid) {
        if (this.setmap && null != this.update) {
            ((Table)this.update).setSrid(srid);
            return this;
        }
        this.srid = srid;
        return this;
    }

    public Table getInherits() {
        return this.inherits;
    }

    public void setInherits(Table inherits) {
        this.inherits = inherits;
    }

    public void setInherits(String inherits) {
        this.inherits = new Table<E>(inherits);
    }

    public String getKeyword() {
        return this.keyword;
    }

    public boolean isAutoDropColumn() {
        return this.autoDropColumn;
    }

    public void setAutoDropColumn(boolean autoDropColumn) {
        this.autoDropColumn = autoDropColumn;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public Long getDataRows() {
        return this.dataRows;
    }

    public void setDataRows(Long dataRows) {
        this.dataRows = dataRows;
    }

    public Long getDataLength() {
        return this.dataLength;
    }

    public void setDataLength(Long dataLength) {
        this.dataLength = dataLength;
    }

    public Long getIndexLength() {
        return this.indexLength;
    }

    public void setIndexLength(Long indexLength) {
        this.indexLength = indexLength;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.keyword).append(":");
        if (null != this.catalog && BasicUtil.isNotEmpty(this.catalog.getName())) {
            builder.append(this.catalog.getName()).append(".");
        }
        if (null != this.schema && BasicUtil.isNotEmpty(this.schema.getName())) {
            builder.append(this.schema.getName()).append(".");
        }
        builder.append(this.name);
        return builder.toString();
    }
}

