/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata;

public class Sequence {
    private String name;
    private boolean next = true;
    private int start = 0;
    private int increment = 1;
    private int cache = 100;
    private int min = 0;
    private boolean fetchValueBeforeInsert = false;

    public Sequence() {
    }

    public Sequence(String name) {
        this.setName(name);
    }

    public Sequence(String name, boolean next) {
        this.name = name;
        this.next = next;
    }

    public String getName() {
        return this.name;
    }

    public String sql() {
        if (this.next) {
            return this.name + ".NEXTVAL";
        }
        return this.name + ".CURRVAL";
    }

    public void setName(String name) {
        if (name.contains(".")) {
            String[] tmps = name.split("\\.");
            name = tmps[0];
            this.next = tmps[1].toUpperCase().contains("NEXT");
        }
        this.name = name;
    }

    public boolean isNext() {
        return this.next;
    }

    public void setNext(boolean next) {
        this.next = next;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int increment) {
        this.increment = increment;
    }

    public int getCache() {
        return this.cache;
    }

    public void setCache(int cache) {
        this.cache = cache;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public boolean isFetchValueBeforeInsert() {
        return this.fetchValueBeforeInsert;
    }

    public void setFetchValueBeforeInsert(boolean fetchValueBeforeInsert) {
        this.fetchValueBeforeInsert = fetchValueBeforeInsert;
    }
}

