/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.anyline.metadata.Column;

public class Partition
implements Serializable {
    private Object from;
    private Object to;
    private List<Object> list;
    private int modulus;
    private int remainder;
    private TYPE type;
    private LinkedHashMap<String, Column> columns;

    public Partition() {
    }

    public Partition(TYPE type) {
        this.type = type;
    }

    public Partition(TYPE type, String ... columns) {
        this.type = type;
        this.columns = new LinkedHashMap();
        for (String column : columns) {
            this.columns.put(column.toUpperCase(), new Column(column));
        }
    }

    public TYPE getType() {
        return this.type;
    }

    public Partition setType(TYPE type) {
        this.type = type;
        return this;
    }

    public LinkedHashMap<String, Column> getColumns() {
        return this.columns;
    }

    public Partition setColumns(LinkedHashMap<String, Column> columns) {
        this.columns = columns;
        return this;
    }

    public Partition setColumns(String ... columns) {
        this.columns = new LinkedHashMap();
        for (String column : columns) {
            this.columns.put(column.toUpperCase(), new Column(column));
        }
        return this;
    }

    public Partition addColumn(Column column) {
        if (null == this.columns) {
            this.columns = new LinkedHashMap();
        }
        this.columns.put(column.getName().toUpperCase(), column);
        return this;
    }

    public Partition addColumn(String column) {
        return this.addColumn(new Column(column));
    }

    public Partition setRange(Object from, Object to) {
        this.from = from;
        this.to = to;
        return this;
    }

    public Object getFrom() {
        return this.from;
    }

    public Partition setFrom(Object from) {
        this.from = from;
        return this;
    }

    public Object getTo() {
        return this.to;
    }

    public Partition setTo(Object to) {
        this.to = to;
        return this;
    }

    public List<Object> getList() {
        return this.list;
    }

    public Partition setList(List<Object> list) {
        this.list = list;
        return this;
    }

    public Partition addList(Object ... items) {
        if (null == this.list) {
            this.list = new ArrayList<Object>();
        }
        for (Object item : items) {
            if (item instanceof Collection) {
                Collection cons = (Collection)item;
                for (Object con : cons) {
                    this.addList(con);
                }
                continue;
            }
            if (item instanceof Object[]) {
                Object[] objs;
                for (Object obj : objs = (Object[])item) {
                    this.addList(obj);
                }
                continue;
            }
            this.list.add(item);
        }
        return this;
    }

    public int getModulus() {
        return this.modulus;
    }

    public Partition setModulus(int modulus) {
        this.modulus = modulus;
        return this;
    }

    public Partition setHash(int modulus, int remainder) {
        this.modulus = modulus;
        this.remainder = remainder;
        return this;
    }

    public int getRemainder() {
        return this.remainder;
    }

    public Partition setRemainder(int remainder) {
        this.remainder = remainder;
        return this;
    }

    public static enum TYPE {
        LIST,
        RANGE,
        HASH;

    }
}

