/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata;

import java.io.Serializable;
import java.util.LinkedHashMap;
import org.anyline.metadata.BaseMetadata;
import org.anyline.metadata.Column;
import org.anyline.metadata.Table;
import org.anyline.util.BasicUtil;

public class Constraint<E extends Constraint>
extends BaseMetadata<E>
implements Serializable {
    protected TYPE type;
    protected LinkedHashMap<String, Column> columns = new LinkedHashMap();

    public Constraint() {
    }

    public Constraint(String name) {
        this.setName(name);
    }

    public Constraint(Table table, String name) {
        this.setTable(table);
        this.setName(name);
    }

    public Constraint(Table table, String name, String type) {
        this.setTable(table);
        this.setName(name);
        this.setType(type);
    }

    @Override
    public String getName() {
        if (BasicUtil.isEmpty((Object)this.name)) {
            this.name = "index";
            for (String column : this.columns.keySet()) {
                this.name = this.name + "_" + column;
            }
        }
        return this.name;
    }

    @Override
    public String getTableName(boolean update) {
        Table table = this.getTable(update);
        if (null != table) {
            return table.getName();
        }
        return null;
    }

    @Override
    public Table getTable(boolean update) {
        if (update && null != this.table && null != this.table.getUpdate()) {
            return (Table)this.table.getUpdate();
        }
        return this.table;
    }

    public boolean isUnique() {
        if (this.getmap && null != this.update) {
            return ((Constraint)this.update).isUnique();
        }
        return this.type == TYPE.UNIQUE || this.type == TYPE.PRIMARY_KEY;
    }

    public TYPE getType() {
        if (this.getmap && null != this.update) {
            return ((Constraint)this.update).type;
        }
        return this.type;
    }

    public E setType(TYPE type) {
        this.type = type;
        return (E)this;
    }

    public E setType(String type) {
        if (null != type) {
            if ((type = type.toUpperCase()).contains("PRIMARY")) {
                this.type = TYPE.PRIMARY_KEY;
            } else if (type.contains("FOREIGN")) {
                this.type = TYPE.FOREIGN_KEY;
            } else if (type.contains("UNIQUE")) {
                this.type = TYPE.UNIQUE;
            } else if (type.contains("NOT")) {
                this.type = TYPE.NOT_NULL;
            }
        }
        return (E)this;
    }

    public LinkedHashMap<String, Column> getColumns() {
        if (this.getmap && null != this.update) {
            return ((Constraint)this.update).columns;
        }
        return this.columns;
    }

    public Column getColumn(String name) {
        if (this.getmap && null != this.update) {
            return ((Constraint)this.update).getColumn(name);
        }
        if (null != this.columns && null != name) {
            return this.columns.get(name.toUpperCase());
        }
        return null;
    }

    public E setColumns(LinkedHashMap<String, Column> columns) {
        this.columns = columns;
        return (E)this;
    }

    public E addColumn(Column column) {
        if (null == this.columns) {
            this.columns = new LinkedHashMap();
        }
        this.columns.put(column.getName().toUpperCase(), column);
        return (E)this;
    }

    public E addColumn(String column) {
        return this.addColumn(new Column(column));
    }

    public E addColumn(String column, String order) {
        return this.addColumn(new Column(column).setOrder(order));
    }

    public E addColumn(String column, String order, int position) {
        return this.addColumn(new Column(column).setOrder(order).setPosition(position));
    }

    @Override
    public E clone() {
        Constraint copy = (Constraint)super.clone();
        LinkedHashMap<String, Column> cols = new LinkedHashMap<String, Column>();
        for (Column column : this.columns.values()) {
            Column col = (Column)column.clone();
            cols.put(col.getName().toUpperCase(), col);
        }
        copy.columns = cols;
        return (E)copy;
    }

    public static enum TYPE {
        PRIMARY_KEY,
        UNIQUE,
        NOT_NULL,
        FOREIGN_KEY,
        DEFAULT;

    }
}

