/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.anyline.metadata.BaseMetadata;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.metadata.type.ColumnType;
import org.anyline.metadata.type.JavaType;
import org.anyline.util.BasicUtil;

public class Column
extends BaseMetadata<Column>
implements Serializable {
    protected String keyword = "COLUMN";
    protected String originalName;
    protected String className;
    protected Integer displaySize;
    protected Integer type;
    protected String typeName;
    protected ColumnType columnType;
    protected String childTypeName;
    protected ColumnType childColumnType;
    protected JavaType javaType;
    protected String jdbcType;
    protected Integer precision;
    protected Integer scale;
    protected String dateScale;
    protected int nullable = -1;
    protected int caseSensitive = -1;
    protected int currency = -1;
    protected int signed = -1;
    protected int autoIncrement = -1;
    protected Integer incrementSeed = 1;
    protected Integer incrementStep = 1;
    protected int primary = -1;
    protected int generated = -1;
    protected Object defaultValue;
    protected String charset;
    protected String collate;
    protected int withTimeZone = -1;
    protected int withLocalTimeZone = -1;
    protected Column reference;
    protected Integer srid;
    protected boolean array;
    protected Boolean index;
    protected Boolean store;
    protected String analyzer;
    protected String searchAnalyzer;
    protected Integer ignoreAbove;
    protected Integer position;
    protected String order;
    protected String after;
    protected String before;
    protected int onUpdate = -1;
    protected Object value;

    public static <T extends Column> void sort(Map<String, T> columns) {
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(columns.values());
        Column.sort(list);
        columns.clear();
        for (Column column : list) {
            columns.put(column.getName().toUpperCase(), column);
        }
    }

    public static <T extends Column> void sort(List<T> columns) {
        Collections.sort(columns, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                Integer p2;
                Integer p1 = ((Column)o1).getPosition();
                if (p1 == (p2 = ((Column)o2).getPosition())) {
                    return 0;
                }
                if (null == p1) {
                    return -1;
                }
                if (null == p2) {
                    return 1;
                }
                return p1 > p2 ? 1 : -1;
            }
        });
    }

    public Column() {
    }

    public Column(Table table, String name, String type) {
        this.setTable(table);
        this.setName(name);
        this.setType(type);
    }

    public Column(String name) {
        this.setName(name);
    }

    public Column(Schema schema, String table, String name) {
        this(null, schema, table, name);
    }

    public Column(Catalog catalog, Schema schema, String table, String name) {
        this.setCatalog(catalog);
        this.setSchema(schema);
        this.setName(name);
        this.setTable(table);
    }

    public Column(String name, String type, int precision, int scale) {
        this.name = name;
        this.setType(type);
        this.precision = precision;
        this.scale = scale;
    }

    public Column(String name, String type, int precision) {
        this.name = name;
        this.setType(type);
        this.precision = precision;
    }

    public Column(Table table, String name, String type, int precision, int scale) {
        this.setTable(table);
        this.name = name;
        this.setType(type);
        this.precision = precision;
        this.scale = scale;
    }

    public Column(Table table, String name, String type, int precision) {
        this.setTable(table);
        this.name = name;
        this.setType(type);
        this.precision = precision;
    }

    public Column(String name, String type) {
        this.name = name;
        this.setType(type);
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public boolean isArray() {
        return this.array;
    }

    public Column setArray(boolean array) {
        this.array = array;
        return this;
    }

    public String getDateScale() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getDateScale();
        }
        return this.dateScale;
    }

    public int getWithTimeZone() {
        return this.withTimeZone;
    }

    public void setWithTimeZone(int withTimeZone) {
        this.withTimeZone = withTimeZone;
    }

    public int getWithLocalTimeZone() {
        return this.withLocalTimeZone;
    }

    public void setWithLocalTimeZone(int withLocalTimeZone) {
        this.withLocalTimeZone = withLocalTimeZone;
    }

    public Column setDateScale(String dateScale) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setDateScale(dateScale);
            return this;
        }
        this.dateScale = dateScale;
        return this;
    }

    public String getClassName() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getClassName();
        }
        return this.className;
    }

    public Column setClassName(String className) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setClassName(className);
            return this;
        }
        this.className = className;
        return this;
    }

    public String getChildTypeName() {
        if (this.getmap && null != this.childTypeName) {
            return ((Column)this.update).getChildTypeName();
        }
        return this.childTypeName;
    }

    public Column setChildTypeName(String childTypeName) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setChildTypeName(childTypeName);
            return this;
        }
        this.childTypeName = childTypeName;
        return this;
    }

    public ColumnType getChildColumnType() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).childColumnType;
        }
        if (this.array && null != this.childColumnType) {
            this.childColumnType.setArray(this.array);
        }
        return this.childColumnType;
    }

    public Column setChildColumnType(ColumnType childColumnType) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setChildColumnType(childColumnType);
            return this;
        }
        this.childColumnType = childColumnType;
        return this;
    }

    public Integer getDisplaySize() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getDisplaySize();
        }
        return this.displaySize;
    }

    public Column setDisplaySize(Integer displaySize) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setDisplaySize(displaySize);
            return this;
        }
        this.displaySize = displaySize;
        return this;
    }

    public Integer getType() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).type;
        }
        return this.type;
    }

    public Column setType(Integer type) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setType(type);
            return this;
        }
        if (this.type != type) {
            this.className = null;
        }
        this.type = type;
        return this;
    }

    public Column setType(String type) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setType(type);
            return this;
        }
        return this.setTypeName(type);
    }

    public String getTypeName() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).typeName;
        }
        return this.typeName;
    }

    public String getJdbcType() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).jdbcType;
        }
        return this.jdbcType;
    }

    public Column setJdbcType(String jdbcType) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setJdbcType(jdbcType);
            return this;
        }
        this.jdbcType = jdbcType;
        return this;
    }

    public Column setTypeName(String typeName) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setTypeName(typeName);
            return this;
        }
        if (null != typeName) {
            if (typeName.contains("[]")) {
                this.setArray(true);
            }
            if (typeName.startsWith("_")) {
                typeName = typeName.substring(1);
                this.setArray(true);
            }
            if ((typeName = typeName.trim().replace("'", "")).toUpperCase().contains("IDENTITY")) {
                this.autoIncrement(true);
                if (typeName.contains(" ")) {
                    typeName = typeName.split(" ")[0];
                }
            }
            if (typeName.contains("(")) {
                this.precision = 0;
                this.scale = 0;
                String tmp = typeName.substring(typeName.indexOf("(") + 1, typeName.indexOf(")"));
                if (tmp.contains(",")) {
                    String[] lens = tmp.split("\\,");
                    if (BasicUtil.isNumber(lens[0])) {
                        this.setPrecision(BasicUtil.parseInt(lens[0], null));
                        this.setScale(BasicUtil.parseInt(lens[1], null));
                    } else {
                        this.setChildTypeName(lens[0]);
                        this.setSrid(BasicUtil.parseInt(lens[1], null));
                    }
                } else if (BasicUtil.isNumber(tmp)) {
                    this.setPrecision(BasicUtil.parseInt(tmp, null));
                } else {
                    this.setChildTypeName(tmp);
                }
                typeName = typeName.substring(0, typeName.indexOf("("));
            }
        }
        if (!BasicUtil.equalsIgnoreCase(typeName, this.typeName)) {
            this.className = null;
        }
        this.typeName = typeName;
        return this;
    }

    public Integer getPrecision() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getPrecision();
        }
        return this.precision;
    }

    public Column setPrecision(Integer precision) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setPrecision(precision);
            return this;
        }
        this.precision = precision;
        return this;
    }

    public Column setPrecision(Integer precision, Integer scale) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setPrecision(precision, scale);
            return this;
        }
        this.precision = precision;
        this.scale = scale;
        return this;
    }

    public Object getValue() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).value;
        }
        return this.value;
    }

    public Column setValue(Object value) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setValue(value);
            return this;
        }
        this.value = value;
        return this;
    }

    public int isCaseSensitive() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).caseSensitive;
        }
        return this.caseSensitive;
    }

    public Column setCaseSensitive(int caseSensitive) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setCaseSensitive(caseSensitive);
            return this;
        }
        this.caseSensitive = caseSensitive;
        return this;
    }

    public Column caseSensitive(int caseSensitive) {
        return this.setCaseSensitive(caseSensitive);
    }

    public Column caseSensitive(Boolean caseSensitive) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).caseSensitive(caseSensitive);
            return this;
        }
        if (null != caseSensitive) {
            this.caseSensitive = caseSensitive != false ? 1 : 0;
        }
        return this;
    }

    public int isCurrency() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).currency;
        }
        return this.currency;
    }

    public Column setCurrency(int currency) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setCurrency(currency);
            return this;
        }
        this.currency = currency;
        return this;
    }

    public Column currency(int currency) {
        return this.setCurrency(currency);
    }

    public Column setCurrency(Boolean currency) {
        return this.currency(currency);
    }

    public Column currency(Boolean currency) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).currency(currency);
            return this;
        }
        if (null != currency) {
            this.currency = currency != false ? 1 : 0;
        }
        return this;
    }

    public int isSigned() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).signed;
        }
        return this.signed;
    }

    public Column setSigned(int signed) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setSigned(signed);
            return this;
        }
        this.signed = signed;
        return this;
    }

    public Column signed(int signed) {
        return this.setSigned(signed);
    }

    public Column setSigned(Boolean signed) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setSigned(signed);
            return this;
        }
        if (null != signed) {
            this.signed = signed != false ? 1 : 0;
        }
        return this;
    }

    public Integer getScale() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getScale();
        }
        return this.scale;
    }

    public Column setScale(Integer scale) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setScale(scale);
            return this;
        }
        this.scale = scale;
        return this;
    }

    public int isNullable() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).nullable;
        }
        return this.nullable;
    }

    public Column setNullable(int nullable) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setNullable(nullable);
            return this;
        }
        this.nullable = nullable;
        return this;
    }

    public Column nullable(int nullable) {
        return this.setNullable(nullable);
    }

    public Column setNullable(Boolean nullable) {
        return this.nullable(nullable);
    }

    public Column nullable(Boolean nullable) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).nullable(nullable);
            return this;
        }
        if (null != nullable) {
            this.nullable = nullable != false ? 1 : 0;
        }
        return this;
    }

    public int isAutoIncrement() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).autoIncrement;
        }
        return this.autoIncrement;
    }

    public Column setAutoIncrement(int autoIncrement) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setAutoIncrement(autoIncrement);
            return this;
        }
        this.autoIncrement = autoIncrement;
        if (autoIncrement == 1) {
            this.nullable(false);
        }
        return this;
    }

    public Column autoIncrement(int autoIncrement) {
        return this.setAutoIncrement(autoIncrement);
    }

    public Column setAutoIncrement(Boolean autoIncrement) {
        return this.autoIncrement(autoIncrement);
    }

    public Column autoIncrement(Boolean autoIncrement) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).autoIncrement(autoIncrement);
            return this;
        }
        if (null != autoIncrement) {
            if (autoIncrement.booleanValue()) {
                this.autoIncrement = 1;
                this.primary = 1;
                this.nullable(false);
            } else {
                this.autoIncrement = 0;
            }
        }
        return this;
    }

    public Column setAutoIncrement(int seed, int step) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setAutoIncrement(seed, step);
            return this;
        }
        this.setAutoIncrement(1);
        this.incrementSeed = seed;
        this.incrementStep = step;
        return this;
    }

    public int isPrimaryKey() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).primary;
        }
        return this.primary;
    }

    public Column setPrimary(int primary) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setPrimary(primary);
            return this;
        }
        this.primary = primary;
        return this;
    }

    public Column primary(int primary) {
        return this.setPrimary(primary);
    }

    public Column setPrimary(Boolean primary) {
        return this.primary(primary);
    }

    public Column setPrimaryKey(Boolean primary) {
        return this.primary(primary);
    }

    public Column primary(Boolean primary) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).primary(primary);
            return this;
        }
        if (null != primary) {
            if (primary.booleanValue()) {
                this.primary = 1;
                this.nullable(false);
            } else {
                this.primary = 0;
            }
        }
        return this;
    }

    public int isGenerated() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).generated;
        }
        return this.generated;
    }

    public Column setGenerated(int generated) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setGenerated(generated);
            return this;
        }
        this.generated = generated;
        return this;
    }

    public Column generated(int generated) {
        return this.setGenerated(generated);
    }

    public Column setGenerated(Boolean generated) {
        return this.generated(generated);
    }

    public Column generated(Boolean generated) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).generated(generated);
            return this;
        }
        if (null != generated) {
            this.generated = generated != false ? 1 : 0;
        }
        return this;
    }

    public Object getDefaultValue() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).defaultValue;
        }
        return this.defaultValue;
    }

    public Column setDefaultValue(Object defaultValue) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setDefaultValue(defaultValue);
            return this;
        }
        this.defaultValue = defaultValue;
        return this;
    }

    public Integer getPosition() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).position;
        }
        return this.position;
    }

    public String getOrder() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).order;
        }
        return this.order;
    }

    public Column setOrder(String order) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setOrder(order);
            return this;
        }
        this.order = order;
        return this;
    }

    public Column setPosition(Integer position) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setPosition(position);
            return this;
        }
        this.position = position;
        return this;
    }

    public String getAfter() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).after;
        }
        return this.after;
    }

    public Integer getIncrementSeed() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).incrementSeed;
        }
        return this.incrementSeed;
    }

    public Column setIncrementSeed(Integer incrementSeed) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setIncrementSeed(incrementSeed);
            return this;
        }
        this.incrementSeed = incrementSeed;
        return this;
    }

    public Integer getIncrementStep() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).incrementStep;
        }
        return this.incrementStep;
    }

    public Column setIncrementStep(Integer incrementStep) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setIncrementStep(incrementStep);
            return this;
        }
        this.incrementStep = incrementStep;
        return this;
    }

    public int isOnUpdate() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).onUpdate;
        }
        return this.onUpdate;
    }

    public Column setOnUpdate(int onUpdate) {
        this.onUpdate = onUpdate;
        return this;
    }

    public Column onUpdate(int onUpdate) {
        return this.setOnUpdate(onUpdate);
    }

    public Column setOnUpdate(boolean onUpdate) {
        return this.onUpdate(onUpdate);
    }

    public Column onUpdate(boolean onUpdate) {
        this.onUpdate = onUpdate ? 1 : -1;
        return this;
    }

    public Column setAfter(String after) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setAfter(after);
            return this;
        }
        this.after = after;
        return this;
    }

    public String getOriginalName() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).originalName;
        }
        return this.originalName;
    }

    public Column setOriginalName(String originalName) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setOriginalName(originalName);
            return this;
        }
        this.originalName = originalName;
        return this;
    }

    public String getBefore() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).before;
        }
        return this.before;
    }

    public String getCharset() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).charset;
        }
        return this.charset;
    }

    public Column setCharset(String charset) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setCharset(charset);
            return this;
        }
        this.charset = charset;
        return this;
    }

    public String getCollate() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).collate;
        }
        return this.collate;
    }

    public Column setCollate(String collate) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setCollate(collate);
            return this;
        }
        this.collate = collate;
        return this;
    }

    public Column setBefore(String before) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setBefore(before);
            return this;
        }
        this.before = before;
        return this;
    }

    public String getFullType() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getFullType();
        }
        return this.getFullType(this.typeName);
    }

    public String getFullType(String typeName) {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getFullType(typeName);
        }
        return this.getFullType(typeName, this.ignorePrecision());
    }

    public String getFullType(String typeName, boolean ignorePrecision) {
        String child;
        if (this.getmap && null != this.update) {
            return ((Column)this.update).getFullType(typeName, ignorePrecision);
        }
        StringBuilder builder = new StringBuilder();
        builder.append(typeName);
        if (!ignorePrecision && null != this.precision) {
            if (this.precision > 0) {
                builder.append("(").append(this.precision);
                if (null != this.scale && this.scale > 0) {
                    builder.append(",").append(this.scale);
                }
                builder.append(")");
            } else if (this.precision == -1) {
                builder.append("(max)");
            }
        }
        if (null != (child = this.getChildTypeName())) {
            builder.append("(");
            builder.append(child);
            if (null != this.srid) {
                builder.append(",");
                builder.append(this.srid);
            }
            builder.append(")");
        }
        return builder.toString();
    }

    public boolean equals(Column column) {
        if (null == column) {
            return false;
        }
        if (!BasicUtil.equals(this.typeName, column.getTypeName())) {
            return false;
        }
        if (!BasicUtil.equals(this.precision, column.getPrecision())) {
            return false;
        }
        if (!BasicUtil.equals(this.scale, column.getScale())) {
            return false;
        }
        if (!BasicUtil.equals(this.defaultValue, column.getDefaultValue())) {
            return false;
        }
        if (!BasicUtil.equals(this.comment, column.getComment())) {
            return false;
        }
        if (!BasicUtil.equals(this.nullable, column.isNullable())) {
            return false;
        }
        if (!BasicUtil.equals(this.autoIncrement, column.isAutoIncrement())) {
            return false;
        }
        if (!BasicUtil.equals(this.charset, column.getCharset())) {
            return false;
        }
        return BasicUtil.equals(this.primary, column.isPrimaryKey());
    }

    public ColumnType getColumnType() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).columnType;
        }
        if (this.array && null != this.columnType) {
            this.columnType.setArray(this.array);
        }
        return this.columnType;
    }

    public String getAnalyzer() {
        return this.analyzer;
    }

    public Column setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    public String getSearchAnalyzer() {
        return this.searchAnalyzer;
    }

    public Column setSearchAnalyzer(String searchAnalyzer) {
        this.searchAnalyzer = searchAnalyzer;
        return this;
    }

    public Integer getIgnoreAbove() {
        return this.ignoreAbove;
    }

    public Column setIgnoreAbove(Integer ignoreAbove) {
        this.ignoreAbove = ignoreAbove;
        return this;
    }

    public Column setColumnType(ColumnType columnType) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setColumnType(columnType);
            return this;
        }
        this.columnType = columnType;
        return this;
    }

    public JavaType getJavaType() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).javaType;
        }
        return this.javaType;
    }

    public Column setJavaType(JavaType javaType) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setJavaType(javaType);
            return this;
        }
        this.javaType = javaType;
        return this;
    }

    public Integer getSrid() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).srid;
        }
        return this.srid;
    }

    public Column setSrid(Integer srid) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setSrid(srid);
            return this;
        }
        this.srid = srid;
        return this;
    }

    public Column getReference() {
        if (this.getmap && null != this.update) {
            return ((Column)this.update).reference;
        }
        return this.reference;
    }

    public Column setReference(Column reference) {
        if (this.setmap && null != this.update) {
            ((Column)this.update).setReference(reference);
            return this;
        }
        this.reference = reference;
        return this;
    }

    public Boolean getIndex() {
        return this.index;
    }

    public Column setIndex(Boolean index) {
        this.index = index;
        return this;
    }

    public Boolean getStore() {
        return this.store;
    }

    public Column setStore(Boolean store) {
        this.store = store;
        return this;
    }

    public boolean ignorePrecision() {
        if (null != this.typeName) {
            String chk = this.typeName.toLowerCase();
            if (chk.contains("date")) {
                return true;
            }
            if (chk.contains("time")) {
                return true;
            }
            if (chk.contains("year")) {
                return true;
            }
            if (chk.contains("text")) {
                return true;
            }
            if (chk.contains("blob")) {
                return true;
            }
            if (chk.contains("json")) {
                return true;
            }
            if (chk.contains("point")) {
                return true;
            }
            if (chk.contains("line")) {
                return true;
            }
            if (chk.contains("polygon")) {
                return true;
            }
            if (chk.contains("geometry")) {
                return true;
            }
            if (chk.contains("geography")) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name).append(" ");
        builder.append(this.getFullType());
        if (BasicUtil.isNotEmpty(this.defaultValue)) {
            builder.append(" default ").append(this.defaultValue);
        }
        return builder.toString();
    }

    public String getKeyword() {
        return this.keyword;
    }
}

