/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity.geometry;

import java.util.ArrayList;
import java.util.List;
import org.anyline.entity.geometry.Geometry;
import org.anyline.entity.geometry.Ring;

public class Polygon
extends Geometry {
    private List<Ring> rings = new ArrayList<Ring>();

    public Polygon add(Ring ring) {
        this.rings.add(ring);
        return this;
    }

    public List<Ring> rings() {
        return this.rings;
    }

    public Polygon() {
        this.type = 3;
    }

    public Polygon(List<Ring> rings) {
        this();
        this.rings = rings;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean tag) {
        StringBuilder builder = new StringBuilder();
        if (tag) {
            builder.append(this.tag());
        }
        builder.append("(");
        boolean first = true;
        for (Ring ring : this.rings) {
            if (!ring.clockwise().booleanValue()) continue;
            if (!first) {
                builder.append(", ");
            }
            builder.append(ring.toString(false));
            first = false;
        }
        for (Ring ring : this.rings) {
            if (ring.clockwise().booleanValue()) continue;
            if (!first) {
                builder.append(", ");
            }
            builder.append(ring.toString(false));
            first = false;
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public String sql(boolean tag, boolean bracket) {
        StringBuilder builder = new StringBuilder();
        if (tag) {
            builder.append(this.tag());
        }
        if (bracket) {
            builder.append("(");
        }
        boolean first = true;
        for (Ring ring : this.rings) {
            if (!ring.clockwise().booleanValue()) continue;
            if (!first) {
                builder.append(", ");
            }
            builder.append(ring.sql(false, true));
            first = false;
        }
        for (Ring ring : this.rings) {
            if (ring.clockwise().booleanValue()) continue;
            if (!first) {
                builder.append(", ");
            }
            builder.append(ring.sql(false, true));
            first = false;
        }
        if (bracket) {
            builder.append(")");
        }
        return builder.toString();
    }

    @Override
    public String sql() {
        return this.sql(true, true);
    }

    public List<Ring> getRings() {
        return this.rings;
    }
}

