/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity.geometry;

import java.util.ArrayList;
import java.util.List;
import org.anyline.entity.geometry.Geometry;
import org.anyline.entity.geometry.Point;

public class LineString
extends Geometry {
    private List<Point> points = new ArrayList<Point>();

    public LineString add(Point point) {
        this.points.add(point);
        return this;
    }

    public LineString add(double x, double y) {
        return this.add(new Point(x, y));
    }

    public LineString add(int x, int y) {
        return this.add(new Point(x, y));
    }

    public List<Point> points() {
        return this.points;
    }

    public LineString() {
        this.type = 2;
    }

    public LineString(List<Point> points) {
        this();
        this.points = points;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean tag) {
        StringBuilder builder = new StringBuilder();
        if (tag) {
            builder.append(this.tag());
        }
        builder.append("(");
        boolean first = true;
        for (Point point : this.points) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(point.toString(false));
            first = false;
        }
        builder.append(")");
        return builder.toString();
    }

    @Override
    public String sql(boolean tag, boolean bracket) {
        StringBuilder builder = new StringBuilder();
        if (tag) {
            builder.append(this.tag());
        }
        if (bracket) {
            builder.append("(");
        }
        boolean first = true;
        for (Point point : this.points) {
            if (!first) {
                builder.append(", ");
            }
            builder.append(point.sql(false, false));
            first = false;
        }
        if (bracket) {
            builder.append(")");
        }
        return builder.toString();
    }

    @Override
    public String sql() {
        return this.sql(true, true);
    }

    public List<Point> getPoints() {
        return this.points;
    }
}

