/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity;

import org.anyline.entity.Order;
import org.anyline.util.BasicUtil;

public class DefaultOrder
implements Order {
    private static final long serialVersionUID = -765229283714551699L;
    private String column;
    private Order.TYPE type = Order.TYPE.ASC;

    public DefaultOrder() {
    }

    public DefaultOrder(String str) {
        if (BasicUtil.isEmpty((Object)str)) {
            return;
        }
        str = str.trim();
        String typ = "ASC";
        String up = str.toUpperCase();
        if (up.endsWith(" ASC")) {
            this.column = str.substring(0, str.length() - 4);
            typ = "ASC";
        } else if (up.endsWith(" DESC")) {
            this.column = str.substring(0, str.length() - 5);
            typ = "DESC";
        } else {
            this.column = str;
            typ = "ASC";
        }
        this.type = typ.equalsIgnoreCase("ASC") ? Order.TYPE.ASC : Order.TYPE.DESC;
    }

    public DefaultOrder(String column, Order.TYPE type) {
        this.setColumn(column);
        this.setType(type);
    }

    public DefaultOrder(String column, String type) {
        this.setColumn(column);
        this.setType(type);
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    @Override
    public void setColumn(String column) {
        if (null != column) {
            this.column = column.trim();
        }
    }

    @Override
    public Order.TYPE getType() {
        return this.type;
    }

    @Override
    public void setType(Order.TYPE type) {
        this.type = type;
    }

    public Object clone() throws CloneNotSupportedException {
        DefaultOrder clone = (DefaultOrder)super.clone();
        return clone;
    }

    @Override
    public void setType(String type) {
        this.type = "DESC".equalsIgnoreCase(type) ? Order.TYPE.DESC : Order.TYPE.ASC;
    }
}

