/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.entity;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum Compare {
    NONE(-1, null, null, null){

        @Override
        public boolean compare(Object value, Object target) {
            return false;
        }

        @Override
        public boolean isMultipleValue() {
            return false;
        }
    }
    ,
    AUTO(0, null, null, null){

        @Override
        public boolean compare(Object value, Object target) {
            return false;
        }

        @Override
        public boolean isMultipleValue() {
            return false;
        }
    }
    ,
    EQUAL(10, "\u7b49\u4e8e", "eq", " = ? "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target) {
                return null == value;
            }
            return target.toString().equalsIgnoreCase(value.toString());
        }

        @Override
        public boolean isMultipleValue() {
            return false;
        }
    }
    ,
    GREAT(20, "\u5927\u4e8e", "gt", " > ? "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            try {
                return new BigDecimal(value.toString()).compareTo(new BigDecimal(target.toString())) > 0;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public boolean isMultipleValue() {
            return false;
        }
    }
    ,
    GREAT_EQUAL(21, "\u5927\u4e8e\u7b49\u4e8e", "gte", " >= ? "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            return new BigDecimal(value.toString()).compareTo(new BigDecimal(target.toString())) >= 0;
        }

        @Override
        public boolean isMultipleValue() {
            return false;
        }
    }
    ,
    LESS(30, "\u5c0f\u4e8e", "lt", " < ? "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            try {
                return new BigDecimal(value.toString()).compareTo(new BigDecimal(target.toString())) < 0;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public boolean isMultipleValue() {
            return false;
        }
    }
    ,
    LESS_EQUAL(31, "\u5c0f\u4e8e\u7b49\u4e8e", "lte", " <= ? "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            try {
                return new BigDecimal(value.toString()).compareTo(new BigDecimal(target.toString())) <= 0;
            }
            catch (Exception e) {
                return false;
            }
        }

        @Override
        public boolean isMultipleValue() {
            return false;
        }
    }
    ,
    IN(40, "in", "in", " IN "){

        @Override
        public boolean compare(Object value, Object targets) {
            if (null != targets && targets instanceof Collection) {
                Collection cols = (Collection)targets;
                for (Object v : cols) {
                    if (null == v || !v.toString().equalsIgnoreCase(value.toString())) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean isMultipleValue() {
            return true;
        }
    }
    ,
    LIKE(50, "like %?%", "", " LIKE "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            return value.toString().toUpperCase().contains(target.toString().toUpperCase());
        }

        @Override
        public boolean isMultipleValue() {
            return false;
        }
    }
    ,
    LIKE_PREFIX(51, "like ?%", "", " LIKE "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            return value.toString().toUpperCase().startsWith(target.toString().toUpperCase());
        }

        @Override
        public boolean isMultipleValue() {
            return false;
        }
    }
    ,
    START_WITH(51, "like ?%", "", " LIKE "){

        @Override
        public int getCode() {
            return 51;
        }

        @Override
        public String getSQL() {
            return " LIKE ";
        }

        @Override
        public String getName() {
            return "like ?%";
        }

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            return value.toString().toUpperCase().startsWith(target.toString().toUpperCase());
        }

        @Override
        public boolean isMultipleValue() {
            return false;
        }
    }
    ,
    LIKE_SUFFIX(52, "like %?", "", " LIKE "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            return value.toString().toUpperCase().endsWith(target.toString().toUpperCase());
        }

        @Override
        public boolean isMultipleValue() {
            return false;
        }
    }
    ,
    END_WITH(52, "like %?", "", " LIKE "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            return value.toString().toUpperCase().endsWith(target.toString().toUpperCase());
        }

        @Override
        public boolean isMultipleValue() {
            return false;
        }
    }
    ,
    FIND_IN_SET(60, "find in set", "", " FIND_IN_SET "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            String[] arrays = target.toString().split(",");
            return BeanUtil.array2list(new String[][]{arrays}).contains(value);
        }

        @Override
        public boolean isMultipleValue() {
            return false;
        }
    }
    ,
    FIND_IN_SET_OR(61, "find in set", "", " FIND_IN_SET "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            String[] arrays = target.toString().split(",");
            return BeanUtil.array2list(new String[][]{arrays}).contains(value);
        }

        @Override
        public boolean isMultipleValue() {
            return false;
        }
    }
    ,
    FIND_IN_SET_AND(62, "find in set", "", " FIND_IN_SET "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            String[] arrays = target.toString().split(",");
            return BeanUtil.array2list(new String[][]{arrays}).contains(value);
        }

        @Override
        public boolean isMultipleValue() {
            return false;
        }
    }
    ,
    BETWEEN(80, "\u533a\u95f4", "", " BETWEEN ? AND ? "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == value) {
                return false;
            }
            if (target instanceof List) {
                List list = (List)target;
                Object min = list.get(0);
                Object max = list.get(1);
                return this.compare(value, BasicUtil.parseDecimal(min, null), BasicUtil.parseDecimal(max, null));
            }
            return false;
        }

        public boolean compare(Object value, BigDecimal min, BigDecimal max) {
            if (null == value || null == min || null == max) {
                return false;
            }
            try {
                BigDecimal v = new BigDecimal(value.toString());
                if (v.compareTo(min) >= 0 && v.compareTo(max) <= 0) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
            return false;
        }

        @Override
        public boolean isMultipleValue() {
            return true;
        }
    }
    ,
    NULL(90, "\u7a7a", "", " IS NULL "){

        @Override
        public boolean compare(Object value, Object target) {
            return null == value;
        }

        @Override
        public boolean isMultipleValue() {
            return false;
        }
    }
    ,
    NOT_EQUAL(110, "\u4e0d\u7b49\u4e8e", "nin", " != ? "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            return !value.toString().toUpperCase().equals(target.toString().toUpperCase());
        }

        @Override
        public boolean isMultipleValue() {
            return false;
        }
    }
    ,
    NOT_IN(140, "\u4e0d\u5305\u542b", "nin", " NOT IN "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                return col.contains(target);
            }
            return false;
        }

        @Override
        public boolean isMultipleValue() {
            return true;
        }
    }
    ,
    NOT_LIKE(150, "NOT LIKE %?%", "", " NOT LIKE "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                return col.contains(target);
            }
            return false;
        }

        @Override
        public boolean isMultipleValue() {
            return true;
        }
    }
    ,
    NOT_LIKE_PREFIX(151, "NOT LIKE ?%", "", " NOT LIKE "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                return col.contains(target);
            }
            return false;
        }

        @Override
        public boolean isMultipleValue() {
            return true;
        }
    }
    ,
    NOT_START_WITH(151, "NOT LIKE ?%", "", " NOT LIKE "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                return col.contains(target);
            }
            return false;
        }

        @Override
        public boolean isMultipleValue() {
            return true;
        }
    }
    ,
    NOT_LIKE_SUFFIX(152, "NOT LIKE %?", "", " NOT LIKE "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                return col.contains(target);
            }
            return false;
        }

        @Override
        public boolean isMultipleValue() {
            return true;
        }
    }
    ,
    NOT_END_WITH(152, "NOT LIKE %?", "", " NOT LIKE "){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                return col.contains(target);
            }
            return false;
        }

        @Override
        public boolean isMultipleValue() {
            return true;
        }
    }
    ,
    NOT_NULL(190, "\u975e\u7a7a", "", " IS NOT NULL "){

        @Override
        public boolean compare(Object value, Object target) {
            return null != value;
        }

        @Override
        public boolean isMultipleValue() {
            return false;
        }
    }
    ,
    REGEX(999, "\u6b63\u5219", "regex", ""){

        @Override
        public boolean compare(Object value, Object target) {
            if (null == target || null == value) {
                return false;
            }
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                return col.contains(target);
            }
            return false;
        }

        @Override
        public boolean isMultipleValue() {
            return true;
        }
    };

    private final int code;
    private final String operator;
    private final String sql;
    private final String name;

    public boolean compare(Object value) {
        return false;
    }

    public boolean compare(Object value, Object target) {
        return false;
    }

    public boolean compare(Object value, Object min, Object max) {
        return false;
    }

    private Compare(int code, String name, String operator, String sql) {
        this.code = code;
        this.name = name;
        this.sql = sql;
        this.operator = operator;
    }

    public abstract boolean isMultipleValue();

    public String getSQL() {
        return this.sql;
    }

    public String getOperator() {
        return this.operator;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public static enum EMPTY_VALUE_SWITCH {
        IGNORE,
        BREAK,
        NULL,
        SRC,
        NONE;

    }
}

