/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.core.common.spring.security.policies;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.activiti.api.process.model.payloads.GetProcessDefinitionsPayload;
import org.activiti.api.process.model.payloads.GetProcessInstancesPayload;
import org.activiti.api.runtime.shared.identity.UserGroupManager;
import org.activiti.api.runtime.shared.security.SecurityManager;
import org.activiti.core.common.spring.security.policies.BaseSecurityPoliciesManagerImpl;
import org.activiti.core.common.spring.security.policies.ProcessSecurityPoliciesManager;
import org.activiti.core.common.spring.security.policies.SecurityPoliciesProcessDefinitionRestrictionApplier;
import org.activiti.core.common.spring.security.policies.SecurityPoliciesProcessInstanceRestrictionApplier;
import org.activiti.core.common.spring.security.policies.SecurityPoliciesRestrictionApplier;
import org.activiti.core.common.spring.security.policies.SecurityPolicyAccess;
import org.activiti.core.common.spring.security.policies.conf.SecurityPoliciesProperties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ProcessSecurityPoliciesManagerImpl
extends BaseSecurityPoliciesManagerImpl
implements ProcessSecurityPoliciesManager {
    private final SecurityPoliciesProcessDefinitionRestrictionApplier processDefinitionRestrictionApplier;
    private final SecurityPoliciesProcessInstanceRestrictionApplier processInstanceRestrictionApplier;
    @Value(value="${spring.application.name:application}")
    private String applicationName;

    public ProcessSecurityPoliciesManagerImpl(UserGroupManager userGroupManager, SecurityManager securityManager, SecurityPoliciesProperties securityPoliciesProperties, SecurityPoliciesProcessDefinitionRestrictionApplier processDefinitionRestrictionApplier, SecurityPoliciesProcessInstanceRestrictionApplier processInstanceRestrictionApplier) {
        super(userGroupManager, securityManager, securityPoliciesProperties);
        this.processDefinitionRestrictionApplier = processDefinitionRestrictionApplier;
        this.processInstanceRestrictionApplier = processInstanceRestrictionApplier;
    }

    @Override
    public GetProcessDefinitionsPayload restrictProcessDefQuery(SecurityPolicyAccess securityPolicyAccess) {
        return this.restrictQuery(this.processDefinitionRestrictionApplier, securityPolicyAccess);
    }

    private Set<String> definitionKeysAllowedForApplicationPolicy(SecurityPolicyAccess securityPolicyAccess) {
        Map<String, Set<String>> restrictions = this.getAllowedKeys(securityPolicyAccess);
        HashSet<String> keys = new HashSet<String>();
        for (String appName : restrictions.keySet()) {
            if (appName == null || !appName.replace("-", "").equalsIgnoreCase(this.applicationName.replace("-", ""))) continue;
            keys.addAll((Collection<String>)restrictions.get(appName));
        }
        return keys;
    }

    @Override
    public GetProcessInstancesPayload restrictProcessInstQuery(SecurityPolicyAccess securityPolicyAccess) {
        return this.restrictQuery(this.processInstanceRestrictionApplier, securityPolicyAccess);
    }

    private <T> T restrictQuery(SecurityPoliciesRestrictionApplier<T> restrictionApplier, SecurityPolicyAccess securityPolicyAccess) {
        if (!this.arePoliciesDefined()) {
            return restrictionApplier.allowAll();
        }
        Set<String> keys = this.definitionKeysAllowedForApplicationPolicy(securityPolicyAccess);
        if (keys != null && !keys.isEmpty()) {
            if (keys.contains(this.getSecurityPoliciesProperties().getWildcard())) {
                return restrictionApplier.allowAll();
            }
            return restrictionApplier.restrictToKeys(keys);
        }
        if (!this.getSecurityPoliciesProperties().getPolicies().isEmpty()) {
            return restrictionApplier.denyAll();
        }
        return restrictionApplier.allowAll();
    }

    @Override
    public boolean canWrite(String processDefinitionKey) {
        return this.hasPermission(processDefinitionKey, SecurityPolicyAccess.WRITE, this.applicationName);
    }

    @Override
    public boolean canRead(String processDefinitionKey) {
        return this.hasPermission(processDefinitionKey, SecurityPolicyAccess.READ, this.applicationName) || this.hasPermission(processDefinitionKey, SecurityPolicyAccess.WRITE, this.applicationName);
    }

    @Override
    protected boolean anEntryInSetStartsKey(Set<String> keys, String processDefinitionKey) {
        for (String key : keys) {
            if (!processDefinitionKey.equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }
}

