/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.readers.operation;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import springfox.documentation.builders.AuthorizationScopeBuilder;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationBuilderPlugin;
import springfox.documentation.spi.service.contexts.OperationContext;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.swagger.common.SwaggerPluginSupport;

@Component
@Order(value=-2147481648)
public class OpenApiOperationAuthReader
implements OperationBuilderPlugin {
    private static final Logger LOG = LoggerFactory.getLogger(OpenApiOperationAuthReader.class);

    public void apply(OperationContext context) {
        List securityContexts = context.securityContext();
        HashMap<String, SecurityReference> securityReferences = new HashMap<String, SecurityReference>();
        for (SecurityContext each : securityContexts) {
            securityReferences.putAll(each.securityForOperation(context).stream().collect(Collectors.toMap(this.byReferenceName(), Function.identity())));
        }
        this.maybeAddOperationAnnotation(context, securityReferences);
        LOG.debug("Authorization count {} for method {}", (Object)securityReferences.size(), (Object)context.getName());
        context.operationBuilder().authorizations(securityReferences.values());
    }

    private void maybeAddOperationAnnotation(OperationContext context, Map<String, SecurityReference> securityReferences) {
        Optional operationAnnotation = context.findAnnotation(Operation.class);
        operationAnnotation.ifPresent(op -> {
            ArrayList<SecurityReference> securityReferenceOverrides = new ArrayList<SecurityReference>();
            for (SecurityRequirement each : this.securityRequirements((Operation)op)) {
                String name = each.name();
                String[] scopes = each.scopes();
                ArrayList<AuthorizationScope> authorizationScopeList = new ArrayList<AuthorizationScope>();
                for (String eachScope : scopes) {
                    if (StringUtils.isEmpty((Object)eachScope)) continue;
                    authorizationScopeList.add(new AuthorizationScopeBuilder().scope(eachScope).description("").build());
                }
                AuthorizationScope[] authorizationScopes = authorizationScopeList.toArray(new AuthorizationScope[0]);
                SecurityReference securityReference = SecurityReference.builder().reference(name).scopes(authorizationScopes).build();
                securityReferenceOverrides.add(securityReference);
            }
            securityReferences.putAll(securityReferenceOverrides.stream().collect(Collectors.toMap(this.byReferenceName(), Function.identity())));
        });
    }

    private Function<SecurityReference, String> byReferenceName() {
        return SecurityReference::getReference;
    }

    private Collection<SecurityRequirement> securityRequirements(Operation operation) {
        return Stream.of(operation.security()).filter(input -> !StringUtils.isEmpty((Object)input.name())).collect(Collectors.toList());
    }

    public boolean supports(DocumentationType delimiter) {
        return SwaggerPluginSupport.pluginDoesApply(delimiter);
    }
}

