/*
 * Decompiled with CFR 0.152.
 */
package io.springboot.sms.core;

import com.aliyuncs.CommonRequest;
import com.aliyuncs.CommonResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.http.HttpClientConfig;
import com.aliyuncs.http.MethodType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.aliyuncs.utils.StringUtils;
import io.springboot.sms.SmsProperties;
import io.springboot.sms.core.SmsException;
import io.springboot.sms.core.SmsTemplate;
import io.springboot.sms.kit.Utils;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmsClient {
    private static final Logger log = LoggerFactory.getLogger(SmsClient.class);
    private Map<String, IAcsClient> acsClients = new HashMap<String, IAcsClient>();
    private Map<String, SmsTemplate> smsTemplates;

    public SmsClient(SmsProperties smsProperties) {
        if (smsProperties == null || smsProperties.getSms() == null) {
            log.warn("\u963f\u91cc\u4e91\u77ed\u4fe1\u901a\u9053\u672a\u914d\u7f6e,\u77ed\u4fe1\u53d1\u9001\u6682\u4e0d\u53ef\u7528");
            return;
        }
        this.smsTemplates = smsProperties.getSms();
        this.smsTemplates.forEach((k, v) -> {
            String accessKeyId = v.getAccessKeyId();
            String accessKeySecret = v.getAccessKeySecret();
            DefaultProfile clientProfile = DefaultProfile.getProfile((String)"default", (String)accessKeyId, (String)accessKeySecret);
            if (!StringUtils.isEmpty((CharSequence)v.getProxyIp())) {
                HttpClientConfig clientConfig = HttpClientConfig.getDefault();
                clientConfig.setHttpProxy(String.format("http://%s:%s", v.getProxyIp(), v.getProxyPort()));
                clientConfig.setHttpsProxy(String.format("http://%s:%s", v.getProxyIp(), v.getProxyPort()));
                clientProfile.setHttpClientConfig(clientConfig);
            }
            DefaultAcsClient acsClient = new DefaultAcsClient((IClientProfile)clientProfile);
            this.acsClients.put((String)k, (IAcsClient)acsClient);
        });
    }

    public String sendVerificationCode(String code, String ... phoneNumbers) {
        this.checkSmsTemplate();
        Utils.checkPhoneNumber(phoneNumbers);
        int size = this.smsTemplates.size();
        if (size == 0) {
            throw new IllegalArgumentException("Invalid Templates");
        }
        String smsTemplateKey = this.smsTemplates.keySet().iterator().next();
        SmsTemplate smsTemplate = this.smsTemplates.get(smsTemplateKey);
        Objects.requireNonNull(smsTemplate, () -> "SmsTemplate must be not null, key:" + smsTemplateKey);
        smsTemplate.setTemplateCode(smsTemplateKey);
        smsTemplate.setTemplateParam(Collections.singletonMap("code", code));
        smsTemplate.setPhoneNumbers(Arrays.asList(phoneNumbers));
        this.send(smsTemplate);
        return code;
    }

    private boolean checkSmsTemplate() {
        if (this.smsTemplates == null || this.smsTemplates.isEmpty()) {
            log.warn("\u963f\u91cc\u4e91\u77ed\u4fe1\u901a\u9053\u914d\u7f6e\u9519\u8bef,\u77ed\u4fe1\u53d1\u9001\u6682\u4e0d\u53ef\u7528,\u9a8c\u8bc1\u7801\u6ce8\u610f \u65e5\u5fd7\u8f93\u51fa");
            return false;
        }
        return true;
    }

    public String sendCodeByKey(String smsTemplateKey, String code, String ... phoneNumbers) {
        if (!this.checkSmsTemplate()) {
            return null;
        }
        Utils.checkPhoneNumber(phoneNumbers);
        SmsTemplate smsTemplate = this.smsTemplates.get(smsTemplateKey);
        Objects.requireNonNull(smsTemplate, () -> "SmsTemplate must be not null, key:" + smsTemplateKey);
        smsTemplate.setTemplateCode(smsTemplateKey);
        smsTemplate.setTemplateParam(Collections.singletonMap("code", code));
        smsTemplate.setPhoneNumbers(Arrays.asList(phoneNumbers));
        this.send(smsTemplate);
        return code;
    }

    public String sendCode(String code, String ... phoneNumbers) {
        if (!this.checkSmsTemplate()) {
            return null;
        }
        String defaultKey = this.smsTemplates.keySet().iterator().next();
        Utils.checkPhoneNumber(phoneNumbers);
        SmsTemplate smsTemplate = this.smsTemplates.get(defaultKey);
        Objects.requireNonNull(smsTemplate, () -> "SmsTemplate must be not null, key:" + defaultKey);
        smsTemplate.setTemplateCode(defaultKey);
        smsTemplate.setTemplateParam(Collections.singletonMap("code", code));
        smsTemplate.setPhoneNumbers(Arrays.asList(phoneNumbers));
        this.send(smsTemplate);
        return code;
    }

    public void sendParamByKey(String smsTemplateKey, Map<String, String> params, String ... phoneNumbers) {
        if (!this.checkSmsTemplate()) {
            return;
        }
        Utils.checkPhoneNumber(phoneNumbers);
        SmsTemplate smsTemplate = this.smsTemplates.get(smsTemplateKey);
        Objects.requireNonNull(smsTemplate, () -> "SmsTemplate must be not null, key:" + smsTemplateKey);
        smsTemplate.setTemplateCode(smsTemplateKey);
        smsTemplate.setTemplateParam(params);
        smsTemplate.setPhoneNumbers(Arrays.asList(phoneNumbers));
        this.send(smsTemplate);
    }

    public void send(String smsTemplateKey) {
        if (!this.checkSmsTemplate()) {
            return;
        }
        SmsTemplate smsTemplate = this.smsTemplates.get(smsTemplateKey);
        smsTemplate.setTemplateCode(smsTemplateKey);
        Objects.requireNonNull(smsTemplate, () -> "SmsTemplate must be not null, key:" + smsTemplateKey);
        this.send(smsTemplate);
    }

    public void send(String smsTemplateKey, String ... phoneNumbers) {
        if (!this.checkSmsTemplate()) {
            return;
        }
        SmsTemplate smsTemplate = this.smsTemplates.get(smsTemplateKey);
        smsTemplate.setTemplateCode(smsTemplateKey);
        Objects.requireNonNull(smsTemplate, () -> "SmsTemplate must be not null, key:" + smsTemplateKey);
        smsTemplate.setPhoneNumbers(Arrays.asList(phoneNumbers));
        this.send(smsTemplate);
    }

    public void send(SmsTemplate smsTemplate) {
        Objects.requireNonNull(smsTemplate);
        if (!this.checkSmsTemplate()) {
            return;
        }
        CommonRequest request = new CommonRequest();
        request.setSysMethod(MethodType.POST);
        request.setSysDomain("dysmsapi.aliyuncs.com");
        request.setSysVersion("2017-05-25");
        request.setSysAction("SendSms");
        request.putQueryParameter("PhoneNumbers", String.join((CharSequence)",", smsTemplate.getPhoneNumbers()));
        request.putQueryParameter("SignName", smsTemplate.getSignName());
        request.putQueryParameter("TemplateCode", smsTemplate.getTemplateCode());
        request.putQueryParameter("TemplateParam", Utils.toJsonStr(smsTemplate.getTemplateParam()));
        try {
            IAcsClient iAcsClient = this.acsClients.get(smsTemplate.getTemplateCode());
            CommonResponse response = iAcsClient.getCommonResponse(request);
            Utils.checkSmsResponse(response);
        }
        catch (ClientException e) {
            throw new SmsException(e);
        }
    }
}

