/*
 * Decompiled with CFR 0.152.
 */
package io.springboot.sms;

import io.springboot.sms.SmsProperties;
import io.springboot.sms.core.SmsClient;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration
@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(name={"com.aliyuncs.IAcsClient"})
@EnableConfigurationProperties(value={SmsProperties.class})
public class SmsAutoConfiguration {
    private final SmsProperties smsProperties;

    @Bean
    @ConditionalOnMissingBean
    public SmsClient smsClient() {
        return new SmsClient(this.smsProperties);
    }

    public SmsAutoConfiguration(SmsProperties smsProperties) {
        this.smsProperties = smsProperties;
    }
}

