/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.sys.env;

import com.alibaba.nacos.common.JustForTest;
import com.alibaba.nacos.common.utils.IoUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.ThreadUtils;
import com.alibaba.nacos.plugin.environment.CustomEnvironmentPluginManager;
import com.alibaba.nacos.sys.env.OperatingSystemBeanManager;
import com.alibaba.nacos.sys.env.OriginTrackedPropertiesLoader;
import com.alibaba.nacos.sys.utils.DiskUtils;
import com.alibaba.nacos.sys.utils.InetUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class EnvUtil {
    public static final String STANDALONE_MODE_ALONE = "standalone";
    public static final String STANDALONE_MODE_CLUSTER = "cluster";
    public static final String FUNCTION_MODE_CONFIG = "config";
    public static final String FUNCTION_MODE_NAMING = "naming";
    public static final String NACOS_HOME_KEY = "nacos.home";
    private static volatile String localAddress = "";
    private static int port = -1;
    private static Boolean isStandalone = null;
    private static String functionModeType = null;
    private static String contextPath = null;
    private static final String FILE_PREFIX = "file:";
    private static final String SERVER_PORT_PROPERTY = "server.port";
    private static final int DEFAULT_SERVER_PORT = 8848;
    private static final String DEFAULT_WEB_CONTEXT_PATH = "/nacos";
    private static final String MEMBER_LIST_PROPERTY = "nacos.member.list";
    private static final String NACOS_HOME_PROPERTY = "user.home";
    private static final String CUSTOM_CONFIG_LOCATION_PROPERTY = "spring.config.additional-location";
    private static final String DEFAULT_CONFIG_LOCATION = "application.properties";
    private static final String DEFAULT_RESOURCE_PATH = "/application.properties";
    private static final String DEFAULT_ADDITIONAL_PATH = "conf";
    private static final String DEFAULT_ADDITIONAL_FILE = "cluster.conf";
    private static final String NACOS_HOME_ADDITIONAL_FILEPATH = "nacos";
    private static final String NACOS_TEMP_DIR_1 = "data";
    private static final String NACOS_TEMP_DIR_2 = "tmp";
    private static final String NACOS_CUSTOM_ENVIRONMENT_ENABLED = "nacos.custom.environment.enabled";
    private static final String NACOS_CUSTOM_CONFIG_NAME = "customFirstNacosConfig";
    @JustForTest
    private static String confPath = "";
    @JustForTest
    private static String nacosHomePath = null;
    private static ConfigurableEnvironment environment;
    private static String nacosTmpDir;

    public static void customEnvironment() {
        boolean enableCustom = EnvUtil.getProperty(NACOS_CUSTOM_ENVIRONMENT_ENABLED, Boolean.class, false);
        if (enableCustom) {
            Set propertyKeys = CustomEnvironmentPluginManager.getInstance().getPropertyKeys();
            HashMap<String, Object> sourcePropertyMap = new HashMap<String, Object>(propertyKeys.size());
            for (String key : propertyKeys) {
                sourcePropertyMap.put(key, EnvUtil.getProperty(key, Object.class));
            }
            Map targetMap = CustomEnvironmentPluginManager.getInstance().getCustomValues(sourcePropertyMap);
            MutablePropertySources propertySources = environment.getPropertySources();
            propertySources.addFirst((PropertySource)new MapPropertySource(NACOS_CUSTOM_CONFIG_NAME, targetMap));
        }
    }

    public static ConfigurableEnvironment getEnvironment() {
        return environment;
    }

    public static void setEnvironment(ConfigurableEnvironment environment) {
        EnvUtil.environment = environment;
    }

    public static boolean containsProperty(String key) {
        return environment.containsProperty(key);
    }

    public static String getProperty(String key) {
        return environment.getProperty(key);
    }

    public static String getProperty(String key, String defaultValue) {
        return environment.getProperty(key, defaultValue);
    }

    public static <T> T getProperty(String key, Class<T> targetType) {
        return (T)environment.getProperty(key, targetType);
    }

    public static <T> T getProperty(String key, Class<T> targetType, T defaultValue) {
        return (T)environment.getProperty(key, targetType, defaultValue);
    }

    public static String getRequiredProperty(String key) throws IllegalStateException {
        return environment.getRequiredProperty(key);
    }

    public static <T> T getRequiredProperty(String key, Class<T> targetType) throws IllegalStateException {
        return (T)environment.getRequiredProperty(key, targetType);
    }

    public static String resolvePlaceholders(String text) {
        return environment.resolvePlaceholders(text);
    }

    public static String resolveRequiredPlaceholders(String text) throws IllegalArgumentException {
        return environment.resolveRequiredPlaceholders(text);
    }

    public static List<String> getPropertyList(String key) {
        String value;
        ArrayList<String> valueList = new ArrayList<String>();
        for (int i = 0; i < Integer.MAX_VALUE && !StringUtils.isBlank((CharSequence)(value = environment.getProperty(key + "[" + i + "]"))); ++i) {
            valueList.add(value);
        }
        return valueList;
    }

    public static String getLocalAddress() {
        if (StringUtils.isBlank((CharSequence)localAddress)) {
            localAddress = InetUtils.getSelfIP() + ":" + EnvUtil.getPort();
        }
        return localAddress;
    }

    public static void setLocalAddress(String localAddress) {
        EnvUtil.localAddress = localAddress;
    }

    public static int getPort() {
        if (port == -1) {
            port = EnvUtil.getProperty(SERVER_PORT_PROPERTY, Integer.class, 8848);
        }
        return port;
    }

    public static void setPort(int port) {
        EnvUtil.port = port;
    }

    public static String getContextPath() {
        if (Objects.isNull(contextPath) && "/".equals(contextPath = EnvUtil.getProperty("server.servlet.context-path", DEFAULT_WEB_CONTEXT_PATH))) {
            contextPath = "";
        }
        return contextPath;
    }

    public static void setContextPath(String contextPath) {
        EnvUtil.contextPath = contextPath;
    }

    @JustForTest
    public static void setIsStandalone(Boolean isStandalone) {
        EnvUtil.isStandalone = isStandalone;
    }

    public static boolean getStandaloneMode() {
        if (Objects.isNull(isStandalone)) {
            isStandalone = Boolean.getBoolean("nacos.standalone");
        }
        return isStandalone;
    }

    public static String getFunctionMode() {
        if (StringUtils.isEmpty((String)functionModeType)) {
            functionModeType = System.getProperty("nacos.functionMode");
        }
        return functionModeType;
    }

    public static String getNacosTmpDir() {
        if (StringUtils.isBlank((CharSequence)nacosTmpDir)) {
            nacosTmpDir = Paths.get(EnvUtil.getNacosHome(), NACOS_TEMP_DIR_1, NACOS_TEMP_DIR_2).toString();
        }
        return nacosTmpDir;
    }

    public static String getNacosHome() {
        if (StringUtils.isBlank((CharSequence)nacosHomePath)) {
            String nacosHome = System.getProperty(NACOS_HOME_KEY);
            if (StringUtils.isBlank((CharSequence)nacosHome)) {
                nacosHome = Paths.get(System.getProperty(NACOS_HOME_PROPERTY), NACOS_HOME_ADDITIONAL_FILEPATH).toString();
            }
            return nacosHome;
        }
        return nacosHomePath;
    }

    @JustForTest
    public static void setNacosHomePath(String nacosHomePath) {
        EnvUtil.nacosHomePath = nacosHomePath;
    }

    public static List<String> getIPsBySystemEnv(String key) {
        String env = EnvUtil.getSystemEnv(key);
        List<String> ips = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)env)) {
            ips = Arrays.asList(env.split(","));
        }
        return ips;
    }

    public static String getSystemEnv(String key) {
        return System.getenv(key);
    }

    public static float getLoad() {
        return (float)OperatingSystemBeanManager.getOperatingSystemBean().getSystemLoadAverage();
    }

    public static float getCpu() {
        return (float)OperatingSystemBeanManager.getSystemCpuUsage();
    }

    public static float getMem() {
        return 1L - OperatingSystemBeanManager.getFreePhysicalMem() / OperatingSystemBeanManager.getTotalPhysicalMem();
    }

    public static String getConfPath() {
        if (StringUtils.isNotBlank((String)confPath)) {
            return confPath;
        }
        confPath = Paths.get(EnvUtil.getNacosHome(), DEFAULT_ADDITIONAL_PATH).toString();
        return confPath;
    }

    public static void setConfPath(String confPath) {
        EnvUtil.confPath = confPath;
    }

    public static String getClusterConfFilePath() {
        return Paths.get(EnvUtil.getNacosHome(), DEFAULT_ADDITIONAL_PATH, DEFAULT_ADDITIONAL_FILE).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readClusterConf() throws IOException {
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(new File(EnvUtil.getClusterConfFilePath())), StandardCharsets.UTF_8);){
            List<String> list = EnvUtil.analyzeClusterConf(reader);
            return list;
        }
        catch (FileNotFoundException ignore) {
            String[] details;
            ArrayList<String> tmp = new ArrayList<String>();
            String clusters = EnvUtil.getMemberList();
            if (!StringUtils.isNotBlank((String)clusters)) return tmp;
            String[] stringArray = details = clusters.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String item = stringArray[n2];
                tmp.add(item.trim());
                ++n2;
            }
            return tmp;
        }
    }

    public static List<String> analyzeClusterConf(Reader reader) throws IOException {
        ArrayList<String> instanceList = new ArrayList<String>();
        List lines = IoUtils.readLines((Reader)reader);
        String comment = "#";
        for (String line : lines) {
            int multiIndex;
            String instance = line.trim();
            if (instance.startsWith(comment)) continue;
            if (instance.contains(comment)) {
                instance = instance.substring(0, instance.indexOf(comment));
                instance = instance.trim();
            }
            if ((multiIndex = instance.indexOf(",")) > 0) {
                instanceList.addAll(Arrays.asList(instance.split(",")));
                continue;
            }
            instanceList.add(instance);
        }
        return instanceList;
    }

    public static void writeClusterConf(String content) throws IOException {
        DiskUtils.writeFile(new File(EnvUtil.getClusterConfFilePath()), content.getBytes(StandardCharsets.UTF_8), false);
    }

    public static String getMemberList() {
        String val;
        if (environment == null) {
            val = System.getenv(MEMBER_LIST_PROPERTY);
            if (StringUtils.isBlank((CharSequence)val)) {
                val = System.getProperty(MEMBER_LIST_PROPERTY);
            }
        } else {
            val = EnvUtil.getProperty(MEMBER_LIST_PROPERTY);
        }
        return val;
    }

    public static Map<String, ?> loadProperties(Resource resource) throws IOException {
        return new OriginTrackedPropertiesLoader(resource).load();
    }

    public static Resource getApplicationConfFileResource() {
        Resource customResource = EnvUtil.getCustomFileResource();
        return customResource == null ? EnvUtil.getDefaultResource() : customResource;
    }

    private static Resource getCustomFileResource() {
        String path = EnvUtil.getProperty(CUSTOM_CONFIG_LOCATION_PROPERTY);
        if (StringUtils.isNotBlank((String)path) && path.contains(FILE_PREFIX)) {
            String[] paths = path.split(",", -1);
            path = paths[paths.length - 1].substring(FILE_PREFIX.length());
            return EnvUtil.getRelativePathResource(path, DEFAULT_CONFIG_LOCATION);
        }
        return null;
    }

    private static Resource getRelativePathResource(String parentPath, String path) {
        try {
            FileInputStream inputStream = new FileInputStream(Paths.get(parentPath, path).toFile());
            return new InputStreamResource((InputStream)inputStream);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static Resource getDefaultResource() {
        InputStream inputStream = EnvUtil.class.getResourceAsStream(DEFAULT_RESOURCE_PATH);
        return new InputStreamResource(inputStream);
    }

    public static int getAvailableProcessors() {
        int result = EnvUtil.getProperty("nacos.core.sys.basic.processors", Integer.TYPE, ThreadUtils.getSuitableThreadCount((int)1));
        return result > 0 ? result : 1;
    }

    public static int getAvailableProcessors(int multiple) {
        if (multiple < 1) {
            throw new IllegalArgumentException("processors multiple must upper than 1");
        }
        Integer processor = EnvUtil.getProperty("nacos.core.sys.basic.processors", Integer.class);
        return null != processor && processor > 0 ? processor * multiple : ThreadUtils.getSuitableThreadCount((int)multiple);
    }

    public static int getAvailableProcessors(double scale) {
        if (scale < 0.0 || scale > 1.0) {
            throw new IllegalArgumentException("processors scale must between 0 and 1");
        }
        double result = (double)EnvUtil.getProperty("nacos.core.sys.basic.processors", Integer.TYPE, ThreadUtils.getSuitableThreadCount((int)1)).intValue() * scale;
        return result > 1.0 ? (int)result : 1;
    }
}

