/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.prometheus.filter;

import javax.servlet.Filter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authorization.AuthenticatedAuthorizationManager;
import org.springframework.security.authorization.AuthorizationManager;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import org.springframework.security.web.access.intercept.AuthorizationFilter;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.Http403ForbiddenEntryPoint;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

@Configuration
public class PrometheusAuthFilter {
    @Bean
    public FilterRegistrationBean<BasicAuthenticationFilter> basicAuthenticationFilter(AuthenticationManager authenticationManager) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new BasicAuthenticationFilter(authenticationManager));
        registration.addUrlPatterns(new String[]{"/prometheus"});
        registration.setName("prometheusBasicAuthenticationFilter");
        registration.setOrder(2);
        return registration;
    }

    @Bean
    public FilterRegistrationBean<AnonymousAuthenticationFilter> anonymousAuthenticationFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new AnonymousAuthenticationFilter("annony"));
        registration.addUrlPatterns(new String[]{"/prometheus"});
        registration.setName("prometheusAnonymousAuthenticationFilter");
        registration.setOrder(3);
        return registration;
    }

    @Bean
    public FilterRegistrationBean<AuthorizationFilter> authorizationFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new AuthorizationFilter((AuthorizationManager)new AuthenticatedAuthorizationManager()));
        registration.addUrlPatterns(new String[]{"/prometheus"});
        registration.setName("prometheusAuthorizationFilter");
        registration.setOrder(4);
        return registration;
    }

    @Bean
    public FilterRegistrationBean<ExceptionTranslationFilter> exceptionTranslationFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new ExceptionTranslationFilter((AuthenticationEntryPoint)new Http403ForbiddenEntryPoint()));
        registration.addUrlPatterns(new String[]{"/prometheus"});
        registration.setName("prometheusExceptionTranslationFilter");
        registration.setOrder(1);
        return registration;
    }
}

