/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.pojo.instance;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.api.naming.pojo.builder.InstanceBuilder;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.utils.WebUtils;
import com.alibaba.nacos.naming.misc.UtilsAndCommons;
import com.alibaba.nacos.naming.pojo.instance.DefaultInstanceIdGenerator;
import com.alibaba.nacos.naming.pojo.instance.InstanceExtensionHandler;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;

public class HttpRequestInstanceBuilder {
    private final InstanceBuilder actualBuilder = InstanceBuilder.newBuilder();
    private final Collection<InstanceExtensionHandler> handlers = NacosServiceLoader.newServiceInstances(InstanceExtensionHandler.class);
    private boolean defaultInstanceEphemeral = true;

    private HttpRequestInstanceBuilder() {
    }

    public static HttpRequestInstanceBuilder newBuilder() {
        return new HttpRequestInstanceBuilder();
    }

    public Instance build() {
        Instance result = this.actualBuilder.build();
        for (InstanceExtensionHandler each : this.handlers) {
            each.handleExtensionInfo(result);
        }
        this.setInstanceId(result);
        return result;
    }

    public HttpRequestInstanceBuilder setDefaultInstanceEphemeral(boolean defaultInstanceEphemeral) {
        this.defaultInstanceEphemeral = defaultInstanceEphemeral;
        return this;
    }

    public HttpRequestInstanceBuilder setRequest(HttpServletRequest request) throws NacosException {
        for (InstanceExtensionHandler each : this.handlers) {
            each.configExtensionInfoFromRequest(request);
        }
        this.setAttributesToBuilder(request);
        return this;
    }

    private void setAttributesToBuilder(HttpServletRequest request) throws NacosException {
        this.actualBuilder.setServiceName(WebUtils.required((HttpServletRequest)request, (String)"serviceName"));
        this.actualBuilder.setIp(WebUtils.required((HttpServletRequest)request, (String)"ip"));
        this.actualBuilder.setPort(Integer.valueOf(Integer.parseInt(WebUtils.required((HttpServletRequest)request, (String)"port"))));
        this.actualBuilder.setHealthy(Boolean.valueOf(ConvertUtils.toBoolean((String)WebUtils.optional((HttpServletRequest)request, (String)"healthy", (String)"true"))));
        this.actualBuilder.setEphemeral(Boolean.valueOf(ConvertUtils.toBoolean((String)WebUtils.optional((HttpServletRequest)request, (String)"ephemeral", (String)String.valueOf(this.defaultInstanceEphemeral)))));
        this.setWeight(request);
        this.setCluster(request);
        this.setEnabled(request);
        this.setMetadata(request);
    }

    private void setWeight(HttpServletRequest request) throws NacosException {
        double weight = Double.parseDouble(WebUtils.optional((HttpServletRequest)request, (String)"weight", (String)"1"));
        if (weight > 10000.0 || weight < 0.0) {
            throw new NacosException(400, "instance format invalid: The weights range from 0.0 to 10000.0");
        }
        this.actualBuilder.setWeight(Double.valueOf(weight));
    }

    private void setCluster(HttpServletRequest request) {
        String cluster = WebUtils.optional((HttpServletRequest)request, (String)"clusterName", (String)"");
        if (StringUtils.isBlank((CharSequence)cluster)) {
            cluster = WebUtils.optional((HttpServletRequest)request, (String)"cluster", (String)"DEFAULT");
        }
        this.actualBuilder.setClusterName(cluster);
    }

    private void setEnabled(HttpServletRequest request) {
        String enabledString = WebUtils.optional((HttpServletRequest)request, (String)"enabled", (String)"");
        boolean enabled = StringUtils.isBlank((CharSequence)enabledString) ? ConvertUtils.toBoolean((String)WebUtils.optional((HttpServletRequest)request, (String)"enable", (String)"true")) : ConvertUtils.toBoolean((String)enabledString);
        this.actualBuilder.setEnabled(Boolean.valueOf(enabled));
    }

    private void setMetadata(HttpServletRequest request) throws NacosException {
        String metadata = WebUtils.optional((HttpServletRequest)request, (String)"metadata", (String)"");
        if (StringUtils.isNotEmpty((String)metadata)) {
            this.actualBuilder.setMetadata(UtilsAndCommons.parseMetadata(metadata));
        }
    }

    private void setInstanceId(Instance instance) {
        DefaultInstanceIdGenerator idGenerator = new DefaultInstanceIdGenerator(instance.getServiceName(), instance.getClusterName(), instance.getIp(), instance.getPort());
        instance.setInstanceId(idGenerator.generateInstanceId());
    }
}

