/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.healthcheck.heartbeat;

import com.alibaba.nacos.common.task.AbstractExecuteTask;
import com.alibaba.nacos.naming.consistency.KeyBuilder;
import com.alibaba.nacos.naming.core.v2.client.impl.IpPortBasedClient;
import com.alibaba.nacos.naming.core.v2.pojo.HealthCheckInstancePublishInfo;
import com.alibaba.nacos.naming.core.v2.pojo.Service;
import com.alibaba.nacos.naming.healthcheck.NacosHealthCheckTask;
import com.alibaba.nacos.naming.healthcheck.heartbeat.BeatCheckTask;
import com.alibaba.nacos.naming.healthcheck.heartbeat.InstanceBeatCheckTask;
import com.alibaba.nacos.naming.healthcheck.heartbeat.InstanceBeatCheckTaskInterceptorChain;
import com.alibaba.nacos.naming.misc.GlobalConfig;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.sys.utils.ApplicationUtils;
import java.util.Collection;

public class ClientBeatCheckTaskV2
extends AbstractExecuteTask
implements BeatCheckTask,
NacosHealthCheckTask {
    private final IpPortBasedClient client;
    private final String taskId;
    private final InstanceBeatCheckTaskInterceptorChain interceptorChain;

    public ClientBeatCheckTaskV2(IpPortBasedClient client) {
        this.client = client;
        this.taskId = client.getResponsibleId();
        this.interceptorChain = InstanceBeatCheckTaskInterceptorChain.getInstance();
    }

    public GlobalConfig getGlobalConfig() {
        return (GlobalConfig)ApplicationUtils.getBean(GlobalConfig.class);
    }

    @Override
    public String taskKey() {
        return KeyBuilder.buildServiceMetaKey(this.client.getClientId(), String.valueOf(this.client.isEphemeral()));
    }

    @Override
    public String getTaskId() {
        return this.taskId;
    }

    @Override
    public void doHealthCheck() {
        try {
            Collection<Service> services = this.client.getAllPublishedService();
            for (Service each : services) {
                HealthCheckInstancePublishInfo instance = (HealthCheckInstancePublishInfo)this.client.getInstancePublishInfo(each);
                this.interceptorChain.doInterceptor(new InstanceBeatCheckTask(this.client, each, instance));
            }
        }
        catch (Exception e) {
            Loggers.SRV_LOG.warn("Exception while processing client beat time out.", (Throwable)e);
        }
    }

    @Override
    public void run() {
        this.doHealthCheck();
    }

    @Override
    public void passIntercept() {
        this.doHealthCheck();
    }

    @Override
    public void afterIntercept() {
    }
}

