/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.istio.xds;

import com.alibaba.nacos.istio.api.ApiGenerator;
import com.alibaba.nacos.istio.api.ApiGeneratorFactory;
import com.alibaba.nacos.istio.common.AbstractConnection;
import com.alibaba.nacos.istio.common.Event;
import com.alibaba.nacos.istio.common.NacosResourceManager;
import com.alibaba.nacos.istio.common.ResourceSnapshot;
import com.alibaba.nacos.istio.common.WatchedStatus;
import com.alibaba.nacos.istio.misc.Loggers;
import com.alibaba.nacos.istio.util.NonceGenerator;
import com.alibaba.nacos.istio.xds.XdsConnection;
import io.envoyproxy.envoy.service.discovery.v3.AggregatedDiscoveryServiceGrpc;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest;
import io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse;
import io.grpc.stub.StreamObserver;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NacosXdsService
extends AggregatedDiscoveryServiceGrpc.AggregatedDiscoveryServiceImplBase {
    private final Map<String, AbstractConnection<DiscoveryResponse>> connections = new ConcurrentHashMap<String, AbstractConnection<DiscoveryResponse>>(16);
    @Autowired
    ApiGeneratorFactory apiGeneratorFactory;
    @Autowired
    NacosResourceManager resourceManager;

    public boolean hasClientConnection() {
        return this.connections.size() != 0;
    }

    public StreamObserver<DiscoveryRequest> streamAggregatedResources(final StreamObserver<DiscoveryResponse> responseObserver) {
        this.resourceManager.initResourceSnapshot();
        final XdsConnection newConnection = new XdsConnection(responseObserver);
        return new StreamObserver<DiscoveryRequest>(){
            private boolean initRequest = true;

            public void onNext(DiscoveryRequest discoveryRequest) {
                if (this.initRequest) {
                    newConnection.setConnectionId(discoveryRequest.getNode().getId());
                    NacosXdsService.this.connections.put(newConnection.getConnectionId(), newConnection);
                    this.initRequest = false;
                }
                NacosXdsService.this.process(discoveryRequest, newConnection);
            }

            public void onError(Throwable throwable) {
                Loggers.MAIN.error("xds: {} stream error.", (Object)newConnection.getConnectionId(), (Object)throwable);
                this.clear();
            }

            public void onCompleted() {
                Loggers.MAIN.info("xds: {} stream close.", (Object)newConnection.getConnectionId());
                responseObserver.onCompleted();
                this.clear();
            }

            private void clear() {
                NacosXdsService.this.connections.remove(newConnection.getConnectionId());
            }
        };
    }

    public void process(DiscoveryRequest discoveryRequest, AbstractConnection<DiscoveryResponse> connection) {
        if (!this.shouldPush(discoveryRequest, connection)) {
            return;
        }
        DiscoveryResponse response = this.buildDiscoveryResponse(discoveryRequest.getTypeUrl(), this.resourceManager.getResourceSnapshot());
        connection.push(response, connection.getWatchedStatusByType(discoveryRequest.getTypeUrl()));
    }

    private boolean shouldPush(DiscoveryRequest discoveryRequest, AbstractConnection<DiscoveryResponse> connection) {
        String type = discoveryRequest.getTypeUrl();
        String connectionId = connection.getConnectionId();
        if (type.equals("core/v1alpha1/MeshConfig")) {
            Loggers.MAIN.info("xds: type {} should be ignored.", (Object)type);
            return false;
        }
        if (discoveryRequest.getErrorDetail().getCode() != 0) {
            Loggers.MAIN.error("xds: ACK error, connection-id: {}, code: {}, message: {}", new Object[]{connectionId, discoveryRequest.getErrorDetail().getCode(), discoveryRequest.getErrorDetail().getMessage()});
            return false;
        }
        if (discoveryRequest.getResponseNonce().isEmpty()) {
            Loggers.MAIN.info("xds: init request, type {}, connection-id {}, version {}", new Object[]{type, connectionId, discoveryRequest.getVersionInfo()});
            WatchedStatus watchedStatus = new WatchedStatus();
            watchedStatus.setType(discoveryRequest.getTypeUrl());
            connection.addWatchedResource(discoveryRequest.getTypeUrl(), watchedStatus);
            return true;
        }
        WatchedStatus watchedStatus = connection.getWatchedStatusByType(discoveryRequest.getTypeUrl());
        if (watchedStatus == null) {
            Loggers.MAIN.info("xds: reconnect, type {}, connection-id {}, version {}, nonce {}.", new Object[]{type, connectionId, discoveryRequest.getVersionInfo(), discoveryRequest.getResponseNonce()});
            watchedStatus = new WatchedStatus();
            watchedStatus.setType(discoveryRequest.getTypeUrl());
            connection.addWatchedResource(discoveryRequest.getTypeUrl(), watchedStatus);
            return true;
        }
        if (!watchedStatus.getLatestNonce().equals(discoveryRequest.getResponseNonce())) {
            Loggers.MAIN.warn("xds: request dis match, type {}, connection-id {}", (Object)discoveryRequest.getTypeUrl(), (Object)connection.getConnectionId());
            return false;
        }
        watchedStatus.setAckedVersion(discoveryRequest.getVersionInfo());
        watchedStatus.setAckedNonce(discoveryRequest.getResponseNonce());
        Loggers.MAIN.info("xds: ack, type {}, connection-id {}, version {}, nonce {}", new Object[]{type, connectionId, discoveryRequest.getVersionInfo(), discoveryRequest.getResponseNonce()});
        return false;
    }

    public void handleEvent(ResourceSnapshot resourceSnapshot, Event event) {
        switch (event.getType()) {
            case Service: {
                if (this.connections.size() == 0) {
                    return;
                }
                Loggers.MAIN.info("xds: event {} trigger push.", (Object)event.getType());
                DiscoveryResponse serviceEntryResponse = this.buildDiscoveryResponse("networking.istio.io/v1alpha3/ServiceEntry", resourceSnapshot);
                for (AbstractConnection<DiscoveryResponse> connection : this.connections.values()) {
                    WatchedStatus watchedStatus = connection.getWatchedStatusByType("networking.istio.io/v1alpha3/ServiceEntry");
                    if (watchedStatus == null) continue;
                    connection.push(serviceEntryResponse, watchedStatus);
                }
                break;
            }
            case Endpoint: {
                Loggers.MAIN.warn("Currently, endpoint event is not supported.");
                break;
            }
            default: {
                Loggers.MAIN.warn("Invalid event {}, ignore it.", (Object)event.getType());
            }
        }
    }

    private DiscoveryResponse buildDiscoveryResponse(String type, ResourceSnapshot resourceSnapshot) {
        ApiGenerator<?> serviceEntryGenerator = this.apiGeneratorFactory.getApiGenerator(type);
        List<?> rawResources = serviceEntryGenerator.generate(resourceSnapshot);
        String nonce = NonceGenerator.generateNonce();
        return DiscoveryResponse.newBuilder().setTypeUrl(type).addAllResources(rawResources).setVersionInfo(resourceSnapshot.getVersion()).setNonce(nonce).build();
    }
}

