/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.utils;

import com.alibaba.nacos.common.http.HttpUtils;
import com.alibaba.nacos.core.utils.ReuseHttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.support.StandardMultipartHttpServletRequest;

public class ReuseUploadFileHttpServletRequest
extends StandardMultipartHttpServletRequest
implements ReuseHttpRequest {
    private static final String DEFAULT_FILE_NAME = "file";
    private final HttpServletRequest request;
    private Map<String, String[]> stringMap;

    public ReuseUploadFileHttpServletRequest(HttpServletRequest request) throws MultipartException {
        super(request);
        this.request = request;
        this.stringMap = this.toDuplication(request);
    }

    public Map<String, String[]> getParameterMap() {
        return this.stringMap;
    }

    public String getParameter(String name) {
        String[] values = this.stringMap.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public String[] getParameterValues(String name) {
        return this.stringMap.get(name);
    }

    @Override
    public Object getBody() throws Exception {
        MultipartFile target = super.getFile(DEFAULT_FILE_NAME);
        if (Objects.nonNull(target)) {
            LinkedMultiValueMap parts = new LinkedMultiValueMap();
            parts.add((Object)DEFAULT_FILE_NAME, (Object)target.getResource());
            return parts;
        }
        return HttpUtils.encodingParams((Map)HttpUtils.translateParameterMap(this.stringMap), (String)StandardCharsets.UTF_8.name());
    }
}

