/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.grpc;

import io.grpc.netty.shaded.io.grpc.netty.GrpcHttp2ConnectionHandler;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiator;
import io.grpc.netty.shaded.io.grpc.netty.InternalProtocolNegotiators;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiationEvent;
import io.grpc.netty.shaded.io.netty.buffer.ByteBuf;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandler;
import io.grpc.netty.shaded.io.netty.channel.ChannelHandlerContext;
import io.grpc.netty.shaded.io.netty.handler.codec.ByteToMessageDecoder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslHandler;
import io.grpc.netty.shaded.io.netty.util.AsciiString;
import java.lang.reflect.Field;
import java.util.List;

public class OptionalTlsProtocolNegotiator
implements InternalProtocolNegotiator.ProtocolNegotiator {
    private static final int MAGIC_VALUE = 5;
    private SslContext sslContext;

    public OptionalTlsProtocolNegotiator(SslContext sslContext) {
        this.sslContext = sslContext;
    }

    public AsciiString scheme() {
        return AsciiString.of((CharSequence)"https");
    }

    public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHttp2ConnectionHandler) {
        ChannelHandler plaintext = InternalProtocolNegotiators.serverPlaintext().newHandler(grpcHttp2ConnectionHandler);
        ChannelHandler ssl = InternalProtocolNegotiators.serverTls((SslContext)this.sslContext).newHandler(grpcHttp2ConnectionHandler);
        PortUnificationServerHandler decoder = new PortUnificationServerHandler(ssl, plaintext);
        return decoder;
    }

    public void close() {
    }

    private ProtocolNegotiationEvent getDefPne() {
        ProtocolNegotiationEvent protocolNegotiationEvent = null;
        try {
            Field aDefault = ProtocolNegotiationEvent.class.getDeclaredField("DEFAULT");
            aDefault.setAccessible(true);
            return (ProtocolNegotiationEvent)aDefault.get(protocolNegotiationEvent);
        }
        catch (Exception e) {
            e.printStackTrace();
            return protocolNegotiationEvent;
        }
    }

    public class PortUnificationServerHandler
    extends ByteToMessageDecoder {
        private ProtocolNegotiationEvent pne;
        private final ChannelHandler ssl;
        private final ChannelHandler plaintext;

        public PortUnificationServerHandler(ChannelHandler ssl, ChannelHandler plaintext) {
            this.ssl = ssl;
            this.plaintext = plaintext;
            this.pne = OptionalTlsProtocolNegotiator.this.getDefPne();
        }

        private boolean isSsl(ByteBuf buf) {
            return SslHandler.isEncrypted((ByteBuf)buf);
        }

        protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
            if (in.readableBytes() < 5) {
                return;
            }
            if (this.isSsl(in)) {
                ctx.pipeline().addAfter(ctx.name(), (String)null, this.ssl);
                ctx.fireUserEventTriggered((Object)this.pne);
                ctx.pipeline().remove((ChannelHandler)this);
            } else {
                ctx.pipeline().addAfter(ctx.name(), (String)null, this.plaintext);
                ctx.fireUserEventTriggered((Object)this.pne);
                ctx.pipeline().remove((ChannelHandler)this);
            }
        }
    }
}

