/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.grpc;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.remote.ConnectionManager;
import com.alibaba.nacos.core.remote.grpc.GrpcServerConstants;
import com.alibaba.nacos.core.utils.Loggers;
import io.grpc.Attributes;
import io.grpc.Grpc;
import io.grpc.ServerTransportFilter;
import java.net.InetSocketAddress;

public class AddressTransportFilter
extends ServerTransportFilter {
    private final ConnectionManager connectionManager;

    public AddressTransportFilter(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    public Attributes transportReady(Attributes transportAttrs) {
        InetSocketAddress remoteAddress = (InetSocketAddress)transportAttrs.get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
        InetSocketAddress localAddress = (InetSocketAddress)transportAttrs.get(Grpc.TRANSPORT_ATTR_LOCAL_ADDR);
        int remotePort = remoteAddress.getPort();
        int localPort = localAddress.getPort();
        String remoteIp = remoteAddress.getAddress().getHostAddress();
        Attributes attrWrapper = transportAttrs.toBuilder().set(GrpcServerConstants.ATTR_TRANS_KEY_CONN_ID, (Object)(System.currentTimeMillis() + "_" + remoteIp + "_" + remotePort)).set(GrpcServerConstants.ATTR_TRANS_KEY_REMOTE_IP, (Object)remoteIp).set(GrpcServerConstants.ATTR_TRANS_KEY_REMOTE_PORT, (Object)remotePort).set(GrpcServerConstants.ATTR_TRANS_KEY_LOCAL_PORT, (Object)localPort).build();
        String connectionId = (String)attrWrapper.get(GrpcServerConstants.ATTR_TRANS_KEY_CONN_ID);
        Loggers.REMOTE_DIGEST.info("Connection transportReady,connectionId = {} ", (Object)connectionId);
        return attrWrapper;
    }

    public void transportTerminated(Attributes transportAttrs) {
        String connectionId = null;
        try {
            connectionId = (String)transportAttrs.get(GrpcServerConstants.ATTR_TRANS_KEY_CONN_ID);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isNotBlank(connectionId)) {
            Loggers.REMOTE_DIGEST.info("Connection transportTerminated,connectionId = {} ", (Object)connectionId);
            this.connectionManager.unregister(connectionId);
        }
    }
}

