/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.core;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.request.ServerLoaderInfoRequest;
import com.alibaba.nacos.api.remote.response.ServerLoaderInfoResponse;
import com.alibaba.nacos.core.remote.ConnectionManager;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServerLoaderInfoRequestHandler
extends RequestHandler<ServerLoaderInfoRequest, ServerLoaderInfoResponse> {
    @Autowired
    private ConnectionManager connectionManager;

    @Override
    public ServerLoaderInfoResponse handle(ServerLoaderInfoRequest request, RequestMeta meta) throws NacosException {
        ServerLoaderInfoResponse serverLoaderInfoResponse = new ServerLoaderInfoResponse();
        serverLoaderInfoResponse.putMetricsValue("conCount", String.valueOf(this.connectionManager.currentClientsCount()));
        HashMap<String, String> filter = new HashMap<String, String>(2);
        filter.put("source", "sdk");
        serverLoaderInfoResponse.putMetricsValue("sdkConCount", String.valueOf(this.connectionManager.currentClientsCount(filter)));
        serverLoaderInfoResponse.putMetricsValue("load", String.valueOf(EnvUtil.getLoad()));
        serverLoaderInfoResponse.putMetricsValue("cpu", String.valueOf(EnvUtil.getCpu()));
        return serverLoaderInfoResponse;
    }
}

