/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote;

import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.control.TpsControlConfig;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.plugin.control.ControlManagerCenter;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Service;

@Service
public class RequestHandlerRegistry
implements ApplicationListener<ContextRefreshedEvent> {
    Map<String, RequestHandler> registryHandlers = new HashMap<String, RequestHandler>();

    public RequestHandler getByRequestType(String requestType) {
        return this.registryHandlers.get(requestType);
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        Map beansOfType = event.getApplicationContext().getBeansOfType(RequestHandler.class);
        Collection values = beansOfType.values();
        for (RequestHandler requestHandler : values) {
            Class<?> clazz = requestHandler.getClass();
            boolean skip = false;
            while (!clazz.getSuperclass().equals(RequestHandler.class)) {
                if (clazz.getSuperclass().equals(Object.class)) {
                    skip = true;
                    break;
                }
                clazz = clazz.getSuperclass();
            }
            if (skip) continue;
            try {
                Method method = clazz.getMethod("handle", Request.class, RequestMeta.class);
                if (method.isAnnotationPresent(TpsControl.class) && TpsControlConfig.isTpsControlEnabled()) {
                    TpsControl tpsControl = method.getAnnotation(TpsControl.class);
                    String pointName = tpsControl.pointName();
                    ControlManagerCenter.getInstance().getTpsControlManager().registerTpsPoint(pointName);
                }
            }
            catch (Exception method) {
                // empty catch block
            }
            Class tClass = (Class)((ParameterizedType)clazz.getGenericSuperclass()).getActualTypeArguments()[0];
            this.registryHandlers.putIfAbsent(tClass.getSimpleName(), requestHandler);
        }
    }
}

