/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.distro.task.delay;

import com.alibaba.nacos.common.task.AbstractDelayTask;
import com.alibaba.nacos.consistency.DataOperation;
import com.alibaba.nacos.core.distributed.distro.entity.DistroKey;

public class DistroDelayTask
extends AbstractDelayTask {
    private final DistroKey distroKey;
    private DataOperation action;
    private long createTime;

    public DistroDelayTask(DistroKey distroKey, long delayTime) {
        this(distroKey, DataOperation.CHANGE, delayTime);
    }

    public DistroDelayTask(DistroKey distroKey, DataOperation action, long delayTime) {
        this.distroKey = distroKey;
        this.action = action;
        this.createTime = System.currentTimeMillis();
        this.setLastProcessTime(this.createTime);
        this.setTaskInterval(delayTime);
    }

    public DistroKey getDistroKey() {
        return this.distroKey;
    }

    public DataOperation getAction() {
        return this.action;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public void merge(AbstractDelayTask task) {
        if (!(task instanceof DistroDelayTask)) {
            return;
        }
        DistroDelayTask oldTask = (DistroDelayTask)task;
        if (!this.action.equals((Object)oldTask.getAction()) && this.createTime < oldTask.getCreateTime()) {
            this.action = oldTask.getAction();
            this.createTime = oldTask.getCreateTime();
        }
        this.setLastProcessTime(oldTask.getLastProcessTime());
    }
}

